/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

#if !defined(AFX_OPTIONSHEET_H__EED9EF66_CEA7_11D2_B8D5_0000861E056C__INCLUDED_)
#define AFX_OPTIONSHEET_H__EED9EF66_CEA7_11D2_B8D5_0000861E056C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// OptionSheet.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// COptionSheet

class COptionSheet : public CPropertySheet
{
	DECLARE_DYNAMIC(COptionSheet)

// Construction
public:
	COptionSheet(UINT nIDCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);
	COptionSheet(LPCTSTR pszCaption, CWnd* pParentWnd = NULL, UINT iSelectPage = 0);

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COptionSheet)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~COptionSheet();

	// Generated message map functions
protected:
	//{{AFX_MSG(COptionSheet)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
// CHcsCfgPage dialog

class CHcsCfgPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CHcsCfgPage)

// Construction
public:
	CHcsCfgPage();
	~CHcsCfgPage();

	// Dialog Data
	//{{AFX_DATA(CHcsCfgPage)
	enum { IDD = IDD_HCSCFG };
	long	m_nbMCIR;
	long	m_nbLCD;
	long	m_nbDIO;
	long	m_nbAMAN;
	long	m_nbBUFIO;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CHcsCfgPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	long		m_nActiveTab;
	CListCtrl	*m_pX10Ctrl, *m_pInputsCtrl, *m_pOutputsCtrl, *m_pNetbitsCtrl,
				*m_pADCsCtrl, *m_pDACsCtrl, *m_pVarsCtrl, *m_pTimersCtrl, *m_pLogIdsCtrl;

	void AddTab(int nID, CTabCtrl* pCtrl);
	CListCtrl* CopyList(CListCtrl* pOldCtrl, int nNewID);
	void UpdateConfigList(CListCtrl* pList, int nID);
	void UpdateConfigFromList(CListCtrl* pList, int nID);

	// Generated message map functions
	//{{AFX_MSG(CHcsCfgPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeIoSelect(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnEndlabeledit(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CMiscCfgPage dialog

class CMiscCfgPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CMiscCfgPage)

// Construction
public:
	CMiscCfgPage();
	~CMiscCfgPage();

// Dialog Data
	//{{AFX_DATA(CMiscCfgPage)
	enum { IDD = IDD_GENCFG };
	CString	m_port;
	BOOL	m_usingModem;
	CString	m_modemInit;
	CString	m_soundConnected;
	CString	m_soundFailure;
	CString	m_soundIoError;
	CString	m_soundSuccess;
	BOOL	m_soundsEnabled;
	UINT	m_tcpPort;
	BOOL	m_autoConnect;
	BOOL	m_autoViewStatus;
	//}}AFX_DATA

	long	m_timeUpdatePeriod;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CMiscCfgPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void SelectSoundFile(CString &str);

	// Generated message map functions
	//{{AFX_MSG(CMiscCfgPage)
	afx_msg void OnTimeNever();
	afx_msg void OnTimeSlow();
	afx_msg void OnTimeFast();
	virtual BOOL OnInitDialog();
	afx_msg void OnButtonConnect();
	afx_msg void OnButtonFailure();
	afx_msg void OnButtonIoError();
	afx_msg void OnButtonSuccess();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
/////////////////////////////////////////////////////////////////////////////
// CXpressCfgPage dialog

class CXpressCfgPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CXpressCfgPage)

// Construction
public:
	CXpressCfgPage();
	~CXpressCfgPage();

// Dialog Data
	//{{AFX_DATA(CXpressCfgPage)
	enum { IDD = IDD_XPRESSCFG };
	CString	m_bin2xpress_path;
	CString	m_xpressCompiler_path;
	BOOL	m_addHcsConfig;
	CString	m_HcsMacroPath;
	long	m_macroTimeout;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CXpressCfgPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CXpressCfgPage)
	afx_msg void OnButtonBin();
	afx_msg void OnButtonXpress();
	afx_msg void OnButtonMacro();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CLogCfgPage dialog

class CLogCfgPage : public CPropertyPage
{
	DECLARE_DYNCREATE(CLogCfgPage)

// Construction
public:
	CLogCfgPage();
	~CLogCfgPage();

// Dialog Data
	//{{AFX_DATA(CLogCfgPage)
	enum { IDD = IDD_LOGCFG };
	long	m_logUpdatePeriod;
	BOOL	m_logAutoClear;
	BOOL	m_OdbcEnable;
	CString	m_OdbcDSN;
	CString	m_OdbcTable;
	BOOL	m_OdbcUpdAtConnect;
	UINT	m_OdbcUpdateFreq;
	BOOL	m_autoUpload;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CLogCfgPage)
	public:
	virtual void OnOK();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CLogCfgPage)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPTIONSHEET_H__EED9EF66_CEA7_11D2_B8D5_0000861E056C__INCLUDED_)
