/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// LogSheet.cpp : implementation file
//

#include "stdafx.h"
#include "WinHcs.h"
#include "LogSheet.h"

#include "HcsRecordset.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CLogSheet

IMPLEMENT_DYNAMIC(CLogSheet, CPropertySheet)

CLogSheet::CLogSheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
}

CLogSheet::CLogSheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
}

CLogSheet::~CLogSheet()
{
}

void CLogSheet::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CPropertySheet::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CLogSheet, CPropertySheet)
	//{{AFX_MSG_MAP(CLogSheet)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLogChartPage property page

IMPLEMENT_DYNCREATE(CLogChartPage, CPropertyPage)

CLogChartPage::CLogChartPage() : CPropertyPage(CLogChartPage::IDD)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	//{{AFX_DATA_INIT(CLogChartPage)
	m_dateFrom = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_FROM, "");
	m_dateTo = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_TO, "");
	m_expression = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_EXP, "");
	m_logID1 = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_1, "");
	m_logID2 = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_2, "");
	//}}AFX_DATA_INIT

	m_dataFromHcs = pApp->GetProfileLong(IDS_REG_SETTINGS, IDS_REG_LOG_DATA_SRC, TRUE);
}

CLogChartPage::~CLogChartPage()
{
}

void CLogChartPage::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CPropertyPage::OnFinalRelease();
}

void CLogChartPage::DoDataExchange(CDataExchange* pDX)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CLogChartPage)
	DDX_Control(pDX, IDC_MSCHART, m_chartControl);
	DDX_Text(pDX, IDC_DATE_FROM, m_dateFrom);
	DDX_Text(pDX, IDC_DATE_TO, m_dateTo);
	DDX_Text(pDX, IDC_EXPRESSION, m_expression);
	DDX_CBString(pDX, IDC_LOGID_1, m_logID1);
	DDX_CBString(pDX, IDC_LOGID_2, m_logID2);
	//}}AFX_DATA_MAP

	if (pDX->m_bSaveAndValidate == TRUE) {

		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_FROM, m_dateFrom);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_TO, m_dateTo);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_EXP, m_expression);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_1, m_logID1);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_2, m_logID2);
		pApp->SetProfileLong(IDS_REG_SETTINGS, IDS_REG_LOG_DATA_SRC, m_dataFromHcs);
	}
}


BEGIN_MESSAGE_MAP(CLogChartPage, CPropertyPage)
	//{{AFX_MSG_MAP(CLogChartPage)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, OnButtonRefresh)
	ON_BN_CLICKED(IDC_BUTTON_UPLOAD, OnButtonUpload)
	ON_BN_CLICKED(IDC_RADIO_DB, OnChartRadioDb)
	ON_BN_CLICKED(IDC_RADIO_HCS, OnChartRadioHcs)
	ON_CBN_SELCHANGE(IDC_LOGID_1, OnButtonRefresh)
	ON_CBN_SELCHANGE(IDC_LOGID_2, OnButtonRefresh)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLogChartPage message handlers


BOOL CLogChartPage::OnInitDialog() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CHcsIo				*pIo  = pDoc->GetHcsLogIDs();
	CComboBox			*pBox1, *pBox2;
	CWnd				*pCheck;
	CString				str;
	long				i = 0, pos = 0, idx = 0, idx2 = 0;

	CPropertyPage::OnInitDialog();
	
	if (pDoc->m_OdbcEnable == FALSE) {

		pCheck = GetDlgItem(IDC_RADIO_DB);
		pCheck->EnableWindow(FALSE);

		m_dataFromHcs = TRUE;
	}

	if (m_dataFromHcs == TRUE) {

		pCheck = GetDlgItem(IDC_RADIO_HCS);
		((CButton *) pCheck)->SetCheck(1);

		pCheck = GetDlgItem(IDC_RADIO_DB);
		((CButton *) pCheck)->SetCheck(0);

		OnChartRadioHcs();

	} else {

		pCheck = GetDlgItem(IDC_RADIO_HCS);
		((CButton *) pCheck)->SetCheck(0);

		pCheck = GetDlgItem(IDC_RADIO_DB);
		((CButton *) pCheck)->SetCheck(1);

		OnChartRadioDb();
	}

	pBox1  = (CComboBox *) GetDlgItem(IDC_LOGID_1);
	pBox2  = (CComboBox *) GetDlgItem(IDC_LOGID_2);

	// Fillout combobox with log ID names
	if (pIo->GetFirstIoLabel(&str, &pos) == TRUE) {

		i = pBox1->AddString(str);
		if (str == m_logID1)
			idx = i;

		i = pBox2->AddString(str);
		if (str == m_logID2)
			idx2 = i;

		while (pIo->GetNextIoLabel(&str, &pos) == TRUE) {

			i = pBox1->AddString(str);
			if (str == m_logID1)
				idx = i;

			i = pBox2->AddString(str);
			if (str == m_logID2)
				idx2 = i;
		}
	}
	pBox1->SetCurSel(idx);
	pBox2->SetCurSel(idx2);

	m_chartControl.SetColumnCount(0);
	m_chartControl.SetRowCount(0);
	m_chartControl.SetTitleText(_T(""));

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLogChartPage::OnButtonUpload() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	if (m_dataFromHcs == TRUE)
		pApp->OnCommandsLogdataGet();
	else
		pApp->OnCommandsLogdataStorelogbuffer();
}




void CLogChartPage::OnButtonRefresh() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CMainFrame			*pFrame = (CMainFrame*) AfxGetMainWnd();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CHcsIo				*pIO = pDoc->GetHcsLogIDs();
	CScriptControl		*scriptP = pFrame->GetScriptControl(FALSE);
	BOOL				bVal;
	CTime				tm;
	short				row;
	long				id, value, selID;
	CString				str;
	char				*expP = NULL, *sP;
	VARIANT				var;

	BeginWaitCursor();

	UpdateData(TRUE);

	scriptP->SetAllowUI(TRUE);
	scriptP->SetLanguage(_T("VBScript"));
	scriptP->SetState(TRUE);
	scriptP->SetUseSafeSubset(FALSE);

	// Get selected ID and Setup script control to be used for expression
	if ((value = m_logID1.GetLength()) > 1)
		selID = atol(m_logID1.GetBuffer(value));
	else
		selID = -1;


	if ((value = m_expression.GetLength()) > 0)
		expP = m_expression.GetBuffer(value);


//	m_chartControl.SetTitleText(_T("Logged Data"));
//	m_chartControl.SetShowLegend(TRUE);

	m_chartControl.SetColumnCount(1);
	m_chartControl.SetRowCount(0);

	m_chartControl.SetColumn(1);


	// Set legends
	if ((sP = pIO->GetIoLabel(selID)) == NULL)	str.Format(_T("Log ID %d"), selID);
	else										str.Format(_T("%s"), sP);
	m_chartControl.SetColumnLabel(str);


	// Do we get the data from the database or HCS logged data
	if (m_dataFromHcs == TRUE) {

		// Scan through all log records
		bVal = pDoc->GetFirstLogEntry(tm, &id, &value);
		row  = 1;

		while (bVal == TRUE) {

			// 1st Series
			if (id == selID) {

				m_chartControl.SetRowCount(row);
				m_chartControl.SetRowLabelCount(row);

				m_chartControl.SetRow(row);

				str = tm.Format(_T("%m/%d/%y %H:%M:%S"));
				m_chartControl.SetRowLabel(str);

				if (expP != NULL) {

					char	buf[32];

					str = m_expression;

					sprintf(buf, _T("%d"), id);
					str.Replace(_T("#ID"), buf);

					sprintf(buf, _T("%d"), value);
					str.Replace(_T("#VALUE"), buf);

					var = scriptP->Eval(str);

					if (var.vt == VT_BSTR) {
						CString s(var.bstrVal);
						str = s;
					} else if (var.vt == VT_I2) {
						str.Format(_T("%d"), (long) var.iVal);
					} else if (var.vt == VT_I4) {
						str.Format(_T("%d"), (long) var.lVal);
					} else if (var.vt == VT_R4) {
						str.Format(_T("%g"), (double) var.fltVal);
					} else if (var.vt == VT_R8) {
						str.Format(_T("%g"), (double) var.dblVal);
					} else str = _T("");

				} else
					str.Format(_T("%d"), value);

				m_chartControl.SetData(str);

				row++;
			}

			// Get next record
			bVal = pDoc->GetNextLogEntry(tm, &id, &value);
		}

	} else	{		// Get data from database

		CDatabase		db;
		CHcsRecordset	dbRec;

		// Setup Filter mechanism
		if (m_dateFrom.IsEmpty() == TRUE) {

			if (m_dateTo.IsEmpty() == FALSE)
				dbRec.m_strFilter.Format(_T("EventID = %d AND EventDateTime <= #%s#"), selID, m_dateTo);
			else
				dbRec.m_strFilter.Format(_T("EventID = %d"), selID);

		} else {

			if (m_dateTo.IsEmpty() == TRUE)
				dbRec.m_strFilter.Format(_T("EventID = %d AND EventDateTime >= #%s#"), selID, m_dateFrom);
			else
				dbRec.m_strFilter.Format(_T("EventID = %d AND EventDateTime >= #%s# AND EventDateTime <= #%s#"),
					selID, m_dateFrom, m_dateTo);
		}


		// Try opening the database
		try {
			if (db.IsOpen() == FALSE)
				db.Open(pDoc->m_OdbcDSN.GetBuffer(80), FALSE, FALSE, _T("ODBC;"), TRUE);
		}
		catch(CDBException *pEx)
		{
			CString str( _T("Could not open database. ") );
			str += pEx->m_strError;

			EndWaitCursor();

			AfxMessageBox(str);
			pEx->Delete();

			return;
		}

		// Open the recordset and fetch the items
		try {
			if (dbRec.IsOpen() == FALSE)
				dbRec.Open(AFX_DB_USE_DEFAULT_TYPE, pDoc->m_OdbcTable.GetBuffer(80), 0);
		}
		catch(CDBException *pEx)
		{
			CString str( _T("Could not open database table. ") );
			str += pEx->m_strError;

			db.Close();

			EndWaitCursor();

			AfxMessageBox(str);
			pEx->Delete();

			return;
		}

		// Scan through all log records
		row  = 1;

		while ( !dbRec.IsEOF() ) {

			m_chartControl.SetRowCount(row);
			m_chartControl.SetRowLabelCount(row);

			m_chartControl.SetRow(row);

			str.Format(_T("%d/%d/%d %d:%d:%d"), 
				dbRec.m_EventDateTime.month,
				dbRec.m_EventDateTime.day,
				dbRec.m_EventDateTime.year,
				dbRec.m_EventDateTime.hour,
				dbRec.m_EventDateTime.minute,
				dbRec.m_EventDateTime.second);
			m_chartControl.SetRowLabel(str);

			if (expP != NULL) {

				char	buf[32];

				str = m_expression;

				sprintf(buf, _T("%d"), dbRec.m_EventID);
				str.Replace(_T("#ID"), buf);

				sprintf(buf, _T("%d"), dbRec.m_EventValue);
				str.Replace(_T("#VALUE"), buf);

				var = scriptP->Eval(str);

				if (var.vt == VT_BSTR) {
					CString s(var.bstrVal);
					str = s;
				} else if (var.vt == VT_I2) {
					str.Format(_T("%d"), (long) var.iVal);
				} else if (var.vt == VT_I4) {
					str.Format(_T("%d"), (long) var.lVal);
				} else if (var.vt == VT_R4) {
					str.Format(_T("%g"), (double) var.fltVal);
				} else if (var.vt == VT_R8) {
					str.Format(_T("%g"), (double) var.dblVal);
				} else str = _T("");

			} else
				str.Format(_T("%d"), dbRec.m_EventValue);


			m_chartControl.SetData(str);


			// Get next record
			row++;
			dbRec.MoveNext();
		}

		db.Close();
	}


/*********
	// And set the chart type
	switch( m_chartType ) {
		default:				// Default
			value = -1;
			break;
		case 1:
			value = 6;			// 2D Line
			break;
		case 2:
			value = 1;			// 2D Bar
			break;
		case 3:
			value = 10;			// 2D Step
			break;
		case 4:
			value = 8;			// 2D Area
			break;
		case 5:
			value = 5;			// 3D Line
			break;
		case 6:
			value = 0;			// 3D Bar
			break;
		case 7:
			value = 9;			// 3D Step
			break;
		case 8:
			value =7;			// 3D Area
			break;
		case 9:
			value = 24;			// 2D Pie
			break;
	}
	m_chartControl.SetSeriesType(value);
***********/
	
	EndWaitCursor();
}

void CLogChartPage::OnChartRadioDb() 
{
	CWnd				*pIO;

	m_dataFromHcs = FALSE;

	pIO = GetDlgItem(IDC_DATE_FROM);
	pIO->EnableWindow(TRUE);

	pIO = GetDlgItem(IDC_DATE_TO);
	pIO->EnableWindow(TRUE);	
}

void CLogChartPage::OnChartRadioHcs() 
{
	CWnd				*pIO;

	m_dataFromHcs = TRUE;
	
	pIO = GetDlgItem(IDC_DATE_FROM);
	pIO->EnableWindow(FALSE);

	pIO = GetDlgItem(IDC_DATE_TO);
	pIO->EnableWindow(FALSE);	
}




/////////////////////////////////////////////////////////////////////////////
// CLogTablePage property page

IMPLEMENT_DYNCREATE(CLogTablePage, CPropertyPage)

CLogTablePage::CLogTablePage() : CPropertyPage(CLogTablePage::IDD)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	//{{AFX_DATA_INIT(CLogTablePage)
	m_expression = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_EXP, "");
	m_dateFrom = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_FROM, "");
	m_dateTo = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_TO, "");
	m_logIDFrom = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_FROM, "");
	m_logIDTo = pApp->GetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_TO, "");
	//}}AFX_DATA_INIT

	m_dataFromHcs = pApp->GetProfileLong(IDS_REG_SETTINGS, IDS_REG_LOG_DATA_SRC, TRUE);
}

CLogTablePage::~CLogTablePage()
{
}

void CLogTablePage::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CPropertyPage::OnFinalRelease();
}

void CLogTablePage::DoDataExchange(CDataExchange* pDX)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CLogTablePage)
	DDX_Control(pDX, IDC_MSFLEXGRID1, m_gridControl);
	DDX_Text(pDX, IDC_EXPRESSION, m_expression);
	DDV_MaxChars(pDX, m_expression, 80);
	DDX_Text(pDX, IDC_DATE_FROM, m_dateFrom);
	DDX_Text(pDX, IDC_DATE_TO, m_dateTo);
	DDX_CBString(pDX, IDC_LOGID_FROM, m_logIDFrom);
	DDX_CBString(pDX, IDC_LOGID_TO, m_logIDTo);
	//}}AFX_DATA_MAP

	if (pDX->m_bSaveAndValidate == TRUE) {

		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_FROM, m_dateFrom);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_DATE_TO, m_dateTo);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_EXP, m_expression);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_FROM, m_logIDFrom);
		pApp->SetProfileCString(IDS_REG_SETTINGS, IDS_REG_LOG_ID_TO, m_logIDTo);
		pApp->SetProfileLong(IDS_REG_SETTINGS, IDS_REG_LOG_DATA_SRC, m_dataFromHcs);
	}
}


BEGIN_MESSAGE_MAP(CLogTablePage, CPropertyPage)
	//{{AFX_MSG_MAP(CLogTablePage)
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, OnButtonRefresh)
	ON_BN_CLICKED(IDC_BUTTON_UPLOAD, OnButtonUpload)
	ON_BN_CLICKED(IDC_RADIO_DB, OnTableRadioDb)
	ON_BN_CLICKED(IDC_RADIO_HCS, OnTableRadioHcs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLogTablePage message handlers

BOOL CLogTablePage::OnInitDialog() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CHcsIo				*pIo  = pDoc->GetHcsLogIDs();
	CComboBox			*pBox1, *pBox2;
	CWnd				*pCheck;
	CString				str;
	long				i = 0, pos = 0, idx = 0, idx2 = 0, w;

	CPropertyPage::OnInitDialog();
	

	if (pDoc->m_OdbcEnable == FALSE) {

		pCheck = GetDlgItem(IDC_RADIO_DB);
		pCheck->EnableWindow(FALSE);

		m_dataFromHcs = TRUE;

	}

	if (m_dataFromHcs == TRUE) {

		pCheck = GetDlgItem(IDC_RADIO_HCS);
		((CButton *) pCheck)->SetCheck(1);

		pCheck = GetDlgItem(IDC_RADIO_DB);
		((CButton *) pCheck)->SetCheck(0);

		OnTableRadioHcs();

	} else {

		pCheck = GetDlgItem(IDC_RADIO_HCS);
		((CButton *) pCheck)->SetCheck(0);

		pCheck = GetDlgItem(IDC_RADIO_DB);
		((CButton *) pCheck)->SetCheck(1);

		OnTableRadioDb();
	}

	pBox1  = (CComboBox *) GetDlgItem(IDC_LOGID_TO);
	pBox2  = (CComboBox *) GetDlgItem(IDC_LOGID_FROM);

	(void) pBox1->AddString("");
	(void) pBox2->AddString("");

	// Fillout combobox with log ID names
	if (pIo->GetFirstIoLabel(&str, &pos) == TRUE) {

		i = pBox1->AddString(str);
		if (str == m_logIDTo)
			idx = i;

		i = pBox2->AddString(str);
		if (str == m_logIDFrom)
			idx2 = i;

		while (pIo->GetNextIoLabel(&str, &pos) == TRUE) {

			i = pBox1->AddString(str);
			if (str == m_logIDTo)
				idx = i;

			i = pBox2->AddString(str);
			if (str == m_logIDFrom)
				idx2 = i;
		}
	}
	pBox1->SetCurSel(idx);
	pBox2->SetCurSel(idx2);

	

	m_gridControl.SetRows(5);
	m_gridControl.SetCols(5);
	m_gridControl.Clear();

	w = m_gridControl.GetColWidth(0);
	w /= 2;
	m_gridControl.SetColWidth(0, w);	// ID

	w = m_gridControl.GetColWidth(1);
	w = (long)((double)w * 3);
	m_gridControl.SetColWidth(1, w);	// Name

	w = m_gridControl.GetColWidth(2);
	w = (long)((double)w * 2.6);
	m_gridControl.SetColWidth(2, w);	// Date

	w = m_gridControl.GetColWidth(3);
	w = (long)((double)w * 1.6);
	m_gridControl.SetColWidth(3, w);	// Time

	w = m_gridControl.GetColWidth(4);
	w = (long)((double)w * 1.2);
	m_gridControl.SetColWidth(4, w);	// Value

	m_gridControl.SetTextMatrix(0, 0, _T("ID"));
	m_gridControl.SetTextMatrix(0, 1, _T("Name"));
	m_gridControl.SetTextMatrix(0, 2, _T("Date"));
	m_gridControl.SetTextMatrix(0, 3, _T("Time"));
	m_gridControl.SetTextMatrix(0, 4, _T("Value"));

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CLogTablePage::OnButtonUpload() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	if (m_dataFromHcs == TRUE)
		pApp->OnCommandsLogdataGet();
	else
		pApp->OnCommandsLogdataStorelogbuffer();
}


void CLogTablePage::OnButtonRefresh() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CMainFrame			*pFrame = (CMainFrame*) AfxGetMainWnd();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CHcsIo				*pIO = pDoc->GetHcsLogIDs();
	CScriptControl		*scriptP = pFrame->GetScriptControl(FALSE);
	BOOL				bVal, bSelected;
	CTime				tm;
	long				row, id, value;
	long				selIDFrom, selIDTo;
	CString				str;
	char				*sP, *expP;
	VARIANT				var;

	BeginWaitCursor();

	UpdateData(TRUE);


	// Setup script control to be used for expression
	scriptP->SetAllowUI(TRUE);
	scriptP->SetLanguage(_T("VBScript"));
	scriptP->SetState(TRUE);
	scriptP->SetUseSafeSubset(FALSE);


	if ((value = m_logIDFrom.GetLength()) > 1)
		selIDFrom = atol(m_logIDFrom.GetBuffer(value));
	else
		selIDFrom = -1;

	if ((value = m_logIDTo.GetLength()) > 1)
		selIDTo = atol(m_logIDTo.GetBuffer(value));
	else
		selIDTo = -1;


	if ((value = m_expression.GetLength()) > 0)		expP = m_expression.GetBuffer(value);
	else											expP = NULL;


	// Clear matrix
	m_gridControl.Clear();

	// Set number of rows and header values
	m_gridControl.SetTextMatrix(0, 0, _T("ID"));
	m_gridControl.SetTextMatrix(0, 1, _T("Name"));
	m_gridControl.SetTextMatrix(0, 2, _T("Date"));
	m_gridControl.SetTextMatrix(0, 3, _T("Time"));
	m_gridControl.SetTextMatrix(0, 4, _T("Value"));


	// Do we get the data from the database or HCS logged data
	if (m_dataFromHcs == TRUE) {

		value = pDoc->GetUploadedLogData(&sP);
		value /= 8;			// calculate number of entries
		value++;			// add header

		m_gridControl.SetRows(value);

		// Scan through all log records
		bVal = pDoc->GetFirstLogEntry(tm, &id, &value);
		row = 1;

		while (bVal == TRUE) {

			bSelected = FALSE;

			if (selIDFrom < 0) {

				if (selIDTo < 0)

					bSelected = TRUE;		// No filter applied. Use all

				else {

					if (id <= selIDTo)		// only test To
						bSelected = TRUE;
				}


			} else {

				if (selIDTo < 0) {			// only test From

					if (id >= selIDFrom)
						bSelected = TRUE;

				} else {
											// test To and From
					if (id >= selIDFrom && id <= selIDTo)
						bSelected = TRUE;
				}
			}

			// If selected add to table view
			if (bSelected == TRUE) {

				str.Format("%d", id);
				m_gridControl.SetTextMatrix(row, 0, str);

				sP = pIO->GetIoLabel(id);
				m_gridControl.SetTextMatrix(row, 1, sP);

				str = tm.Format(_T("%A, %B %d, %Y"));
				m_gridControl.SetTextMatrix(row, 2, str);

				str = tm.Format(_T("%I:%M:%S %p"));
				m_gridControl.SetTextMatrix(row, 3, str);

				if (expP != NULL) {

					char	buf[32];

					str = m_expression;

					sprintf(buf, _T("%d"), id);
					str.Replace("#ID", buf);

					sprintf(buf, _T("%d"), value);
					str.Replace("#VALUE", buf);

					var = scriptP->Eval(str);

					if (var.vt == VT_BSTR) {
						CString s(var.bstrVal);
						str = s;
					} else if (var.vt == VT_I2) {
						str.Format(_T("%d"), (long) var.iVal);
					} else if (var.vt == VT_I4) {
						str.Format(_T("%d"), (long) var.lVal);
					} else if (var.vt == VT_R4) {
						str.Format(_T("%g"), (double) var.fltVal);
					} else if (var.vt == VT_R8) {
						str.Format(_T("%g"), (double) var.dblVal);
					} else str = _T("");

				} else
					str.Format(_T("%d"), value);

				m_gridControl.SetTextMatrix(row, 4, str);

				row++;
			}


			// Get next record
			bVal = pDoc->GetNextLogEntry(tm, &id, &value);
		}

	} else {

		CDatabase		db;
		CHcsRecordset	dbRec;
		CString			str1, str2;
		CTime			*pTm;

		// Setup Filter mechanism
		if (selIDFrom >= 0) {

			if (selIDTo >= 0)
				str1.Format(_T("EventID >= %d AND EventID <= %d"), selIDFrom, selIDTo);
			else
				str1.Format(_T("EventID >= %d"), selIDFrom);

		} else if (selIDTo >= 0) {

			str1.Format(_T("EventID <= %d"), selIDTo);
		}


		if (m_dateFrom.IsEmpty() == TRUE) {

			if (m_dateTo.IsEmpty() == FALSE)
				str2.Format(_T("EventDateTime <= #%s#"), m_dateTo);

		} else {

			if (m_dateTo.IsEmpty() == TRUE)
				str2.Format(_T("EventDateTime >= #%s#"), m_dateFrom);
			else
				str2.Format(_T("EventDateTime >= #%s# AND EventDateTime <= #%s#"), m_dateFrom, m_dateTo);
		}

		if (str1.IsEmpty() == TRUE)

			dbRec.m_strFilter = str2;

		else {

			if (str2.IsEmpty() == TRUE)
				dbRec.m_strFilter = str1;
			else
				dbRec.m_strFilter.Format(_T("%s AND %s"), str1, str2);
		}


		// Try opening the database
		try {
			if (db.IsOpen() == FALSE)
				db.Open(pDoc->m_OdbcDSN.GetBuffer(80), FALSE, FALSE, _T("ODBC;"), TRUE);
		}
		catch(CDBException *pEx)
		{
			CString str( _T("Could not open database. ") );
			str += pEx->m_strError;

			EndWaitCursor();

			AfxMessageBox(str);
			pEx->Delete();

			return;
		}

		// Open the recordset and fetch the items
		try {
			if (dbRec.IsOpen() == FALSE)
				dbRec.Open(AFX_DB_USE_DEFAULT_TYPE, pDoc->m_OdbcTable.GetBuffer(80), 0);
		}
		catch(CDBException *pEx)
		{
			CString str( _T("Could not open database table. ") );
			str += pEx->m_strError;

			db.Close();

			EndWaitCursor();

			AfxMessageBox(str);
			pEx->Delete();

			return;
		}

		// Scan through all log records
		row  = 1;

		while ( !dbRec.IsEOF() ) {

			m_gridControl.SetRows(row + 1);

			str.Format("%d", dbRec.m_EventID);
			m_gridControl.SetTextMatrix(row, 0, str);

			value  = dbRec.m_EventName.GetLength();
			sP = dbRec.m_EventName.GetBuffer(value);
			m_gridControl.SetTextMatrix(row, 1, sP);

			pTm = new CTime(
				dbRec.m_EventDateTime.year,
				dbRec.m_EventDateTime.month,
				dbRec.m_EventDateTime.day,
				dbRec.m_EventDateTime.hour,
				dbRec.m_EventDateTime.minute,
				dbRec.m_EventDateTime.second,
				-1);

			str = pTm->Format(_T("%A, %B %d, %Y"));
			m_gridControl.SetTextMatrix(row, 2, str);

			str = pTm->Format(_T("%I:%M:%S %p"));
			m_gridControl.SetTextMatrix(row, 3, str);

			delete pTm;

			if (expP != NULL) {

				char	buf[32];

				str = m_expression;

				sprintf(buf, _T("%d"), dbRec.m_EventID);
				str.Replace("#ID", buf);

				sprintf(buf, _T("%d"), dbRec.m_EventValue);
				str.Replace("#VALUE", buf);

				var = scriptP->Eval(str);

				if (var.vt == VT_BSTR) {
					CString s(var.bstrVal);
					str = s;
				} else if (var.vt == VT_I2) {
					str.Format(_T("%d"), (long) var.iVal);
				} else if (var.vt == VT_I4) {
					str.Format(_T("%d"), (long) var.lVal);
				} else if (var.vt == VT_R4) {
					str.Format(_T("%g"), (double) var.fltVal);
				} else if (var.vt == VT_R8) {
					str.Format(_T("%g"), (double) var.dblVal);
				} else str = _T("");

			} else
				str.Format(_T("%d"), dbRec.m_EventValue);

			m_gridControl.SetTextMatrix(row, 4, str);


			// Get next record
			row++;
			dbRec.MoveNext();
		}

		db.Close();
	}


	EndWaitCursor();
}

void CLogTablePage::OnTableRadioDb() 
{
	CWnd				*pIO;

	m_dataFromHcs = FALSE;

	pIO = GetDlgItem(IDC_DATE_FROM);
	pIO->EnableWindow(TRUE);

	pIO = GetDlgItem(IDC_DATE_TO);
	pIO->EnableWindow(TRUE);	
}

void CLogTablePage::OnTableRadioHcs() 
{
	CWnd				*pIO;

	m_dataFromHcs = TRUE;
	
	pIO = GetDlgItem(IDC_DATE_FROM);
	pIO->EnableWindow(FALSE);

	pIO = GetDlgItem(IDC_DATE_TO);
	pIO->EnableWindow(FALSE);	
}
