/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

#if !defined(AFX_DLGIO_H__1A868C36_37BB_11D3_B879_0000861E056C__INCLUDED_)
#define AFX_DLGIO_H__1A868C36_37BB_11D3_B879_0000861E056C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DlgIo.h : header file
//

#include	"HcsIo.h"


#define		MAX_DLG_STRING_SZ	80

#define		IO_VALUE_OFF		0
#define		IO_VALUE_ON			1
#define		IO_VALUE_TRANSP		2


/////////////////////////////////////////////////////////////////////////////
// CDlgIoDigital dialog

class CDlgIoDigital : public CDialog
{
// Construction
public:
	CDlgIoDigital(CWnd* pParent = NULL);   // standard constructor

	CHcsIo *m_pIo;
	long	m_IoSelectedId;
	long	m_IoValue;
	char	m_Title[MAX_DLG_STRING_SZ];

	BOOL	m_disableTransparent;

// Dialog Data
	//{{AFX_DATA(CDlgIoDigital)
	enum { IDD = IDD_IO_DIGITAL };
	CString	m_IoPrompt;
	CString	m_IoSelected;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgIoDigital)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgIoDigital)
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioOn();
	afx_msg void OnRadioOff();
	afx_msg void OnRadioTransparent();
	afx_msg void OnSelchangeIoNameValue();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};




#endif // !defined(AFX_DLGIO_H__1A868C36_37BB_11D3_B879_0000861E056C__INCLUDED_)
/////////////////////////////////////////////////////////////////////////////
// CDlgIoAnalog dialog

class CDlgIoAnalog : public CDialog
{
// Construction
public:
	CDlgIoAnalog(CWnd* pParent = NULL);   // standard constructor

	CHcsIo *m_pIo;
	long	m_IoSelectedId;
	long	m_min, m_max;
	char	m_Title[MAX_DLG_STRING_SZ];

	BOOL	m_disableTransparent;

// Dialog Data
	//{{AFX_DATA(CDlgIoAnalog)
	enum { IDD = IDD_IO_ANALOG };
	CString	m_IoPrompt;
	CString	m_IoSelected;
	long	m_IoValue;
	BOOL	m_IoValueTransparent;
	int		m_IoSliderValue;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgIoAnalog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
private:
	BOOL	m_bNoUpdate;

protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgIoAnalog)
	virtual BOOL OnInitDialog();
	afx_msg void OnReleasedcaptureSliderValue(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnIoValueTransparent();
	//}}AFX_MSG
	afx_msg void OnEditChange();
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CDlgGetVariable dialog

class CDlgGetVariable : public CDialog
{
// Construction
public:
	CDlgGetVariable(CWnd* pParent = NULL);   // standard constructor

	CHcsIo *m_pIo;
	long	m_IoSelectedId;
	char	m_Title[MAX_DLG_STRING_SZ];

// Dialog Data
	//{{AFX_DATA(CDlgGetVariable)
	enum { IDD = IDD_IO_GET_VARIABLE };
	CString	m_IoPrompt;
	CString	m_IoSelected;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgGetVariable)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgGetVariable)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CDlgIoNetwork dialog

class CDlgIoNetwork : public CDialog
{
// Construction
public:
	CDlgIoNetwork(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CDlgIoNetwork)
	enum { IDD = IDD_IO_NETWORK };
	CString	m_cmd;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgIoNetwork)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgIoNetwork)
	virtual BOOL OnInitDialog();
	afx_msg void OnSend();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CDlgIoVoice dialog

class CDlgIoVoice : public CDialog
{
// Construction
public:
	CDlgIoVoice(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CDlgIoVoice)
	enum { IDD = IDD_IO_VOICE };
	BOOL	m_EnableIntonation;
	int		m_SliderFormantFreq;
	int		m_FormantFreq;
	int		m_Pitch;
	int		m_SliderPitch;
	int		m_SliderSpeed;
	int		m_SliderVolume;
	int		m_Speed;
	int		m_Volume;
	CString	m_TextToSpeak;
	//}}AFX_DATA

	int		m_Tone;
	BOOL	m_bNoUpdate;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgIoVoice)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgIoVoice)
	virtual BOOL OnInitDialog();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSpeak();
	afx_msg void OnToneBass();
	afx_msg void OnToneNormal();
	afx_msg void OnToneTreble();
	afx_msg void OnReleasedcaptureSliderVolume(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderFormant(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderSpeed(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnReleasedcaptureSliderPitch(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	afx_msg void OnVolumeChange();
	afx_msg void OnFormantChange();
	afx_msg void OnSpeedChange();
	afx_msg void OnPitchChange();
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CDlgIoX10 dialog

class CDlgIoX10 : public CDialog
{
// Construction
public:
	CDlgIoX10(CWnd* pParent = NULL);   // standard constructor

	CHcsIo *m_pIo;
	long	m_IoSelectedId;
	long	m_Operation;

// Dialog Data
	//{{AFX_DATA(CDlgIoX10)
	enum { IDD = IDD_IO_X10 };
	CString	m_IoSelected;
	long	m_Brightness;
	int		m_SliderBrightness;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgIoX10)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
private:
	BOOL	m_bNoUpdate;

protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgIoX10)
	afx_msg void OnRadioAllon();
	afx_msg void OnRadioAlloff();
	afx_msg void OnRadioOn();
	afx_msg void OnRadioOff();
	virtual BOOL OnInitDialog();
	afx_msg void OnRadioBrightness();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnReleasedcaptureSliderBridhtness(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	afx_msg void OnEditChange();
	DECLARE_MESSAGE_MAP()
};
