/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// WinHcsView.cpp : implementation of the CWinHcsView class
//

#include "stdafx.h"
#include "WinHcs.h"

#include "WinHcsDoc.h"
#include "CntrItem.h"
#include "WinHcsView.h"

#include "DlgIo.h"
#include "OptionSheet.h"
#include "LogSheet.h"
#include "HcsRecordset.h"

#include "MainFrm.h"
#include "DlgRunMacro.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinHcsView

IMPLEMENT_DYNCREATE(CWinHcsView, CRichEditView)

BEGIN_MESSAGE_MAP(CWinHcsView, CRichEditView)
	//{{AFX_MSG_MAP(CWinHcsView)
	ON_WM_DESTROY()
	ON_COMMAND(ID_BUILD_COMPILE, OnBuildCompile)
	ON_COMMAND(ID_BUILD_DOWNLOAD, OnBuildDownload)
	ON_COMMAND(ID_TOOLS_RUNMACRO, OnToolsRunmacro)
	ON_WM_CHAR()
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_COMMAND(ID_EDIT_REPLACE, OnEditReplace)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_UPDATE_COMMAND_UI(ID_BUILD_COMPILE, OnUpdateBuildCompile)
	ON_UPDATE_COMMAND_UI(ID_BUILD_DOWNLOAD, OnUpdateBuildDownload)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_RUNMACRO, OnUpdateToolsRunmacro)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CRichEditView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CRichEditView::OnFilePrintPreview)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// XPRESS Keywords
static char	*XpressKeywords[] = {
	"CONFIG", "AMAN", "PL-LINK", "IR-LINK",	"LCD-LINK", "DIO-LINK", "DIO+LINK","ADIO-LINK",
	"SC", "HCS180", "SPECTRASENSE", "BUF", "ADCRES", "ADCGAIN",
	"BEGIN", "DEFINE", "DISPLAY", "MODULES", 
	"ON", "OFF", "TRUE", "FALSE", "SEQUENTIAL",

	"IF", "IFA", "THEN", "ELSE", "END", "(", ")", "=", ">", "<", "AND", "OR", "NOT", 

	"ACFailed", "ACPoper", "ADC", "AllLightsOn", "AllUnitsOff",
	"BitDirection",
	"CallerID", "CallProgress", 
	"CIDnew", "CIDmonth", "CIDday", "CIDhour", "CIDminute", "CIDarea", "CIDexch", "CIDnumber",
	"clearlog", "ClearTimers", "ClearVariables", "ClearTotal", "Console",
	"DAC", "Day", "Dec", "DOW", "DialDigit", "DialNumber", "DialStr", "DialTone",
	"DTMFdigit", "DTMFnumber", 
	"Frequency",
	"Hour", 
	"KeyDigit", "KeyNumber", "KeypadTimeout", 
	"Inc", "Input", "IRCode", "iButton",
	"LCD", "Log", "LogSize",
	"LPT", "MCIR", "Minute", "ModemInit", "ModemRings", "Module", "Month",
	"Netbit", "Netbyte", "Network", "PWMtotal", "PWMhigh",
	"OnHook", "Output",
	"Random", "Refresh", "Reset", "ResetIO", "Rings",
	"Say", "SayW", "Second", 
	"Time", "Timer", "Total",
	"Variable", 
	"Wait",
	"Year",

	NULL };


static char	*VBScriptKeywords[] = {
	"End", "Sub", 

	NULL };

#define	BUFFER_SZ		1024
#define	COLOR_KEYWORD	0x00FF0000
#define COLOR_STRING	0x000000FF
#define	COLOR_COMMENT	0x0000FF00


/////////////////////////////////////////////////////////////////////////////
// CWinHcsView construction/destruction

CWinHcsView::CWinHcsView()
{
	m_comment = FALSE;
	m_string  = FALSE;

	m_VbModule = NULL;
	m_modified = TRUE;
}

CWinHcsView::~CWinHcsView()
{
	CWinHcsApp		*pApp	 = (CWinHcsApp *) AfxGetApp();
}

BOOL CWinHcsView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CRichEditView::PreCreateWindow(cs);
}

void CWinHcsView::OnInitialUpdate()
{
	CRichEditView::OnInitialUpdate();

	// Set the printing margins (720 twips = 1/2 inch).
	SetMargins(CRect(720, 720, 720, 720));

	m_comment = FALSE;
	m_string  = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CWinHcsView printing

BOOL CWinHcsView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void CWinHcsView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CRichEditCtrl	& pCtrl = GetRichEditCtrl();
	long			startPos, endPos, lineNb, pos;

	CRichEditView::OnChar(nChar, nRepCnt, nFlags);

	// determine if keyword or comment
	pCtrl.GetSel(startPos, endPos);
	pCtrl.HideSelection(TRUE, FALSE);
	lineNb	= pCtrl.LineFromChar(startPos);

	if (m_lastLine != lineNb) {
		m_comment = FALSE;
		m_string  = FALSE;
	}
	m_lastLine = lineNb;

	switch (nChar) {
	default:
		pos = startPos;
		break;
	case 0x08:
	case '"':
	case '!':
	case '>':
	case '<':
	case '=':
	case '(':
	case ')':
		pos = -1;
		break;
	}

	ParseLine(lineNb, pos);

	pCtrl.HideSelection(FALSE, FALSE);
	pCtrl.SetSel(startPos, endPos);

}



void CWinHcsView::OnEditCut() 
{
	CRichEditCtrl	& pCtrl = GetRichEditCtrl();
	long			startPos, endPos, lineNb;

	CRichEditView::OnEditCut();

	pCtrl.GetSel(startPos, endPos);
	pCtrl.HideSelection(TRUE, FALSE);
	lineNb	= pCtrl.LineFromChar(startPos);

	ParseLine(lineNb, -1);

	pCtrl.HideSelection(FALSE, FALSE);
	pCtrl.SetSel(startPos, endPos);
}

void CWinHcsView::OnEditPaste() 
{
	CRichEditCtrl	& pCtrl = GetRichEditCtrl();
	long			startPos, endPos, lineNb;

	CRichEditView::OnEditPaste();

	pCtrl.GetSel(startPos, endPos);
	pCtrl.HideSelection(TRUE, TRUE);
	lineNb	= pCtrl.LineFromChar(startPos);

	ParseLine(lineNb, -1);

	pCtrl.HideSelection(FALSE, FALSE);
	pCtrl.SetSel(startPos, endPos);
}

void CWinHcsView::OnEditReplace() 
{
	CRichEditCtrl	& pCtrl = GetRichEditCtrl();
	long			startPos, endPos, lineNb;

	CRichEditView::OnEditReplace();

	pCtrl.GetSel(startPos, endPos);
	pCtrl.HideSelection(TRUE, FALSE);
	lineNb	= pCtrl.LineFromChar(startPos);

	ParseLine(lineNb, -1);

	pCtrl.HideSelection(FALSE, FALSE);
	pCtrl.SetSel(startPos, endPos);
}


void CWinHcsView::OnEditUndo() 
{
	CRichEditCtrl	& pCtrl = GetRichEditCtrl();
	long			startPos, endPos, lineNb;

	CRichEditView::OnEditUndo();

	pCtrl.GetSel(startPos, endPos);
	pCtrl.HideSelection(TRUE, FALSE);
	lineNb	= pCtrl.LineFromChar(startPos);

	ParseLine(lineNb, -1);

	pCtrl.HideSelection(FALSE, FALSE);
	pCtrl.SetSel(startPos, endPos);
}


void CWinHcsView::ParseLine(long lineNb, long charIdx) 
{
	m_modified = TRUE;

/** DISABLED FOR NOW
	CRichEditCtrl	& pCtrl = GetRichEditCtrl();
	long			n, c, lineLength, lineIdx;
	long			wordIdx, wordStartIdx;
	BOOL			bFound = FALSE;
	char			line[BUFFER_SZ];
	char			word[BUFFER_SZ];
	char			**keywordsP;

	switch (GetDocument()->m_docType) {
	default:
		return;
	case TYPE_XPRESS:
		keywordsP = XpressKeywords;
		break;
	case TYPE_VBSCRIPT:
		keywordsP = VBScriptKeywords;
		break;
	}

	lineIdx		= pCtrl.LineIndex(lineNb);
	c			= pCtrl.GetLine(lineNb, line, BUFFER_SZ);

	line[BUFFER_SZ - 1]  = 0;
	line[c - 1] = 0;

	lineLength	= strlen(line);

	wordIdx		= 0;
	bFound		= FALSE;


	if (charIdx < 0) {

		c = 0;
		m_comment	= FALSE;
		m_string	= FALSE;

	} else {

		// count " to determine if in string
		for (c = charIdx - lineIdx - 1, n = 0; c >= 0; c--) {

			if (line[c] == '"')
				n++;

			if (line[c] == '!' && (n % 2 == 0))
				m_comment = TRUE;
		}
		n = n % 2;

		if (n == 0) m_string = FALSE;
		else		m_string = TRUE;

			
		c = charIdx - lineIdx - 1;
		bFound = FALSE;

		while (c >= 0 && bFound == FALSE) {
			switch (line[c]) {
			default:
				c--;
				break;
			case ' ':
			case 0x09:
			case '>':
			case '<':
			case '=':
			case '(':
			case ')':
				c++;
				bFound = TRUE;
				break;
			case '!':
				bFound = TRUE;
				break;
			}
		}
	}
	if (c < 0) 
		c = 0;

	while (m_comment == FALSE && line[c] != 0 && c < BUFFER_SZ) {
		
		switch( line[c] ) {
		default:
			if (m_string == FALSE) {

				if (wordIdx == 0)
					wordStartIdx = c;

				word[ wordIdx ] = line[c];
				wordIdx++;
				word[ wordIdx ] =  0;
			}
			break;
		case '!':
			if (m_string == FALSE) {
				m_comment = TRUE;

				pCtrl.SetSel(lineIdx + c, lineIdx + lineLength);
				OnColorPick(COLOR_COMMENT);
			}
			break;
		case '"':
			if (m_string == FALSE) {

				m_string = TRUE;
				m_stringStartIdx = c;

				pCtrl.SetSel(lineIdx + c, lineIdx + c);
				OnColorPick(COLOR_STRING);

			} else {

				m_string = FALSE;

				pCtrl.SetSel(lineIdx + m_stringStartIdx, lineIdx + c + 1);
				OnColorPick(COLOR_STRING);

				pCtrl.SetSel(lineIdx + c + 1, lineIdx + c + 1);
				OnColorDefault();
			}
			break;
		case '>':
		case '<':
		case '=':
		case '(':
		case ')':
			if (m_string == FALSE) {
				pCtrl.SetSel(lineIdx + c, lineIdx + c + 1);
				OnColorPick(COLOR_KEYWORD);

				pCtrl.SetSel(lineIdx + c + 1, lineIdx + c + 1);
				OnColorDefault();
			}
		case 0x0D:
		case 0x09:
		case ' ':
			if (m_comment == FALSE && m_string == FALSE && wordIdx > 0) {

				n = 0;
				bFound	= FALSE;

				while (keywordsP[n] != NULL && bFound == FALSE) {

					if (_stricmp(keywordsP[n], word) == 0) {

						bFound = TRUE;
					}
					n++;
				}
				pCtrl.SetSel(lineIdx + wordStartIdx, lineIdx + c);
				if (bFound == FALSE)
					OnColorDefault();
				else
					OnColorPick(COLOR_KEYWORD);

				pCtrl.SetSel(lineIdx + c, lineIdx + c);
				OnColorDefault();
			}
			wordIdx = 0;

			if (line[c] = 0x0D) {
				m_comment	= FALSE;
				m_string	= FALSE;
			}

			if (charIdx >= 0)
				return;

			break;
		}
		c++;
	}
**/
}

void CWinHcsView::SelectLine(long line)
{
	long			idx, sz;
	CRichEditCtrl	& pCtrl = GetRichEditCtrl();
	
	line = line - GetDocument()->m_lineOffset;

	if (line > 0) {

		idx	= pCtrl.LineIndex(line - 1);
		sz	= pCtrl.LineLength(idx);
		pCtrl.SetSel(idx, idx + sz);
	}
}




void CWinHcsView::OnDestroy()
{
	// Deactivate the item on destruction; this is important
	// when a splitter view is being used.
   CRichEditView::OnDestroy();
   COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);

   if (pActiveItem != NULL && pActiveItem->GetActiveView() == this)
   {
      pActiveItem->Deactivate();
      ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
   }
}


BOOL CWinHcsView::Print() 
{
	this->OnFilePrint();
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CWinHcsView diagnostics

#ifdef _DEBUG
void CWinHcsView::AssertValid() const
{
	CRichEditView::AssertValid();
}

void CWinHcsView::Dump(CDumpContext& dc) const
{
	CRichEditView::Dump(dc);
}

CWinHcsDoc* CWinHcsView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWinHcsDoc)));
	return (CWinHcsDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinHcsView message handlers

void CWinHcsView::OnBuildCompile() 
{
	((CWinHcsDoc *) GetDocument())->Compile();
}

void CWinHcsView::OnBuildDownload() 
{
	if (((CWinHcsDoc *) GetDocument())->CompileAndDownload() == FALSE) {

		AfxMessageBox(IDS_ERR_DOWNLOAD, MB_OK, 0);
	}
}



//////////////////
//
void CWinHcsView::OnToolsRunmacro()
{
	RunMacro(NULL);
}

void CWinHcsView::RunMacro(char *pName)
{
	CRichEditCtrl				&pCtrl	= GetRichEditCtrl();
	CString						title	= GetDocument()->GetTitle();
	CString						name;
	CScriptControl				*scriptP= ((CMainFrame*)AfxGetMainWnd())->GetScriptControl(m_modified);
	CScriptModuleCollection		modules = scriptP->GetModules();
	CScriptModule				module;
	long						i;
	long						n = modules .GetCount();
	VARIANT						vt;
	CDlgRunMacro				dlg;
	char						*pExecName = pName;

	// Lets see if the VB module exists
	m_VbModule = NULL;
	VariantInit(&vt);

	for (i = 0 ; i < n && m_VbModule == NULL; i++) {

		vt.vt = VT_I4;
		vt.lVal = i + 1;	

		module = modules.GetItem(vt);
		name   = module.GetName();

		if (name == title)
			m_VbModule = module;
	}


		
	// Get a VB module first
	if (m_VbModule == NULL) {

		VariantInit(&vt);
		vt.vt		= VT_DISPATCH;
		vt.punkVal	= NULL;

		m_VbModule = modules.Add(title, &vt);
		m_modified = TRUE;
	}

	// And now add/update code
	if (m_modified == TRUE) {

		long				selStart, selEnd;
		long				lineCount, lineNb, x;
		CString				code;
		char				buf[1024];

		pCtrl.GetSel(selStart, selEnd);
		pCtrl.HideSelection(TRUE, FALSE);
		lineCount = pCtrl.GetLineCount();

		for (lineNb = 0 ; lineNb < lineCount ; lineNb++) {

			x = pCtrl.GetLine(lineNb, buf, 1024);
			buf[ x - 1 ] = 0;

			code += buf;
		}

		pCtrl.HideSelection(FALSE, FALSE);
		pCtrl.SetSel(selStart, selEnd);

		m_VbModule.AddCode(code);
		m_modified = FALSE;
	}

	// Do we need to ask the user for the macro to run?
	if (pExecName == NULL || *pExecName == 0) {

		dlg.m_pVbModule = &m_VbModule;

		if (dlg.DoModal() != IDOK)
			return;

		pExecName = dlg.m_exec.GetBuffer(80);
	}

	// And run the macro
// Following used for testing purpose if not commented out
//	if (pName == NULL)
//		((CWinHcsApp *) AfxGetApp())->GetHcsStatusDoc()->m_HcsCommands.AddTail(pExecName);
//	else
		m_VbModule.ExecuteStatement(pExecName);
	((CWinHcsApp *) AfxGetApp())->GetHcsStatusDoc()->UpdateAllViews(NULL, 0, NULL);
}


void CWinHcsView::OnUpdateBuildCompile(CCmdUI* pCmdUI) 
{
	BOOL	bEnable = FALSE;

	switch (GetDocument()->m_docType) {
	default:
		break;
	case TYPE_XPRESS:
		bEnable = TRUE;
		break;
	}

	pCmdUI->Enable( bEnable );
}

void CWinHcsView::OnUpdateBuildDownload(CCmdUI* pCmdUI) 
{
	BOOL	bEnable = FALSE;

	switch (GetDocument()->m_docType) {
	default:
		break;
	case TYPE_XPRESS:
		bEnable = TRUE;
		break;
	}

	pCmdUI->Enable( bEnable );
}

void CWinHcsView::OnUpdateToolsRunmacro(CCmdUI* pCmdUI) 
{
	BOOL	bEnable = FALSE;

	switch (GetDocument()->m_docType) {
	default:
		break;
	case TYPE_VBSCRIPT:
		bEnable = TRUE;
		break;
	}

	pCmdUI->Enable( bEnable );
}
