/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

#if !defined(AFX_WINHCSSTATUSVIEW_H__BF76971F_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
#define AFX_WINHCSSTATUSVIEW_H__BF76971F_4DAC_11D3_B89C_0000861E056C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// WinHcsStatusView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CWinHcsStatusView form view

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CWinHcsStatusView : public CFormView
{
protected:
	CWinHcsStatusView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CWinHcsStatusView)

#define	DISP_MAN1_4		1
#define	DISP_MAN5_8		2
#define	DISP_DIO		3

	int		m_netbitDisplayType;
	int		m_x10DisplayOfs;

	long	m_type;
	long	m_id;
	void	*m_pIO;

	long	m_font_w;
	long	m_font_h;

	long	m_varListIdx;

// Form Data
public:
	//{{AFX_DATA(CWinHcsStatusView)
	enum { IDD = IDD_HCSSTATUS };
	//}}AFX_DATA

// Attributes
public:

// Operations
public:
	int  PointToIo(CPoint point, CHcsIo **ppIO, long *pID, long *pType, char *pszName) const;
	void RequestVariableUpdate();
	void AddVariableDisplay(short id);
	void ShowRS232State(void);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinHcsStatusView)
	public:
	virtual void OnFinalRelease();
	virtual void OnInitialUpdate();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnDraw(CDC* pDC);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CWinHcsStatusView();
	int OnToolHitTest(CPoint point, TOOLINFO* pTI) const;

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(CWinHcsStatusView)
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnBtnClear();
	afx_msg void OnRadioDio();
	afx_msg void OnRadioMan1();
	afx_msg void OnRadioMan2();
	afx_msg void OnSelchangeComboX10();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnClickVarList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRclickVarList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	afx_msg void OnMenuOn();
	afx_msg void OnMenuOff();
	afx_msg void OnMenuTransparent();
	afx_msg void OnMenuAllOn();
	afx_msg void OnMenuAllOff();
	afx_msg void OnMenuRmvVar();

	DECLARE_MESSAGE_MAP()
	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CWinHcsStatusView)
	afx_msg BOOL AutomationMaximize();
	afx_msg BOOL AutomationMinimize();
	afx_msg BOOL AutomationRestore();
	afx_msg short AutomationGetNetbitView();
	afx_msg void AutomationSetNetbitView(short nNewValue);
	afx_msg short AutomationGetX10View();
	afx_msg void AutomationSetX10View(short nNewValue);
	afx_msg BOOL AutomationGetVisible();
	afx_msg void AutomationSetVisible(BOOL bNewValue);
	afx_msg void AutomationUpdate();
	afx_msg void AutomationClearConsole();
	afx_msg void AutomationAddVariable(short id);
	afx_msg void AutomationRemoveVariable(short id);
	afx_msg void AutomationRemoveAllVariables();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINHCSSTATUSVIEW_H__BF76971F_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
