/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

#if !defined(AFX_WINHCSSTATUSDOC_H__BF76971C_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
#define AFX_WINHCSSTATUSDOC_H__BF76971C_4DAC_11D3_B89C_0000861E056C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// WinHcsStatusDoc.h : header file
//

#include "HcsRecordset.h"

class CListenSocket;

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

#include "MainFrm.h"
#include "HcsIo.h"

#define	MAX_MODULES_PL		1
#define	MAX_MODULES_MCIR	8
#define	MAX_MODULES_LCD		8
#define	MAX_MODULES_MAN		8
#define	MAX_MODULES_DIO		8

#define	MAX_HCS_INPUTS		40
#define	MAX_HCS_OUTPUTS		40
#define	MAX_NETBITS			224
#define	MAX_ADCS			78
#define	MAX_DACS			30
#define	MAX_X10				256

#define	MAX_VARS			256
#define	MAX_TIMERS			256
#define	MAX_LOGID			256

#define MAXPORTS			2
#define RXQUEUE				4096
#define TXQUEUE				1024

#define FC_DTRDSR			0x01
#define FC_RTSCTS			0x02
#define FC_XONXOFF			0x04

#define ASCII_XON			0x11
#define ASCII_XOFF			0x13


#define	TIME_UPDATE_NONE	0
#define	TIME_UPDATE_SLOW	1
#define	TIME_UPDATE_FAST	2


#define	RS232_NOT_ACTIVE	0
#define	RS232_ACTIVE		1
#define	RS232_ERROR			2


#define	_BCD_TO_INT(a)	((((a >> 4) & 15) * 10) + (a & 15))
#define	_INT_TO_BCD(a)	((((a / 10) & 15) << 4) + ((a % 10) & 15))

#define LOG_BUF_SZ			(32 * 1024)

/////////////////////////////////////////////////////////////////////////////
// CWinHcsStatusDoc document

class CWinHcsStatusDoc : public CDocument
{
protected:
	DECLARE_DYNCREATE(CWinHcsStatusDoc)

// Attributes
public:
	long	m_rs232_in_state;
	long	m_rs232_out_state;

	BOOL	m_AutoConnectAtStartup;
	BOOL	m_ShowViewAtStartup;

	BOOL	m_OdbcEnable;
	CString	m_OdbcDSN;
	CString	m_OdbcTable;
	long	m_OdbcUpdateFreq;
	BOOL	m_OdbcUpdAtConnect;

	BOOL	m_logReceived;
	BOOL	m_logSizeReceived;
	long	m_logNbEntries;

	CStringList m_HcsCommands;
	CStringList m_ConsoleMessages;

	UINT		m_listenPort;

	CDatabase		m_db;
	CHcsRecordset	m_dbRec;


// Operations
public:
	CWinHcsStatusDoc();           // protected constructor used by dynamic creation

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinHcsStatusDoc)
	public:
	virtual void OnFinalRelease();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
	protected:
	virtual BOOL OnNewDocument();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWinHcsStatusDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CWinHcsStatusDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CWinHcsStatusDoc)
	long m_hcsLogID;
	long m_hcsLogValue;
	short m_hcsLogYear;
	short m_hcsLogMonth;
	short m_hcsLogDay;
	short m_hcsLogHour;
	short m_hcsLogMinute;
	short m_hcsLogSecond;
	afx_msg BOOL AutomationGetIsConnected();
	afx_msg void AutomationSetIsConnected(BOOL bNewValue);
	afx_msg BOOL AutomationGetNewConsoleMsg();
	afx_msg long AutomationGetNbLogEntries();
	afx_msg BSTR AutomationGetLastConsoleMsg();
	afx_msg VARIANT AutomationGetApplication();
	afx_msg VARIANT AutomationGetWindow();
	afx_msg void AutomationAddLogEntry(short id, short value);
	afx_msg void AutomationClearLogEntries();
	afx_msg BOOL AutomationGetLogData();
	afx_msg BOOL AutomationGetFirstLogEntry();
	afx_msg BOOL AutomationGetNextLogEntry();
	afx_msg void AutomationSetTime();
	afx_msg DATE AutomationGetTime();
	afx_msg void AutomationSpeak(LPCTSTR TextToSpeak);
	afx_msg void AutomationSendToNetwork(LPCTSTR cmd);
	afx_msg void AutomationSetDac(short id, short value);
	afx_msg void AutomationSetADC(short id, BOOL transparent, short value);
	afx_msg void AutomationSetOutput(short id, BOOL value);
	afx_msg void AutomationSetInput(short id, BOOL transparent, BOOL value);
	afx_msg void AutomationSetNetbit(short id, BOOL value);
	afx_msg void AutomationSetVariable(short id, short value);
	afx_msg void AutomationSetX10OnOrOff(short HouseCodeAndModule, BOOL OnState);
	afx_msg void AutomationSetX10DimOrBright(short HouseCodeAndModule, short DimBrightSteps);
	afx_msg void AutomationSetX10AllOff(short HouseCode);
	afx_msg void AutomationSetX10AllOn(short HouseCode);
	afx_msg short AutomationGetADC(short id);
	afx_msg short AutomationGetDAC(short id);
	afx_msg BOOL AutomationGetOutput(short id);
	afx_msg BOOL AutomationGetInput(short id);
	afx_msg BOOL AutomationGetNetbit(short id);
	afx_msg short AutomationGetVariable(short id);
	afx_msg BOOL AutomationGetX10(short HouseCodeAndModule);
	afx_msg void AutomationSetADCProperties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetDACProperties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetOutputProperties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetInputProperties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetNetbitProperties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetVariableProperties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetX10Properties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetLogIDProperties(short id, BOOL used, LPCTSTR label);
	afx_msg void AutomationSetTimerProperties(short id, BOOL used, LPCTSTR label);
	afx_msg BOOL AutomationIsADCInUse(short id);
	afx_msg BOOL AutomationIsDACInUse(short id);
	afx_msg BOOL AutomationIsOutputInUse(short id);
	afx_msg BOOL AutomationIsInputInUse(short id);
	afx_msg BOOL AutomationIsNetBitInUse(short id);
	afx_msg BOOL AutomationIsVariableInUse(short id);
	afx_msg BOOL AutomationIsX10InUse(short id);
	afx_msg BOOL AutomationIsLogIdInUse(short id);
	afx_msg BOOL AutomationIsTimerInUse(short id);
	afx_msg BSTR AutomationGetADCLabel(short id);
	afx_msg BSTR AutomationGetDACLabel(short id);
	afx_msg BSTR AutomationGetOutputLabel(short id);
	afx_msg BSTR AutomationGetInputLabel(short id);
	afx_msg BSTR AutomationGetNetbitLabel(short id);
	afx_msg BSTR AutomationGetVariableLabel(short id);
	afx_msg BSTR AutomationGetX10Label(short id);
	afx_msg BSTR AutomationGetLogIDLabel(short id);
	afx_msg BSTR AutomationGetTimerLabel(short id);
	afx_msg void AutomationAddWindow();
	afx_msg BOOL AutomationGetFirstDBLogEntry(long IDFrom, long IDTo, LPCTSTR DateFrom, LPCTSTR DateTo);
	afx_msg BOOL AutomationGetDBNextLogEntry();
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()


protected:		
	BOOL		m_UsingModem;
	BOOL		m_CallerIDModem;
	CString		m_ModemInitCommand;

	HANDLE		m_idComDev;
	BYTE		m_bPort;
	BOOL		m_fConnected,
				m_fXonXoff;
	BYTE		m_bByteSize,
				m_bFlowCtrl,
				m_bParity,
				m_bStopBits;
	DWORD		m_dwBaudRate;
	HANDLE		m_hWatchThread;
	DWORD		m_dwThreadID;
	OVERLAPPED	m_osWrite,
				m_osRead;
	char		*m_replyP;
	unsigned long m_replySz;

	struct _hcsConfig {

		char	name[ MAX_IO_NAME_SZ ];
		BOOL	isSpectraSense;		// HCS otherwise
		
		short	nbModulesPL;
		short	nbModulesMCIR;
		short	nbModulesLCD;
		short	nbModulesDIO;
		short	nbModulesADIO;
		short	nbModulesBUFIO;

	} m_HcsConfig;

	long		m_HcsUpdatePeriod;
	char		m_HcsTime[12];

	long		m_Module_BUFIO;
	CHcsIo		m_Modules_PL,
				m_Modules_MCIR,
				m_Modules_LCD,
				m_Modules_DIO,
				m_Modules_AMAN,
				m_HcsInputs, 
				m_HcsOutputs,
				m_Netbits,
				m_ADCs, 
				m_DACs,
				m_X10,
				m_XPRESS_Vars,
				m_XPRESS_Timers,
				m_XPRESS_Logs;

	long		m_logUpdateRate;
	BOOL		m_logUpdateAuto;
	BOOL		m_logAutoClear;

	unsigned long m_prgSizeToSend;
	char		*m_prgDataP;

	long		m_logPos;
	long		m_logDataSz;
	char		m_logData[ LOG_BUF_SZ ];

	CListenSocket	*m_pListenSocket;

// Operations
private:
	BSTR AutomationGetLabel(short id, CHcsIo *pIO);

public:
	BOOL OpenConnectionToHcs(void);
	BOOL CloseConnectionToHcs(void);
	BOOL SetupConnectionToHcs(void);
	BOOL IsConnectedToHcs(void);

	long ReadBlockFromHcs(char *pData, unsigned long sz );
	BOOL WriteBlockToHcs(char *pData, unsigned long sz);

	void SendMessageToHcs(char *pData, unsigned long sz);
	BOOL SendMessageWithReplyToHcs(char *pData, unsigned long sz,
			char *pReply, unsigned long repSz);

	void ReceiveAndProcessHcsMessages(CMainFrame *pFrame);
	void DownloadNewProgram(char *dataP, long size);

	void	SetNbBUFIO(long n);
	long	GetNbBUFIO(void);

	CHcsIo *GetHcsPLs(void);
	CHcsIo *GetHcsMCIRs(void);
	CHcsIo *GetHcsLCDs(void);
	CHcsIo *GetHcsDIOs(void);
	CHcsIo *GetHcsANSWERMANs(void);

	CHcsIo *GetHcsInputs(void);
	CHcsIo *GetHcsOutputs(void);
	CHcsIo *GetHcsNetbits(void);
	CHcsIo *GetHcsADCs(void);
	CHcsIo *GetHcsDACs(void);
	CHcsIo *GetHcsX10(void);
	CHcsIo *GetHcsVariables(void);
	CHcsIo *GetHcsTimers(void);
	CHcsIo *GetHcsLogIDs(void);

	void    SetHcsTime(void);
	char   *GetHcsTime(void);
	BOOL	GetHcsTime(CTime &tm);

	char   *GetLastConsoleMsg(void);

	void	GetRS232Settings(CString &comPort, BOOL *pUsingModem, CString & modemInitCmd);
	void	SetRS232Settings(CString &comPort, BOOL bUsingModem, CString & modemInitCmd);

	void	SetTimeUpdateRate(long updateRate);
	long	GetTimeUpdateRate();

	void	SetLogUpdateSettings(long sizeUpdateRate,  BOOL logUpdateAuto,  BOOL clearAfterStore);
	void	GetLogUpdateSettings(long *sizeUpdateRate, BOOL *logUpdateAuto, BOOL *clearAfterStore);

	void	ClearLogEntries(void);
	void	QueryLogSize(void);
	void	AddLogEntry(short id, short value);
	void	UploadLogData(void);
	BOOL	GetFirstLogEntry(CTime &tm, long *idP, long *valueP);
	BOOL	GetNextLogEntry(CTime &tm, long *idP, long *valueP);
	long	GetUploadedLogData(char **pLogData);
};


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINHCSSTATUSDOC_H__BF76971C_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
