/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// WinHcsDoc.h : interface of the CWinHcsDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINHCSDOC_H__BF7696F2_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
#define AFX_WINHCSDOC_H__BF7696F2_4DAC_11D3_B89C_0000861E056C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef enum {
	TYPE_UNDEFINED = 0,
	TYPE_XPRESS,
	TYPE_VBSCRIPT
} DocType;



class CWinHcsDoc : public CRichEditDoc
{
protected: // create from serialization only
	CWinHcsDoc();
	DECLARE_DYNCREATE(CWinHcsDoc)

// Attributes
public:
	DocType m_docType;
	long	m_lineOffset;

// Operations
public:
	BOOL Compile(void);
	BOOL CompileAndDownload(void);
	COleClientItem * FindEmbeddedItem(LPCSTR name);
	COleClientItem * FindEmbeddedItem(long index);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinHcsDoc)
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL
	virtual CRichEditCntrItem* CreateClientItem(REOBJECT* preo) const;

// Implementation
public:
	virtual ~CWinHcsDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWinHcsDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CWinHcsDoc)
	afx_msg VARIANT AutomationGetApplication();
	afx_msg BSTR AutomationGetFilename();
	afx_msg void AutomationSetFilename(LPCTSTR lpszNewValue);
	afx_msg BSTR AutomationGetTitle();
	afx_msg void AutomationSetTitle(LPCTSTR lpszNewValue);
	afx_msg long AutomationGetSelectionStart();
	afx_msg void AutomationSetSelectionStart(long nNewValue);
	afx_msg long AutomationGetSelectionEnd();
	afx_msg void AutomationSetSelectionEnd(long nNewValue);
	afx_msg long AutomationGetLineCount();
	afx_msg BOOL AutomationGetVisible();
	afx_msg void AutomationSetVisible(BOOL bNewValue);
	afx_msg BOOL AutomationGetSaved();
	afx_msg void AutomationSetSaved(BOOL bNewValue);
	afx_msg BOOL AutomationDeleteContent();
	afx_msg BOOL AutomationCompile();
	afx_msg BOOL AutomationCompileAndDownload();
	afx_msg BOOL AutomationFind(LPCTSTR findString, BOOL caseSensitive, BOOL wholeWords);
	afx_msg BOOL AutomationReplaceSelection(LPCTSTR newText);
	afx_msg long AutomationLineIndex(long line);
	afx_msg void AutomationClear();
	afx_msg void AutomationCut();
	afx_msg void AutomationPaste();
	afx_msg long AutomationLineLength(long line);
	afx_msg void AutomationClose(const VARIANT FAR& saveChanges, const VARIANT FAR& filename);
	afx_msg void AutomationSave();
	afx_msg void AutomationSaveAs(const VARIANT FAR& filename);
	afx_msg BOOL AutomationUndo();
	afx_msg BOOL AutomationPrintOut();
	afx_msg BOOL AutomationMail(const VARIANT FAR& To, const VARIANT FAR& Subject);
	afx_msg void AutomationActivate();
	afx_msg BOOL AutomationMaximize();
	afx_msg BOOL AutomationMinimize();
	afx_msg BOOL AutomationRestore();
	afx_msg VARIANT AutomationOleItems(const VARIANT FAR& item);
	//}}AFX_DISPATCH
	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CWinHcsDocs command target

class CWinHcsDocs : public CCmdTarget
{
	DECLARE_DYNCREATE(CWinHcsDocs)

	CWinHcsDocs();           // protected constructor used by dynamic creation

// Attributes
public:
	DocType m_docType;
// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinHcsDocs)
	public:
	virtual void OnFinalRelease();
	//}}AFX_VIRTUAL

// Implementation
	virtual ~CWinHcsDocs();

	// Generated message map functions
	//{{AFX_MSG(CWinHcsDocs)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG


	DECLARE_MESSAGE_MAP()
	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CWinHcsDocs)
	public:
	afx_msg short AutomationGetCount();
	afx_msg VARIANT AutomationAdd(const VARIANT FAR& name);
	afx_msg LPDISPATCH AutomationGetItem(const VARIANT FAR& vt);
	afx_msg VARIANT AutomationOpen(LPCTSTR filename);
	//}}AFX_DISPATCH
	afx_msg LPUNKNOWN _NewEnum();

	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
};

// Declaraction of the class that implements IEnumVARIANT
//
class CEnumDocs : public CCmdTarget
{   
public:
    CEnumDocs();         // protected constructor used by dynamic creation

// Attributes
public:

private:
    
// Operations
public:

// Implementation
public:
    virtual ~CEnumDocs();
    virtual void OnFinalRelease();

protected:
    DECLARE_INTERFACE_MAP()

public:    
    // The following block get's expanded by the C++ preprocessor to this:
    //
    //  class FAR XEnumVARIANT : public IEnumVARIANT
    //  {
    //  public:
    //      STDMETHOD_(ULONG, AddRef)(); 
    //      STDMETHOD_(ULONG, Release)();
    //      STDMETHOD(QueryInterface)(REFIID iid, LPVOID far* ppvObj); 
    //      XEnumVARIANT() ;      
    //      POSITION   m_posCurrent ; 
    //      ...
    //
    //  } m_xEnumVARIANT ;
    //  friend class XEnumVARIANT ;
    //      
    BEGIN_INTERFACE_PART(EnumVARIANT, IEnumVARIANT)
        XEnumVARIANT() ;        // constructor to set m_posCurrent
        POSITION   m_posCurrent ; // Next() requires that we keep track of our current item
		DocType	   m_docType;

        STDMETHOD(Next)(THIS_ unsigned long celt, VARIANT FAR* rgvar, unsigned long FAR* pceltFetched);
        STDMETHOD(Skip)(THIS_ unsigned long celt) ;
        STDMETHOD(Reset)(THIS) ;
        STDMETHOD(Clone)(THIS_ IEnumVARIANT FAR* FAR* ppenum) ;
    END_INTERFACE_PART(EnumVARIANT)    

} ;

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// CWinHcsOles command target

class CWinHcsOles : public CCmdTarget
{
	DECLARE_DYNCREATE(CWinHcsOles)

	CWinHcsOles();

// Attributes
public:
	CWinHcsDoc	*m_pDoc;

// Operations
public:
	CWinHcsOles(CWinHcsDoc *pDoc);
	virtual ~CWinHcsOles();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinHcsOles)
	public:
	virtual void OnFinalRelease();
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CWinHcsOles)
		// NOTE - the ClassWizard will add and remove member functions here.
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CWinHcsOles)
	public:
	afx_msg short AutomationGetCount();
	afx_msg LPDISPATCH AutomationGetItem(const VARIANT FAR& vt);
	afx_msg BSTR AutomationGetItemFullType(const VARIANT FAR& vt);
	afx_msg BSTR AutomationGetItemShortType(const VARIANT FAR& vt);
	afx_msg BSTR AutomationGetItemAppName(const VARIANT FAR& vt);
	//}}AFX_DISPATCH
	afx_msg LPUNKNOWN _NewEnum();

	DECLARE_DISPATCH_MAP()
	DECLARE_INTERFACE_MAP()
};


// Declaraction of the class that implements IEnumVARIANT
//
class CEnumOles : public CCmdTarget
{   
public:
    CEnumOles(CWinHcsDoc *pDoc);

// Attributes
public:

private:
    
// Operations
public:

// Implementation
public:
    virtual ~CEnumOles();
    virtual void OnFinalRelease();

protected:
    DECLARE_INTERFACE_MAP()

public:    
    // The following block get's expanded by the C++ preprocessor to this:
    //
    //  class FAR XEnumVARIANT : public IEnumVARIANT
    //  {
    //  public:
    //      STDMETHOD_(ULONG, AddRef)(); 
    //      STDMETHOD_(ULONG, Release)();
    //      STDMETHOD(QueryInterface)(REFIID iid, LPVOID far* ppvObj); 
    //      XEnumVARIANT() ;      
    //      POSITION   m_posCurrent ; 
    //      ...
    //
    //  } m_xEnumVARIANT ;
    //  friend class XEnumVARIANT ;
    //      
    BEGIN_INTERFACE_PART(EnumVARIANT, IEnumVARIANT)
        XEnumVARIANT() ;        // constructor to set m_posCurrent
        POSITION   m_posCurrent ; // Next() requires that we keep track of our current item
		CWinHcsDoc *m_pDoc;

        STDMETHOD(Next)(THIS_ unsigned long celt, VARIANT FAR* rgvar, unsigned long FAR* pceltFetched);
        STDMETHOD(Skip)(THIS_ unsigned long celt) ;
        STDMETHOD(Reset)(THIS) ;
        STDMETHOD(Clone)(THIS_ IEnumVARIANT FAR* FAR* ppenum) ;
    END_INTERFACE_PART(EnumVARIANT)    

} ;

/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINHCSDOC_H__BF7696F2_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
