/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// WinHcsDoc.cpp : implementation of the CWinHcsDoc class
//

#include "stdafx.h"
#include "WinHcs.h"

#include "WinHcsDoc.h"
#include "WinHcsView.h"

#include "CntrItem.h"

#include <io.h>
#include <fcntl.h>
#include <direct.h>
#include <process.h>
#include <memory.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CWinHcsDoc

IMPLEMENT_DYNCREATE(CWinHcsDoc, CRichEditDoc)

BEGIN_MESSAGE_MAP(CWinHcsDoc, CRichEditDoc)
	//{{AFX_MSG_MAP(CWinHcsDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, CRichEditDoc::OnUpdateEditLinksMenu)
	ON_COMMAND(ID_OLE_EDIT_LINKS, CRichEditDoc::OnEditLinks)
	ON_UPDATE_COMMAND_UI_RANGE(ID_OLE_VERB_FIRST, ID_OLE_VERB_LAST, CRichEditDoc::OnUpdateObjectVerbMenu)
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CWinHcsDoc, CRichEditDoc)
	//{{AFX_DISPATCH_MAP(CWinHcsDoc)
	DISP_PROPERTY(CWinHcsDoc, "Type", m_docType, VT_I4)
	DISP_PROPERTY_EX(CWinHcsDoc, "Application", AutomationGetApplication, SetNotSupported, VT_VARIANT)
	DISP_PROPERTY_EX(CWinHcsDoc, "Filename", AutomationGetFilename, AutomationSetFilename, VT_BSTR)
	DISP_PROPERTY_EX(CWinHcsDoc, "Title", AutomationGetTitle, AutomationSetTitle, VT_BSTR)
	DISP_PROPERTY_EX(CWinHcsDoc, "SelectionStart", AutomationGetSelectionStart, AutomationSetSelectionStart, VT_I4)
	DISP_PROPERTY_EX(CWinHcsDoc, "SelectionEnd", AutomationGetSelectionEnd, AutomationSetSelectionEnd, VT_I4)
	DISP_PROPERTY_EX(CWinHcsDoc, "LineCount", AutomationGetLineCount, SetNotSupported, VT_I4)
	DISP_PROPERTY_EX(CWinHcsDoc, "Visible", AutomationGetVisible, AutomationSetVisible, VT_BOOL)
	DISP_PROPERTY_EX(CWinHcsDoc, "Saved", AutomationGetSaved, AutomationSetSaved, VT_BOOL)
	DISP_FUNCTION(CWinHcsDoc, "DeleteContent", AutomationDeleteContent, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Compile", AutomationCompile, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "CompileAndDownload", AutomationCompileAndDownload, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Find", AutomationFind, VT_BOOL, VTS_BSTR VTS_BOOL VTS_BOOL)
	DISP_FUNCTION(CWinHcsDoc, "ReplaceSelection", AutomationReplaceSelection, VT_BOOL, VTS_BSTR)
	DISP_FUNCTION(CWinHcsDoc, "LineIndex", AutomationLineIndex, VT_I4, VTS_I4)
	DISP_FUNCTION(CWinHcsDoc, "Clear", AutomationClear, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Cut", AutomationCut, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Paste", AutomationPaste, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "LineLength", AutomationLineLength, VT_I4, VTS_I4)
	DISP_FUNCTION(CWinHcsDoc, "Close", AutomationClose, VT_EMPTY, VTS_VARIANT VTS_VARIANT)
	DISP_FUNCTION(CWinHcsDoc, "Save", AutomationSave, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "SaveAs", AutomationSaveAs, VT_EMPTY, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsDoc, "Undo", AutomationUndo, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "PrintOut", AutomationPrintOut, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Mail", AutomationMail, VT_BOOL, VTS_VARIANT VTS_VARIANT)
	DISP_FUNCTION(CWinHcsDoc, "Activate", AutomationActivate, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Maximize", AutomationMaximize, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Minimize", AutomationMinimize, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "Restore", AutomationRestore, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsDoc, "OleObjects", AutomationOleItems, VT_VARIANT, VTS_VARIANT)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IWinHcs to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {BF7696E6-4DAC-11D3-B89C-0000861E056C}
static const IID IID_IWinHcs =
{ 0xbf7696e6, 0x4dac, 0x11d3, { 0xb8, 0x9c, 0x0, 0x0, 0x86, 0x1e, 0x5, 0x6c } };

BEGIN_INTERFACE_MAP(CWinHcsDoc, CRichEditDoc)
	INTERFACE_PART(CWinHcsDoc, IID_IWinHcs, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinHcsDoc construction/destruction

CWinHcsDoc::CWinHcsDoc()
{
	m_docType  = TYPE_UNDEFINED;
	m_lineOffset = 0;

	// Use OLE compound files
	EnableCompoundFile();
	EnableAutomation();

	AfxOleLockApp();
}

CWinHcsDoc::~CWinHcsDoc()
{
	AfxOleUnlockApp();
}

BOOL CWinHcsDoc::OnNewDocument()
{
	if (!CRichEditDoc::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

CRichEditCntrItem* CWinHcsDoc::CreateClientItem(REOBJECT* preo) const
{
	// cast away constness of this
	return new CWinHcsCntrItem(preo, (CWinHcsDoc*) this);
}


COleClientItem * CWinHcsDoc::FindEmbeddedItem(LPCSTR name)
{
	COleClientItem	*pItem = NULL;
	CString			s1, s2;

	ASSERT_VALID(this);
	ASSERT(AfxIsValidString(name));

	if ((pItem = OnFindEmbeddedItem(name)) != NULL)
		return pItem;


	s1 = name;

	POSITION pos = GetStartPosition();
	while ((pItem = GetNextClientItem(pos)) != NULL)
	{
		pItem->GetUserType(USERCLASSTYPE_APPNAME, s2);
		if (s1 == s2)
			return pItem;

		pItem->GetUserType(USERCLASSTYPE_SHORT, s2);
		if (s1 == s2)
			return pItem;

		pItem->GetUserType(USERCLASSTYPE_FULL, s2);
		if (s1 == s2)
			return pItem;
	}

	return pItem;
}


COleClientItem * CWinHcsDoc::FindEmbeddedItem(long index)
{
	POSITION		pos		= GetStartPosition();
	COleClientItem	*pItem	= NULL;
	long			i		= index;

	if (pos != NULL) {

		pItem = GetNextClientItem(pos);
        while(i) {

            if (pos == NULL) {

                pItem = NULL ;
                break ;

            } else {

				pItem = GetNextClientItem(pos);
            }
            i-- ;
        }
	}

	return pItem;
}

/////////////////////////////////////////////////////////////////////////////
// CWinHcsDoc serialization

void CWinHcsDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}

	// Calling the base class CRichEditDoc enables serialization
	//  of the container document's COleClientItem objects.
	// TODO: set CRichEditDoc::m_bRTF = FALSE if you are serializing as text
	CRichEditDoc::Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CWinHcsDoc diagnostics

#ifdef _DEBUG
void CWinHcsDoc::AssertValid() const
{
	CRichEditDoc::AssertValid();
}

void CWinHcsDoc::Dump(CDumpContext& dc) const
{
	CRichEditDoc::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinHcsDoc commands


#define	TMP_HCS_FILE	"~events.hcs"
#define	TMP_OUT_FILE	"~events.dat"
#define	TMP_BIN_FILE	"events.bin"



DWORD CALLBACK HcsWriteProgram(DWORD dwCookie, LPBYTE pData, LONG cb, LONG FAR *pcb)
{
	CFile *pFile = (CFile *) dwCookie;

	try
	{
		pFile->Write(pData, cb);
	}
	catch (CFileException *pEx)
	{
		pEx->Delete();
		*pcb = 0;

		return 1;
	}

	*pcb = cb;
	return 0;
}



BOOL CWinHcsDoc::Compile(void) 
{
#define READ_HANDLE		0
#define WRITE_HANDLE	1
#define OUT_BUFF_SIZE	128

	CWinHcsApp				*pApp = (CWinHcsApp *) AfxGetApp();
	CMainFrame				*pFrame	= (CMainFrame*) AfxGetMainWnd();
	char					*cmdP = pApp->m_xpressCompilerPath.GetBuffer(256);
	FILE					*fp;
	long					i;
	BOOL					flag = TRUE, bError = FALSE;
	DWORD					ret;
	char					*dirP;
	STARTUPINFO				startupInfo;
	PROCESS_INFORMATION		processInformation;
	char					cmd[1024];
	char					szBuffer[OUT_BUFF_SIZE];


	if (m_docType != TYPE_XPRESS) {
		_SOUND(m_sndFailure);
		return FALSE;
	}

	BeginWaitCursor();

	pFrame->DlgBarShow();
	pFrame->DlgBarClear();

	// Check if Compiler is defined
	if (cmdP == NULL || *cmdP == 0) {

		CString	str;

		str.LoadString(IDS_ERR_COMPILE);

		pFrame->DlgBarAddMessage(str.GetBuffer(128));
		EndWaitCursor();

		_SOUND(m_sndFailure);
		return FALSE;
	}

	// Get temp. directory
	if ((dirP = getenv("TMP")) == NULL)
		if ((dirP = getenv("TEMP")) == NULL)
			dirP = "C:\\";


	// Save document
	sprintf(cmd, "%s\\%s", dirP, TMP_HCS_FILE);
	_unlink(cmd);


	CRichEditCtrl			&theCtrl = GetView()->GetRichEditCtrl();
	EDITSTREAM				strm;
	CFile					fWrite(cmd, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary);

	m_lineOffset = 0;

	// Add HCS Configuration if required
	if (pApp->m_xpressAddHcsCfg == TRUE) {

		CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
		CHcsIo				*pIO;
		CString				str, def, io;
		long				t, id, n, iLastValid;
		char				*sP;

		sP = "! --- WinHcs Configuration \n\n";
		fWrite.Write(sP, strlen(sP));
		m_lineOffset += 2;

		def.Format("Config SC=HCS180\n");
		n  = def.GetLength();
		sP = def.GetBuffer(n);
		fWrite.Write(def, n);
		m_lineOffset++;

		n = pDoc->GetNbBUFIO();
		if (n > 0) {
			def.Format("Config BUF=%d\n", n);
			n  = def.GetLength();
			sP = def.GetBuffer(n);
			fWrite.Write(def, n);
			m_lineOffset++;
		}

		def.Format("Config PL-LINK=1\n");
		n  = def.GetLength();
		sP = def.GetBuffer(n);
		fWrite.Write(def, n);
		m_lineOffset++;

		n = pDoc->GetHcsMCIRs()->GetMaxInGroup();
		def.Format("Config IR-LINK=%d\n", n);
		n  = def.GetLength();
		sP = def.GetBuffer(n);
		fWrite.Write(def, n);
		m_lineOffset++;

		n = pDoc->GetHcsLCDs()->GetMaxInGroup();
		def.Format("Config LCD-LINK=%d\n", n);
		n  = def.GetLength();
		sP = def.GetBuffer(n);
		fWrite.Write(def, n);
		m_lineOffset++;

		n = pDoc->GetHcsDIOs()->GetMaxInGroup();
		def.Format("Config DIO-LINK=%d\n", n);
		n  = def.GetLength();
		sP = def.GetBuffer(n);
		fWrite.Write(def, n);
		m_lineOffset++;

		n = pDoc->GetHcsANSWERMANs()->GetMaxInGroup();
		def.Format("Config AMAN-LINK=%d\n\n", n);
		n  = def.GetLength();
		sP = def.GetBuffer(n);
		fWrite.Write(def, n);
		m_lineOffset += 2;


		for (t = 0 ; t < 9 ; t++) {

			switch (t) {
			default:
				pIO	= NULL;
				iLastValid	= 0;
				break;
			case 0:						// Digital inputs
				pIO	= pDoc->GetHcsInputs();
				iLastValid	= MAX_HCS_INPUTS;
				io	= "Input";
				break;
			case 1:					// Digital outputs
				pIO = pDoc->GetHcsOutputs();
				iLastValid	= MAX_HCS_OUTPUTS;
				io	= "Output";
				break;
			case 2:					// Digital netbits
				pIO	= pDoc->GetHcsNetbits();
				iLastValid	= MAX_NETBITS;
				io	= "Netbit";
				break;
			case 3:						// X10
				pIO	= pDoc->GetHcsX10();
				io	= "Module";
				iLastValid	= MAX_X10;
				break;
			case 4:						// ADCs
				pIO =  pDoc->GetHcsADCs();
				iLastValid	= MAX_ADCS;
				io	= "ADC";
				break;
			case 5:					// DACs
				pIO	= pDoc->GetHcsDACs();
				iLastValid	= MAX_DACS;
				io	= "DAC";
				break;
			case 6:						// Variables
				pIO	= pDoc->GetHcsVariables();
				iLastValid	= MAX_VARS;
				io	= "Variable";
				break;
			case 7:						// Timers
				pIO	= pDoc->GetHcsTimers();
				iLastValid	= MAX_TIMERS;
				io	= "Timer";
				break;
			case 8:						// LogIDS
				pIO	= pDoc->GetHcsLogIDs();
				iLastValid	= MAX_LOGID;
				io	= _T("");
				break;
			}

			for (id = 0 ; (id < iLastValid) && (pIO != NULL); id++) {

				if ((sP = pIO->GetIoLabel(id)) != NULL && sP[0] != 0) {

					// Format this one
					str = sP;
					n = str.Replace(' ', '_');

					switch (t) {
					default:
						def.Format("DEFINE %s = %s(%d)\n", str, io, id);
						break;
					case 3:
						def.Format("DEFINE %s = %s(%c%d)\n", str, io, ((id / 16) + 'A'), (((id % 16) & 0x0F) + 1));
						break;
					case 8:
						def.Format("DEFINE %s = %d\n", str, id);
						break;
					}

					// write configurtion
					n  = def.GetLength();
					sP = def.GetBuffer(n);

					fWrite.Write(def, n);
					m_lineOffset++;
				}
			}
		}

		sP = "\n! --- End WinHcs Configuration \n\n";
		fWrite.Write(sP, strlen(sP));
		m_lineOffset += 3;
	}


	// Add user's code
	memset(&strm, 0, sizeof(strm));
	strm.dwCookie	 = (DWORD) &fWrite;
	strm.pfnCallback =  HcsWriteProgram;

	i = theCtrl.StreamOut(SF_TEXT, strm);
	fWrite.Close();



	// Compile the document
	sprintf(cmd, "%s\\%s", dirP, TMP_OUT_FILE);
	_unlink(cmd);


	// Prepare the commands to execute
	sprintf(cmd, "command.com /C \"%s\" \"%s\\%s\" > \"%s\\%s\"",
			cmdP, dirP, TMP_HCS_FILE, dirP, TMP_OUT_FILE);

	// and setup the process to run
	memset(&startupInfo,        0, sizeof(startupInfo));
	memset(&processInformation, 0, sizeof(processInformation));

	startupInfo.dwFlags		= STARTF_USESHOWWINDOW;
	startupInfo.wShowWindow	= SW_HIDE;
//	startupInfo.wShowWindow	= SW_SHOW;

	flag = CreateProcess( 
			NULL,				// pointer to name of executable module 
			cmd,				// pointer to command line string 
			NULL,				// pointer to process security attributes 
			NULL,				// pointer to thread security attributes 
			TRUE,				// handle inheritance flag 
			CREATE_NEW_CONSOLE,	// creation flags 
//			FALSE,				// handle inheritance flag 
//			0,					// creation flags 
			NULL,				// pointer to new environment block 
			dirP,				// pointer to current directory name 
			&startupInfo,		// pointer to STARTUPINFO 
			&processInformation	// pointer to PROCESS_INFORMATION 
		); 

	if(!processInformation.hProcess) {

		CString str;
		str.LoadString(IDS_ERR_COMPILE_LAUNCH);

		pFrame->DlgBarAddMessage(str.GetBuffer(128));
		EndWaitCursor();

		_SOUND(m_sndFailure);
		return FALSE;
	}


	ret = WaitForSingleObject(processInformation.hProcess, 10000);

	if (ret == WAIT_FAILED) {
		ret = GetLastError();
		// Do something with a message box
	}

//	ret = TRUE;

	// Read the output file
	sprintf(cmd, "%s\\%s", dirP, TMP_OUT_FILE);

	if (_access(cmd, 4) < 0 || (fp = fopen(cmd, "r")) == NULL) {

		CString str;
		str.LoadString(IDS_ERR_COMPILE_OUTPUT);

		pFrame->DlgBarAddMessage(str.GetBuffer(128));
		EndWaitCursor();

		_SOUND(m_sndFailure);
		return FALSE;
	}

	i = 0;
	while (!feof(fp) && fgets(szBuffer, sizeof(szBuffer), fp) != NULL) {

		// Display the lines
		i = strlen(szBuffer) - 1;
		while ( i >= 0 && (
				szBuffer[i] == 0	|| 
				szBuffer[i] == 0xa	|| 
				szBuffer[i] == 0xd	||
				szBuffer[i] == 0x7)) {

			szBuffer[i] = 0;
			i--;
		}

		if (strstr(szBuffer, "error ") != NULL)
			bError = TRUE;

		pFrame->DlgBarAddMessage(szBuffer);
	}

	fclose(fp);

	EndWaitCursor();

	if (bError == TRUE) {
		_SOUND(m_sndFailure);
	} else {
		_SOUND(m_sndSuccess);
	}

	return TRUE;
}




BOOL CWinHcsDoc::CompileAndDownload(void)
{
	CWinHcsApp			*pApp	 = (CWinHcsApp *) AfxGetApp();
	CMainFrame			*pFrame	 = (CMainFrame*) AfxGetMainWnd();
	CWinHcsStatusDoc	*pHcsDoc = pApp->GetHcsStatusDoc();
	long				size, path;
	char				*dirP;
	char				*dataP;

	if (m_docType != TYPE_XPRESS) {

		CString str;
		str.LoadString(IDS_ERR_DOWNLOAD_DOC_TYPE);

		pFrame->DlgBarAddMessage(str.GetBuffer(128));

		_SOUND(m_sndFailure);
		return FALSE;
	}

	// Allocate buffer for program. Limited to 32KBytes
	// Also used for filename...
	dataP = (char *) malloc(32 * 1024);
	ASSERT(dataP);

	// Get temp. directory
	if ((dirP = getenv("TMP")) == NULL)
		if ((dirP = getenv("TEMP")) == NULL)
			dirP = "C:\\";


	// Get file to download
	sprintf(dataP, "%s\\%s", dirP, TMP_BIN_FILE);


	// Do we have to recompile the code?
	if (IsModified() == TRUE || _access(dataP, 4) < 0)
		Compile();


	// Open file and read data
	path = -1; 
	if (dataP == NULL ||
		_access(dataP, 4) < 0 ||
		(path = _open(dataP, _O_BINARY | _O_RDONLY)) < 0 ||
		(size = _read(path, dataP, 32 * 1024)) < 0) {

		CString str;
		str.LoadString(IDS_ERR_DOWNLOAD);

		pFrame->DlgBarAddMessage(str.GetBuffer(128));

		if (path >= 0)
			close(path);

		free(dataP);

		_SOUND(m_sndFailure);
		return FALSE;
	}
	close(path);

	// download the program
	pHcsDoc->DownloadNewProgram(dataP, size);

	return TRUE;
}




/////////////////////////////////////////////////////////////////////////////

static const char RTFPrefix[5] = {'{', '\\', 'r', 't', 'f'};

BOOL CWinHcsDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	CFile			file;
	CFileException	fe;
	CFileStatus		stat;
	BOOL			bTextFile = TRUE;
	CString			ext;

	// Determine if xpress or macro code
	if (lpszPathName != NULL) { 

		ext = CString(lpszPathName).Right(4);

		if (lstrcmpi(ext, _T(".hcx")) == 0) {

			m_docType	= TYPE_XPRESS;
			bTextFile	= FALSE;

		} else if (lstrcmpi(ext, _T(".hcm")) == 0) {

			m_docType	= TYPE_VBSCRIPT;
			bTextFile	= FALSE;

		} else if (lstrcmpi(ext, _T(".rtf")) == 0) {

			m_docType	= TYPE_UNDEFINED;
			bTextFile	= FALSE;

		} else {

			// Default but lets try to read the content as well
			m_docType	= TYPE_UNDEFINED;
			bTextFile	= TRUE;

			if (file.Open(lpszPathName, CFile::modeRead | CFile::shareDenyWrite, &fe)) {

				VERIFY(file.GetStatus(stat));

				if (stat.m_size != 0) {

					CHAR	buf[8];

					TRY
					{
						file.SeekToBegin();

						memset(buf, 0, 5);
						file.Read(buf, 5);

						if (memcmp(buf, RTFPrefix, 5) == 0)
							bTextFile = FALSE;
					}
					END_TRY
				}
				file.Close();
			}
		}
	}

	// Set if loadeing other file types
	if (bTextFile == TRUE)
		m_bRTF = FALSE;
	else
		m_bRTF = TRUE;

	if (!CRichEditDoc::OnOpenDocument(lpszPathName))
		return FALSE;


	// Try to update text documents, i.e. word marking
	if (bTextFile == TRUE) {

		CMainFrame*		pFrame		= (CMainFrame*) AfxGetMainWnd();
		CStatusBar*		pStatusBar	= (CStatusBar*) pFrame->GetDescendantWindow(AFX_IDW_STATUS_BAR);
		CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
		long			lineCount, lineNb, x;
		CString			s1;

		pCtrl.HideSelection(TRUE, FALSE);
		lineCount = pCtrl.GetLineCount();

		for (lineNb = 0 ; lineNb < lineCount ; lineNb++) {

			if (pStatusBar)	{
				x = (lineNb * 100) / lineCount;
				s1.Format(_T("Formating %u%%"), x);
				pStatusBar->SetPaneText(4, s1);
			}

			((CWinHcsView *) GetView())->ParseLine(lineNb, -1);
		}

		pCtrl.HideSelection(FALSE, FALSE);
		pCtrl.SetSel(0, 0);
	}

	return TRUE;
}



/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
//
//	Automation support
//
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////


VARIANT CWinHcsDoc::AutomationGetApplication() 
{
	CWinHcsApp	*pApp    = (CWinHcsApp *) AfxGetApp();
	VARIANT		vaResult;

	VariantInit(&vaResult);

	vaResult.vt = VT_DISPATCH;
	vaResult.punkVal = pApp->GetIDispatch(TRUE);

	return vaResult;
}


BSTR CWinHcsDoc::AutomationGetFilename() 
{
	CString strResult = GetPathName();

	return strResult.AllocSysString();
}

void CWinHcsDoc::AutomationSetFilename(LPCTSTR lpszNewValue) 
{
	SetPathName(lpszNewValue, TRUE);
}

BSTR CWinHcsDoc::AutomationGetTitle() 
{
	CString strResult = GetTitle ();

	return strResult.AllocSysString();
}

void CWinHcsDoc::AutomationSetTitle(LPCTSTR lpszNewValue) 
{
	SetTitle (lpszNewValue);
}


BOOL CWinHcsDoc::AutomationDeleteContent() 
{
	DeleteContents ();
	return TRUE;
}

BOOL CWinHcsDoc::AutomationCompile() 
{
	return Compile();
}

BOOL CWinHcsDoc::AutomationCompileAndDownload() 
{
	return CompileAndDownload();
}


BOOL CWinHcsDoc::AutomationFind(LPCTSTR findString, BOOL caseSensitive, BOOL wholeWords) 
{
	return GetView()->FindText(findString, caseSensitive, wholeWords);
}

BOOL CWinHcsDoc::AutomationReplaceSelection(LPCTSTR newText) 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();

	pCtrl.ReplaceSel(newText, TRUE);
	return TRUE;
}

long CWinHcsDoc::AutomationGetSelectionStart() 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
	long			start, end;

	pCtrl.GetSel(start, end);

	return start;
}

void CWinHcsDoc::AutomationSetSelectionStart(long nNewValue) 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
	long			start, end;

	pCtrl.GetSel(start, end);
	start = nNewValue;

	pCtrl.SetSel(start, end);
}

long CWinHcsDoc::AutomationGetSelectionEnd() 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
	long			start, end;

	pCtrl.GetSel(start, end);

	return end;
}

void CWinHcsDoc::AutomationSetSelectionEnd(long nNewValue) 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
	long			start, end;

	pCtrl.GetSel(start, end);
	end = nNewValue;

	pCtrl.SetSel(start, end);
}

long CWinHcsDoc::AutomationGetLineCount() 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();

	return pCtrl.GetLineCount();
}


long CWinHcsDoc::AutomationLineIndex(long line) 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();

	return pCtrl.LineIndex(line);
}


void CWinHcsDoc::AutomationClear() 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
	pCtrl.Clear ();
}

void CWinHcsDoc::AutomationCut() 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
	pCtrl.Cut ();
}

void CWinHcsDoc::AutomationPaste() 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();

	if (pCtrl.CanPaste () == TRUE)
		pCtrl.Paste ();
}


BOOL CWinHcsDoc::AutomationUndo() 
{
	CRichEditCtrl	& pCtrl		= GetView()->GetRichEditCtrl();
	return pCtrl.Undo ();
}


BOOL CWinHcsDoc::AutomationMaximize() 
{
    if (GetView() != NULL)
        return GetView()->ShowWindow( SW_SHOWMAXIMIZED ) ;

	return FALSE;
}
BOOL CWinHcsDoc::AutomationMinimize() 
{
    if (GetView() != NULL)
        return GetView()->ShowWindow( SW_MINIMIZE ) ;

	return FALSE;
}
BOOL CWinHcsDoc::AutomationRestore() 
{
    if (GetView() != NULL)
        return GetView()->ShowWindow( SW_RESTORE ) ;

	return FALSE;
}

void CWinHcsDoc::AutomationActivate() 
{
    CView		*pView;
	CFrameWnd	*pFrameWnd;

    AutomationSetVisible( TRUE ) ;
    
    if ((pView = GetView()) != NULL) {

        pView->ShowWindow( SW_SHOW ) ;

        if ((pFrameWnd = pView->GetParentFrame()) != NULL)
            pFrameWnd->BringWindowToTop() ;
    }
}


BOOL CWinHcsDoc::AutomationGetVisible() 
{
	return GetView()->IsWindowVisible();
}

void CWinHcsDoc::AutomationSetVisible(BOOL bNewValue) 
{
    CFrameWnd* pFrameWnd = GetView()->GetParentFrame();

	if (bNewValue == TRUE) {

        if (!pFrameWnd->IsWindowVisible())
            pFrameWnd->ShowWindow(SW_SHOWNA);
        
        pFrameWnd = pFrameWnd->GetParentFrame() ;                
        if (pFrameWnd && !pFrameWnd->IsWindowVisible())
            pFrameWnd->ShowWindow(SW_SHOWNA);

		GetView()->UpdateWindow();

	} else {

		pFrameWnd->ShowWindow(SW_HIDE);
	}

	AfxOleSetUserCtrl(bNewValue);
}



long CWinHcsDoc::AutomationLineLength(long line) 
{
	long			sz = 0, idx;
	CRichEditCtrl	& pCtrl = GetView()->GetRichEditCtrl();

	if (line > 0) {
		idx	= pCtrl.LineIndex(line - 1);
		sz	= pCtrl.LineLength(idx);
	}

	return sz;
}

void CWinHcsDoc::AutomationClose(const VARIANT FAR& saveChanges, const VARIANT FAR& filename) 
{
    if (saveChanges.vt == VT_BOOL)
    {
        if (saveChanges.boolVal == FALSE)
            SetModifiedFlag( FALSE ) ;
    }

    if (filename.vt == VT_BSTR)
    {
        AutomationSaveAs( filename ) ;
    }
         
    m_bAutoDelete = FALSE ;         
    OnCloseDocument() ;  
    m_bAutoDelete = TRUE ;
}

void CWinHcsDoc::AutomationSave() 
{
    OnSaveDocument( GetPathName() );
}

void CWinHcsDoc::AutomationSaveAs(const VARIANT FAR& filename) 
{
	LPCTSTR	sP = (LPCTSTR) filename.bstrVal;

    if (filename.vt == VT_BSTR)
        SetPathName( sP, TRUE ) ;
    
    OnSaveDocument( GetPathName() ) ;
}

BOOL CWinHcsDoc::AutomationGetSaved() 
{
	return IsModified();
}

void CWinHcsDoc::AutomationSetSaved(BOOL bNewValue) 
{
	SetModifiedFlag(bNewValue);
}


BOOL CWinHcsDoc::AutomationPrintOut() 
{
	return ((CWinHcsView *) GetView())->Print();
}


BOOL CWinHcsDoc::AutomationMail(const VARIANT FAR& To, const VARIANT FAR& Subject) 
{
	this->OnFileSendMail();
	return TRUE;
}



VARIANT CWinHcsDoc::AutomationOleItems(const VARIANT FAR& item) 
{
    VARIANT		va ;
	CWinHcsOles	*pItems;

    VariantInit( &va ) ;
    va.vt	= VT_DISPATCH ;

    pItems  = (CWinHcsOles*) new CWinHcsOles(this);
    
    ASSERT(pItems) ;
    if (pItems == NULL || !pItems->IsKindOf(RUNTIME_CLASS(CWinHcsOles)))
    {
        va.punkVal = NULL ;
    }
    else if (item.vt == VT_ERROR || item.vt == VT_EMPTY)
    {
        va.punkVal  = pItems->GetIDispatch(FALSE) ;    
    }
    else
    {
        va.pdispVal  = pItems->AutomationGetItem( item ) ;
        delete pItems ;
    }
    return va ;
}


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
// WinHcsDocs
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CWinHcsDocs

IMPLEMENT_DYNCREATE(CWinHcsDocs, CCmdTarget)

CWinHcsDocs::CWinHcsDocs()
{
	m_docType = TYPE_XPRESS;

	EnableAutomation();
    AfxOleLockApp();
}

CWinHcsDocs::~CWinHcsDocs()
{
	AfxOleUnlockApp();
}


void CWinHcsDocs::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	delete this;
//	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CWinHcsDocs, CCmdTarget)
	//{{AFX_MSG_MAP(CWinHcsDocs)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CWinHcsDocs, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CWinHcsDocs)
	DISP_PROPERTY_EX(CWinHcsDocs, "Count", AutomationGetCount, SetNotSupported, VT_I2)
	DISP_FUNCTION(CWinHcsDocs, "Add", AutomationAdd, VT_VARIANT, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsDocs, "Item", AutomationGetItem, VT_DISPATCH, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsDocs, "Open", AutomationOpen, VT_VARIANT, VTS_BSTR)
	//}}AFX_DISPATCH_MAP
    DISP_DEFVALUE(CWinHcsDocs, "Item")
    DISP_PROPERTY_EX_ID(CWinHcsDocs, "_NewEnum", DISPID_NEWENUM, _NewEnum, SetNotSupported, VT_UNKNOWN)
END_DISPATCH_MAP()


// Note: we add support for IID_IWinHcsDocs to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {DED34BF6-7866-11D3-80C5-0050048D8843}
static const IID IID_IWinHcsDocs =
{ 0xded34bf6, 0x7866, 0x11d3, { 0x80, 0xc5, 0x0, 0x50, 0x4, 0x8d, 0x88, 0x43 } };

BEGIN_INTERFACE_MAP(CWinHcsDocs, CCmdTarget)
	INTERFACE_PART(CWinHcsDocs, IID_IWinHcsDocs, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinHcsDocs message handlers

short CWinHcsDocs::AutomationGetCount() 
{
	CMultiDocTemplate	*pTemplate;
    POSITION			pos;
    short				n = 0 ;
	
	if (m_docType == TYPE_XPRESS)
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pDocTemplate;
	else
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pMacroTemplate;

	// Count	
    pos = pTemplate->GetFirstDocPosition() ;
    while (pos != NULL && pTemplate->GetNextDoc( pos ))
        n++ ;

    return n ;
}

VARIANT CWinHcsDocs::AutomationOpen(LPCTSTR filename) 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	return pApp->AutomationOpenDocument(filename);
}

VARIANT CWinHcsDocs::AutomationAdd(const VARIANT FAR& name) 
{
	VARIANT				vaResult;
	CMultiDocTemplate	*pTemplate;
	CWinHcsDoc			*pDoc = NULL;
    short				n = 0 ;
	
	VariantInit(&vaResult);
	vaResult.vt		 = VT_DISPATCH;
	vaResult.punkVal = NULL;


	if (m_docType == TYPE_XPRESS)
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pDocTemplate;
	else
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pMacroTemplate;


	pDoc = (CWinHcsDoc *) pTemplate->OpenDocumentFile(NULL, TRUE);

	if (pDoc) {

		pDoc->m_docType = m_docType;
        if (name.vt == VT_BSTR)
            pDoc->SetTitle((char *) name.bstrVal ) ;

		vaResult.punkVal = pDoc->GetIDispatch(TRUE);
	}    

	return vaResult;
}


// object.Item( index )
//      Returns the Document specified by index.  index can either
//      be a document name or number
//
LPDISPATCH CWinHcsDocs::AutomationGetItem( const VARIANT FAR& vt )
{   
	CMultiDocTemplate	*pTemplate;
	CWinHcsDoc			*pItem = NULL;
    LPDISPATCH			lpDisp = NULL ;
	POSITION			pos = NULL;

	if (m_docType == TYPE_XPRESS)
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pDocTemplate;
	else
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pMacroTemplate;

    
    pos = pTemplate->GetFirstDocPosition() ;
    if (pos == NULL)
        return NULL;

    if (vt.vt == VT_BSTR)   {

        // for each document compare...
        while (pos != NULL)
        {
            pItem = (CWinHcsDoc *) pTemplate->GetNextDoc( pos ) ;
            if (pItem) {
                if (lstrcmpi( pItem->GetTitle(), (char *) vt.bstrVal ) == 0)
                    break ;
            }
        }

    } else /*if (vt.vt == VT_I4) */{

        // coerce to VT_I4
        VARIANT va ;
        VariantInit( &va );

        if (SUCCEEDED(VariantChangeType( &va, (VARIANT FAR*)&vt, 0, VT_I4 ))) {

            pItem = (CWinHcsDoc *) pTemplate->GetNextDoc( pos ) ;
            while(va.lVal) {

                if (pos == NULL) {
                    // off the end..
                    pItem = NULL ;
                    break ;

                } else {

                    pItem = (CWinHcsDoc *) pTemplate->GetNextDoc( pos ) ;
                }
                va.lVal-- ;
            }
        }
    }                 
    
    if (pItem != NULL) {
        lpDisp = pItem->GetIDispatch(TRUE) ;        // AddRef
	}

    // BUGBUG:  Implement dispatch exception if lpDisp == NULL
    return lpDisp ;
}


// _NewEnum is a hidden method called by VBA during "For Each"
// processing
//
LPUNKNOWN CWinHcsDocs::_NewEnum()
{
    CEnumDocs	*pIEV = NULL ;

    pIEV = new CEnumDocs ;
    pIEV->m_xEnumVARIANT.m_docType = m_docType;

    if (pIEV) {

        pIEV->m_xEnumVARIANT.Reset() ;
        return &pIEV->m_xEnumVARIANT ;
    }
    
    return NULL ;
}

//----------------------------------------------------------------------------
// Implementation of CEnumDocs which implements the IEnumVARIANT interface
// used by _NewEnum
//
BEGIN_INTERFACE_MAP(CEnumDocs, CCmdTarget)
    INTERFACE_PART(CEnumDocs, IID_IEnumVARIANT, EnumVARIANT)
END_INTERFACE_MAP()

CEnumDocs::CEnumDocs()
{
    //TRACE("CEnumVARAINT::CEnumDocs()\r\n" ) ;
	m_xEnumVARIANT.m_docType = TYPE_XPRESS;
    AfxOleLockApp();
}

CEnumDocs::~CEnumDocs()
{
    //TRACE("CEnumVARAINT::~CEnumDocs()\r\n" ) ;
    AfxOleUnlockApp();
}

void CEnumDocs::OnFinalRelease()
{
    // When the last reference for an automation object is released
    //  OnFinalRelease is called.  This implementation deletes the 
    //  object.  Add additional cleanup required for your object before
    //  deleting it from memory.
    //TRACE("CEnumDocs::OnFinalRelease\r\n" ) ;
    delete this;
}

//----------------------------------------------------------------------------
// Implementation of the nested class XEnumVARIANT (declared through the
// BEGIN/END_INTERFACE_PART macros in the declaration of CEnumDocs)
//
// This class implements the IEnumVARIANT interface requried by the 
// _NewEnum property of the collection
//
CEnumDocs::XEnumVARIANT::XEnumVARIANT()
{
    m_posCurrent = NULL ;
}

STDMETHODIMP_(ULONG) CEnumDocs::XEnumVARIANT::AddRef()
{   
    METHOD_PROLOGUE(CEnumDocs, EnumVARIANT)
    return pThis->ExternalAddRef() ;
}   

STDMETHODIMP_(ULONG) CEnumDocs::XEnumVARIANT::Release()
{   
    METHOD_PROLOGUE(CEnumDocs, EnumVARIANT)
    return pThis->ExternalRelease() ;
}   

STDMETHODIMP CEnumDocs::XEnumVARIANT::QueryInterface( REFIID iid, void FAR* FAR* ppvObj )
{   
    METHOD_PROLOGUE(CEnumDocs, EnumVARIANT)
    return (HRESULT)pThis->ExternalQueryInterface( (void FAR*)&iid, ppvObj) ;
}   

// IEnumVARIANT::Next
// 
STDMETHODIMP CEnumDocs::XEnumVARIANT::Next( ULONG celt, VARIANT FAR* rgvar, ULONG FAR* pceltFetched)
{
    // This sets up the "pThis" pointer so that it points to our
    // containing CRequests instance
    //
    METHOD_PROLOGUE(CEnumDocs, EnumVARIANT)

    HRESULT				hr;
    ULONG				l;
	CMultiDocTemplate	*pTemplate;
	CWinHcsDoc			*pItem = NULL;

	if (m_docType == TYPE_XPRESS)
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pDocTemplate;
	else
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pMacroTemplate;

    // pceltFetched can legally == 0
    //                                           
    if (pceltFetched != NULL)
        *pceltFetched = 0;
    else if (celt > 1)
    {   
        TRACE("XEnumVARIANT::Next() celt > 1 and pceltFetched == NULL!\r\n", celt ) ;
        return ResultFromScode( E_INVALIDARG ) ;   
    }

    for (l=0; l < celt; l++)
        VariantInit( &rgvar[l] ) ;

    // Retrieve the next celt elements.
    hr = NOERROR ;
    for (l = 0 ; m_posCurrent != NULL && celt != 0 ; l++)
    {   
        pItem = (CWinHcsDoc *) pTemplate->GetNextDoc( m_posCurrent ) ;
        celt-- ;
        if (pItem)
        {
            //TRACE( "   Setting rgvar[%d]\r\n", (int)l ) ;
            rgvar[l].vt = VT_DISPATCH ;
            rgvar[l].punkVal = pItem->GetIDispatch( TRUE ) ;
            if (pceltFetched != NULL)
                (*pceltFetched)++ ;
        }
        else 
        {
            TRACE("GetNext failed in IEnumVARIANT::Next\r\n" ) ;
            return ResultFromScode( E_UNEXPECTED ) ;
        }
    }
    
    if (celt != 0)
    {
        //TRACE( "   End of list...celt == %d\r\n", (int)celt ) ;
        hr = ResultFromScode( S_FALSE ) ;
    }
    
    return hr ;
}

// IEnumVARIANT::Skip
//
STDMETHODIMP CEnumDocs::XEnumVARIANT::Skip(unsigned long celt) 
{
    METHOD_PROLOGUE(CEnumDocs, EnumVARIANT)
	CMultiDocTemplate	*pTemplate;

	if (m_docType == TYPE_XPRESS)
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pDocTemplate;
	else
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pMacroTemplate;


    //TRACE("XEnumVARIANT::Skip( %l )\r\n", celt ) ;
    
    while (m_posCurrent != NULL && celt--)
        pTemplate->GetNextDoc( m_posCurrent ) ;
    
    return (celt == 0 ? NOERROR : ResultFromScode( S_FALSE )) ;
}

STDMETHODIMP CEnumDocs::XEnumVARIANT::Reset()
{
    METHOD_PROLOGUE(CEnumDocs, EnumVARIANT)
    //TRACE("XEnumVARIANT::Reset()\r\n") ;
	CMultiDocTemplate	*pTemplate;

	if (m_docType == TYPE_XPRESS)
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pDocTemplate;
	else
		pTemplate = ((CWinHcsApp *) AfxGetApp())->m_pMacroTemplate;

    m_posCurrent = pTemplate->GetFirstDocPosition() ;
    
    return NOERROR ;
}

STDMETHODIMP CEnumDocs::XEnumVARIANT::Clone(IEnumVARIANT FAR* FAR* ppenum) 
{
    METHOD_PROLOGUE(CEnumDocs, EnumVARIANT)   
    //TRACE("XEnumVARIANT::Clone()\r\n" ) ;

    CEnumDocs* p = new CEnumDocs ;
    if (p)
    {
        p->m_xEnumVARIANT.m_posCurrent = m_posCurrent ;
        return NOERROR ;    
    }
    else
        return ResultFromScode( E_OUTOFMEMORY ) ;
}





/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
// WinHcsOle Objects
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CWinHcsOles

IMPLEMENT_DYNCREATE(CWinHcsOles, CCmdTarget)

CWinHcsOles::CWinHcsOles()
{
	m_pDoc = NULL;

	EnableAutomation();
    AfxOleLockApp();
}
CWinHcsOles::CWinHcsOles(CWinHcsDoc *pDoc)
{
	m_pDoc = pDoc;

	EnableAutomation();
    AfxOleLockApp();
}

CWinHcsOles::~CWinHcsOles()
{
    AfxOleUnlockApp();
}


void CWinHcsOles::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	delete this;
//	CCmdTarget::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CWinHcsOles, CCmdTarget)
	//{{AFX_MSG_MAP(CWinHcsOles)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CWinHcsOles, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CWinHcsOles)
	DISP_PROPERTY_EX(CWinHcsOles, "Count", AutomationGetCount, SetNotSupported, VT_I2)
	DISP_FUNCTION(CWinHcsOles, "Item", AutomationGetItem, VT_DISPATCH, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsOles, "GetItemFullType", AutomationGetItemFullType, VT_BSTR, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsOles, "GetItemShortType", AutomationGetItemShortType, VT_BSTR, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsOles, "GetItemAppName", AutomationGetItemAppName, VT_BSTR, VTS_VARIANT)
	//}}AFX_DISPATCH_MAP
    DISP_DEFVALUE(CWinHcsDocs, "Item")
    DISP_PROPERTY_EX_ID(CWinHcsOles, "_NewEnum", DISPID_NEWENUM, _NewEnum, SetNotSupported, VT_UNKNOWN)
END_DISPATCH_MAP()

// Note: we add support for IID_IWinHcsOles to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {2FD3F8C6-79EC-11D3-80C6-0050048D8843}
static const IID IID_IWinHcsOles =
{ 0x2fd3f8c6, 0x79ec, 0x11d3, { 0x80, 0xc6, 0x0, 0x50, 0x4, 0x8d, 0x88, 0x43 } };

BEGIN_INTERFACE_MAP(CWinHcsOles, CCmdTarget)
	INTERFACE_PART(CWinHcsOles, IID_IWinHcsOles, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinHcsOles message handlers


short CWinHcsOles::AutomationGetCount() 
{
	POSITION		pos = NULL;
	short			n = 0;
    COleClientItem	*pItem;

	pos = m_pDoc->GetStartPosition();

	while (pos != NULL && (pItem = m_pDoc->GetNextClientItem(pos)) != NULL)
		n++;

	return n;
}


LPDISPATCH CWinHcsOles::AutomationGetItem(const VARIANT FAR& vt) 
{
	COleClientItem		*pItem		= NULL;
    LPUNKNOWN			lpUnk		= NULL;
    LPDISPATCH			lpDispatch	= NULL;
    LPOLELINK			lpOleLink	= NULL;


    if (vt.vt == VT_BSTR)   {

		CString str(vt.bstrVal);

		if ((pItem = m_pDoc->FindEmbeddedItem(str)) == NULL)
			return NULL;

    } else {

		// coerce to VT_I4
        VARIANT va ;
        VariantInit( &va );

		if (SUCCEEDED(VariantChangeType( &va, (VARIANT FAR*)&vt, 0, VT_I4 )))
			pItem = m_pDoc->FindEmbeddedItem(va.lVal);
    }                 


	// And now get return lpdispatch
	if (pItem != NULL) {

		ASSERT_VALID(pItem);
		ASSERT(pItem->m_lpObject != NULL);

		lpUnk = pItem->m_lpObject;
		pItem->Run();    // must be running

		if (pItem->m_lpObject->QueryInterface(IID_IOleLink, (LPVOID FAR*)&lpOleLink) == NOERROR) {

			ASSERT(lpOleLink != NULL);

			lpUnk = NULL;

			if (lpOleLink->GetBoundSource(&lpUnk) != NOERROR)
				return NULL;

			ASSERT(lpUnk != NULL);
		}

		if (lpUnk->QueryInterface(IID_IDispatch, (void **) &lpDispatch) != NOERROR)
			return NULL;
	}


	// BUGBUG:  Implement dispatch exception if lpDisp == NULL
	return lpDispatch;
}



BSTR CWinHcsOles::AutomationGetItemFullType(const VARIANT FAR& vt) 
{
	COleClientItem		*pItem		= NULL;
	CString strResult;

    if (vt.vt == VT_BSTR)   {

		CString str(vt.bstrVal);

		if ((pItem = m_pDoc->FindEmbeddedItem(str)) == NULL)
			return NULL;

    } else {

		// coerce to VT_I4
        VARIANT va ;
        VariantInit( &va );

		if (SUCCEEDED(VariantChangeType( &va, (VARIANT FAR*)&vt, 0, VT_I4 )))
			pItem = m_pDoc->FindEmbeddedItem(va.lVal);
    }                 

	if (pItem != NULL)
		pItem->GetUserType(USERCLASSTYPE_FULL, strResult);

	return strResult.AllocSysString();
}

BSTR CWinHcsOles::AutomationGetItemShortType(const VARIANT FAR& vt) 
{
	COleClientItem		*pItem		= NULL;
	CString strResult;

    if (vt.vt == VT_BSTR)   {

		CString str(vt.bstrVal);

		if ((pItem = m_pDoc->FindEmbeddedItem(str)) == NULL)
			return NULL;

    } else {

		// coerce to VT_I4
        VARIANT va ;
        VariantInit( &va );

		if (SUCCEEDED(VariantChangeType( &va, (VARIANT FAR*)&vt, 0, VT_I4 )))
			pItem = m_pDoc->FindEmbeddedItem(va.lVal);
    }                 

	if (pItem != NULL)
		pItem->GetUserType(USERCLASSTYPE_SHORT, strResult);

	return strResult.AllocSysString();
}

BSTR CWinHcsOles::AutomationGetItemAppName(const VARIANT FAR& vt) 
{
	COleClientItem		*pItem		= NULL;
	CString strResult;

    if (vt.vt == VT_BSTR)   {

		CString str(vt.bstrVal);

		if ((pItem = m_pDoc->FindEmbeddedItem(str)) == NULL)
			return NULL;

    } else {

		// coerce to VT_I4
        VARIANT va ;
        VariantInit( &va );

		if (SUCCEEDED(VariantChangeType( &va, (VARIANT FAR*)&vt, 0, VT_I4 )))
			pItem = m_pDoc->FindEmbeddedItem(va.lVal);
    }                 

	if (pItem != NULL)
		pItem->GetUserType(USERCLASSTYPE_APPNAME, strResult);

	return strResult.AllocSysString();
}


// _NewEnum is a hidden method called by VBA during "For Each"
// processing
//
LPUNKNOWN CWinHcsOles::_NewEnum()
{
    CEnumOles	*pIEV = NULL ;

    pIEV = new CEnumOles(m_pDoc);

    if (pIEV) {

        pIEV->m_xEnumVARIANT.Reset() ;
        return &pIEV->m_xEnumVARIANT ;
    }
    
    return NULL ;
}


//----------------------------------------------------------------------------
// Implementation of CEnumOles which implements the IEnumVARIANT interface
// used by _NewEnum
//
BEGIN_INTERFACE_MAP(CEnumOles, CCmdTarget)
    INTERFACE_PART(CEnumOles, IID_IEnumVARIANT, EnumVARIANT)
END_INTERFACE_MAP()

CEnumOles::CEnumOles(CWinHcsDoc *pDoc)
{
    //TRACE("CEnumVARAINT::CEnumOles()\r\n" ) ;
	m_xEnumVARIANT.m_pDoc = pDoc;
    AfxOleLockApp();
}

CEnumOles::~CEnumOles()
{
    //TRACE("CEnumVARAINT::~CEnumOles()\r\n" ) ;
    AfxOleUnlockApp();
}

void CEnumOles::OnFinalRelease()
{
    // When the last reference for an automation object is released
    //  OnFinalRelease is called.  This implementation deletes the 
    //  object.  Add additional cleanup required for your object before
    //  deleting it from memory.
    //TRACE("CEnumOles::OnFinalRelease\r\n" ) ;
    delete this;
}

//----------------------------------------------------------------------------
// Implementation of the nested class XEnumVARIANT (declared through the
// BEGIN/END_INTERFACE_PART macros in the declaration of CEnumOles)
//
// This class implements the IEnumVARIANT interface requried by the 
// _NewEnum property of the collection
//
CEnumOles::XEnumVARIANT::XEnumVARIANT()
{
    m_posCurrent = NULL ;
}

STDMETHODIMP_(ULONG) CEnumOles::XEnumVARIANT::AddRef()
{   
    METHOD_PROLOGUE(CEnumOles, EnumVARIANT)
    return pThis->ExternalAddRef() ;
}   

STDMETHODIMP_(ULONG) CEnumOles::XEnumVARIANT::Release()
{   
    METHOD_PROLOGUE(CEnumOles, EnumVARIANT)
    return pThis->ExternalRelease() ;
}   

STDMETHODIMP CEnumOles::XEnumVARIANT::QueryInterface( REFIID iid, void FAR* FAR* ppvObj )
{   
    METHOD_PROLOGUE(CEnumOles, EnumVARIANT)
    return (HRESULT)pThis->ExternalQueryInterface( (void FAR*)&iid, ppvObj) ;
}   

// IEnumVARIANT::Next
// 
STDMETHODIMP CEnumOles::XEnumVARIANT::Next( ULONG celt, VARIANT FAR* rgvar, ULONG FAR* pceltFetched)
{
    // This sets up the "pThis" pointer so that it points to our
    // containing CRequests instance
    //
    METHOD_PROLOGUE(CEnumOles, EnumVARIANT)

	COleClientItem		*pItem;
    HRESULT				hr;
    ULONG				l;
    LPUNKNOWN			lpUnk		= NULL;
    LPDISPATCH			lpDispatch	= NULL;
    LPOLELINK			lpOleLink	= NULL;


    // pceltFetched can legally == 0
    //                                           
    if (pceltFetched != NULL)
        *pceltFetched = 0;
    else if (celt > 1)
    {   
        TRACE("XEnumVARIANT::Next() celt > 1 and pceltFetched == NULL!\r\n", celt ) ;
        return ResultFromScode( E_INVALIDARG ) ;   
    }

    for (l=0; l < celt; l++)
        VariantInit( &rgvar[l] ) ;

    // Retrieve the next celt elements.
    hr = NOERROR ;
    for (l = 0 ; m_posCurrent != NULL && celt != 0 ; l++)
    {   
        pItem = m_pDoc->GetNextClientItem( m_posCurrent ) ;
        celt-- ;
        if (pItem)
        {
			ASSERT_VALID(pItem);
			ASSERT(pItem->m_lpObject != NULL);

			lpUnk = pItem->m_lpObject;
			pItem->Run();    // must be running

			if (pItem->m_lpObject->QueryInterface(IID_IOleLink, (LPVOID FAR*)&lpOleLink) == NOERROR) {

				ASSERT(lpOleLink != NULL);

				lpUnk = NULL;

				if (lpOleLink->GetBoundSource(&lpUnk) != NOERROR)
		            return ResultFromScode( E_UNEXPECTED ) ;

				ASSERT(lpUnk != NULL);
			}

			if (lpUnk->QueryInterface(IID_IDispatch, (void **) &lpDispatch) != NOERROR)
	            return ResultFromScode( E_UNEXPECTED ) ;
            
			
			//TRACE( "   Setting rgvar[%d]\r\n", (int)l ) ;
            rgvar[l].vt = VT_DISPATCH ;
            rgvar[l].punkVal = lpDispatch;
            if (pceltFetched != NULL)
                (*pceltFetched)++ ;
        }
        else 
        {
            TRACE("GetNext failed in IEnumVARIANT::Next\r\n" ) ;
            return ResultFromScode( E_UNEXPECTED ) ;
        }
    }
    
    if (celt != 0)
    {
        //TRACE( "   End of list...celt == %d\r\n", (int)celt ) ;
        hr = ResultFromScode( S_FALSE ) ;
    }
    
    return hr ;
}

// IEnumVARIANT::Skip
//
STDMETHODIMP CEnumOles::XEnumVARIANT::Skip(unsigned long celt) 
{
    METHOD_PROLOGUE(CEnumOles, EnumVARIANT)

	//TRACE("XEnumVARIANT::Skip( %l )\r\n", celt ) ;
    
    while (m_posCurrent != NULL && celt--)
        m_pDoc->GetNextClientItem( m_posCurrent ) ;
    
    return (celt == 0 ? NOERROR : ResultFromScode( S_FALSE )) ;
}

STDMETHODIMP CEnumOles::XEnumVARIANT::Reset()
{
    METHOD_PROLOGUE(CEnumOles, EnumVARIANT)

	//TRACE("XEnumVARIANT::Reset()\r\n") ;

    m_posCurrent = m_pDoc->GetStartPosition() ;

    return NOERROR ;
}

STDMETHODIMP CEnumOles::XEnumVARIANT::Clone(IEnumVARIANT FAR* FAR* ppenum) 
{
    METHOD_PROLOGUE(CEnumOles, EnumVARIANT)   
    //TRACE("XEnumVARIANT::Clone()\r\n" ) ;

    CEnumOles* p = new CEnumOles(m_pDoc);
    if (p)
    {
        p->m_xEnumVARIANT.m_posCurrent = m_posCurrent ;
        p->m_xEnumVARIANT.m_pDoc = m_pDoc ;
        return NOERROR ;    
    }
    else
        return ResultFromScode( E_OUTOFMEMORY ) ;
}
