/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// WinHcs.h : main header file for the WINHCS application
//

#if !defined(AFX_WINHCS_H__BF7696E9_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
#define AFX_WINHCS_H__BF7696E9_4DAC_11D3_B89C_0000861E056C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include <mmsystem.h>

#include "resource.h"       // main symbols
#include "WinHcsStatusDoc.h"
#include "MainFrm.h"



extern UDACCEL	GLB_Acc[];
#define	GLB_ACC_SZ		3

#define	_SOUND(filename)	\
	if (((CWinHcsApp *) AfxGetApp())->m_sndEnabled == TRUE && ((CWinHcsApp *) AfxGetApp())->filename.IsEmpty() == 0)			\
		(void) ::PlaySound(((CWinHcsApp *) AfxGetApp())->filename, NULL, SND_FILENAME);


class CWinHcsView;

/////////////////////////////////////////////////////////////////////////////
// CWinHcsApp:
// See WinHcs.cpp for the implementation of this class
//

class CWinHcsApp : public CWinApp
{
public:
	CString				m_startupDir;
	CString				m_xpressCompilerPath;
	CString				m_xpressBin2SourcePath;
	BOOL				m_xpressAddHcsCfg;
	CString				m_MacroHcsMacroPath;
	long				m_MacroTimeout;

	// Sound Files
	BOOL				m_sndEnabled;
	CString				m_sndSuccess;
	CString				m_sndFailure;
	CString				m_sndHcsConnect;
	CString				m_sndHcsError;


	BOOL				m_bTCPConnectionChanged;
	long				m_TCPConnectionCounter;


	CMultiDocTemplate	*m_pDocTemplate,
						*m_pMacroTemplate,
						*m_pStatusTemplate;


public:
	long GetProfileLong(unsigned int group, unsigned int entry, long def);
	BOOL SetProfileLong(unsigned int group, unsigned int entry, long value);
	CString	GetProfileCString(unsigned int group, unsigned int entry, LPCTSTR def);
	BOOL SetProfileCString(unsigned int group, unsigned int entry, CString value);

	BOOL RestoreWindowPosition(CWnd* pWnd, unsigned int Section, unsigned int Key);
	BOOL RestoreWindowPosition(CWnd* pWnd, CString szSection, CString szKey);
	BOOL SaveWindowPosition(CWnd* pWnd, unsigned int Section, unsigned int Key);
	BOOL SaveWindowPosition(CWnd* pWnd, CString szSection, CString szKey);


	CWinHcsStatusDoc	*GetHcsStatusDoc(void);
	void				ReceivedLogData(long size);
	virtual BOOL		OnIdle(LONG lCount);
	CWinHcsView *		GetHcsInvokableMacrosView(void);

	CWinHcsApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinHcsApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation
	COleTemplateServer m_serverDoc;
	COleTemplateServer m_serverMacroDoc;
	COleTemplateServer m_serverHcsStatus;

	// Server object for document creation
	//{{AFX_MSG(CWinHcsApp)
	afx_msg void OnAppAbout();
	afx_msg void OnViewConfiguration();
	afx_msg void OnViewHcsstatus();
	afx_msg void OnCommandsConnect();
	afx_msg void OnCommandsNetwork();
	afx_msg void OnCommandsReset();
	afx_msg void OnCommandsSetadc();
	afx_msg void OnCommandsSetdac();
	afx_msg void OnCommandsSetinput();
	afx_msg void OnCommandsSetnetbit();
	afx_msg void OnCommandsSetoutput();
	afx_msg void OnCommandsSettime();
	afx_msg void OnCommandsSetx10();
	afx_msg void OnCommandsVariable();
	afx_msg void OnCommandsVoice();
	afx_msg void OnCommandsGetvariable();
	afx_msg void OnCommandsRefreshall();
	afx_msg void OnCommandsLogdataClear();
	afx_msg void OnCommandsLogdataLogdata();
	afx_msg void OnCommandsLogdataSave();
	afx_msg void OnCommandsLogdataSize();
	afx_msg void OnCommandsLogdataStorelogbuffer();
	afx_msg void OnViewOutput();
	afx_msg void OnClearOutput();
	afx_msg void OnUpdateCommandsConnect(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewOutput(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCommandsMenu(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCommandsLogStore(CCmdUI* pCmdUI);
	afx_msg void OnCommandsLogdataGet();
	afx_msg void OnViewLog();
	afx_msg void OnToolsXpressbintosource();
	afx_msg void OnFileNew();
	afx_msg void OnToolsNewmacromodule();
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()


	// Generated OLE dispatch map functions
	//{{AFX_DISPATCH(CWinHcsApp)
	afx_msg BOOL AutomationMaximize();
	afx_msg BOOL AutomationMinimize();
	afx_msg BOOL AutomationRestore();
	afx_msg BOOL AutomationQuit();
	afx_msg BOOL AutomationSaveAll();
	afx_msg void AutomationCloseAll();
	afx_msg VARIANT AutomationGetHcsDoc();
	afx_msg BOOL AutomationGetVisible();
	afx_msg void AutomationSetVisible(BOOL bNewValue);
	afx_msg void AutomationWriteToOutput(LPCTSTR string);
	afx_msg void AutomationClearOutput();
	afx_msg BOOL AutomationGetOutputVisible();
	afx_msg void AutomationSetOutputVisible(BOOL bNewValue);
	afx_msg VARIANT AutomationGetXPressDocs(const VARIANT FAR& item);
	afx_msg VARIANT AutomationGetMacroDocs(const VARIANT FAR& item);
	public:
	afx_msg VARIANT AutomationOpenDocument(LPCTSTR filename);
	afx_msg void AutomationArrange();
	afx_msg void AutomationCascade();
	afx_msg void AutomationTileHorz();
	afx_msg void AutomationTileVert();
	//}}AFX_DISPATCH

	DECLARE_DISPATCH_MAP()


private:
	void ShowTipAtStartup(void);
	void ShowTipOfTheDay(void);

	CWinHcsStatusDoc	*m_pHcsStatusDoc;

	BOOL				m_storeLogData;
	BOOL				m_saveLogData;
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINHCS_H__BF7696E9_4DAC_11D3_B89C_0000861E056C__INCLUDED_)
