/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */



// TO DO List:
//
//	- General
//		* Clear output window menu choice
//		* Save and restore WinHcs position between sessions
//	- Configuration
//		* Auto connect to HCS and auto open of HCS monitoring view
//		- Push button to install database ODBC Data source
//		- Tips should work even if initial start directory is not the one
//			where WinHcs.exe is located. Use registry?
//	- HCS Document & View
//		* When sending a command change color in view until receive reply
//		* Save and restore view position between sessions
//		* Save and restore variable list between sessions
//		* RS232 Receive and Send displays
//	- XPRESS and Macro Editor Documents & Views
//		- Keyword Highlight:
//			- Automatic feature disabled for now (algorithm needs improvements).
//			- Automatic configuration settings: normal color, keywords color,
//				comments color, TAB settings
//			- Formatting toolbar similar to Wordpad?
//	- Log data table and chart dialog:
//		* Setup clean empty Access database for delivery
//	- Macro properties and methods
//		* Query log data database command.
//	- TCP server:
//		- CGI scripts & Java applets
//	- Help ; needs more work:
//		- Documentation
//	- Demo files:
//		- XPRESS files
//			* Basic xpress program with launch a macro
//			- Example using Analog input calibration spreadheet and macros to:
//				- update upon user request the calibration data (add new values)
//				- calculate a formula based on the calibration values 
//				- take the above formula to update the XPRESS program
//				- compile and upload the new xpress program
//		- Macro Files:
//			* Macros from xpress:
//				- Add message to error log window
//				- Email message
//			* OLE automation object: Excel and Email
//



// Application Object Automation support:
//
//		Properties:
//			object.Visible			[Get/Set	; BOOL]
//			object.OutputVisible	[Get/Set	; BOOL]
//			object.HcsDocument		[Get		; object]
//
//		Methods:
//			BOOL-VAL =		object.Minimize
//			BOOL-VAL =		object.Maximize
//			BOOL-VAL =		object.Restore
//			BOOL-VAL =		object.Quit
//  		BOOL-VAL = 		object.SaveAll
// 							object.CloseAll()
//			Set Object =	object.Open(filename)
//							object.WriteToOutput(string)
//							object.ClearOutput
//							object.ArrangeIcons
//							object.Cascade
//							object.TileHorizontally
//							object.TileVertically
//  		Set object =	object.XPressDocuments {Collection of Xpress documents}
//  		Set object =	object.MacroDocuments  {Collection of HCS documents}
//				object.Count		[Get		; I2]
//				Set Object	= object.Open(filename)
//				Set Object	= object.Add(title)
//				Set Object	= object.Item(Index [I2] or name [BSTR])
//				Set Object	= _NewEnum;
//
// Document Object Automation support (XPress or Macro documents):
//
//		Properties:
//			object.Type				[Get/Set	; I4]
//			object.Application		[Get		; object]
//			object.Saved			[Get/Set	; BOOL]
//			object.Visible			[Get/Set	; BOOL]
//			object.Filename			[Get/Set	; BSTR]
//			object.Title			[Get/Set	; BSTR]
//			object.SelectionStart	[Get/Set	; I4]
//			object.SelectionEnd		[Get/Set	; I4]
//			object.LineCount		[Get		; I4]
//
//
//		Methods:
//			BOOL-VAL =		object.Minimize
//			BOOL-VAL =		object.Maximize
//			BOOL-VAL =		object.Restore
//							object.Activate
//							object.Close
//							object.Save
//							object.SaveAs(filename)
//			BOOL-VAL = 		object.DeleteContent
//			BOOL-VAL = 		object.Compile				{Only XPress documents}
//			BOOL-VAL = 		object.CompileAndDownload	{Only XPress documents}
//			BOOL-VAL = 		object.Find(findString, bCaseSensitive, bWholeWords)
//			BOOL-VAL = 		object.ReplaceSelection(newText)
//			I4-VAL =		object.LineIndex(line)
//			I4-VAL =		object.LineLength(line)
//							object.Clear
//							object.Cut
//							object.Paste
//							object.Undo
//							object.Redo
//							object.Print
//							object.Mail(To [BSTR], Subject [BSTR])
//			Set object =	object.OleObjects {Collection}
//				I4-Val		= object.OleObjects.Count
//				Set Object	= object.OleObjects.Item(Index [I2] or name [BSTR])
//				Set Object	= object.OleObjects.GetItemFullType(Index [I2] or name [BSTR])
//				Set Object	= object.OleObjects.GetItemShortType(Index [I2] or name [BSTR])
//				Set Object	= object.OleObjects.GetItemAppName(Index [I2] or name [BSTR])
//				Set Object	= _NewEnum;
//
//
// HCS Document Object Automation support:
//
//		Properties:
//			object.Application		[Get		; object]
//			object.Window			[Get		; object]
//			object.IsConnected		[Get/Set	; BOOL]
//			object.NbLogEntries		[Get		; I4]
//			object.hcsLogID			[Get		; I4]
//			object.hcsLogValue		[Get		; I4]
//			object.hcsLogYear		[Get		; I2]
//			object.hcsLogMonth		[Get		; I2]
//			object.hcsLogDay		[Get		; I2]
//			object.hcsLogHour		[Get		; I2]
//			object.hcsLogMinute		[Get		; I2]
//			object.hcsLogSecond		[Get		; I2]
//			object.newConsoleMsg	[Get/Set	; BOOL]
//			object.lastConsoleMsg	[Get		; BSTR]
//
//		Methods:
//							object.AddLogEntry(id [I2], value [I2])
//							object.ClearLogEntries
//			BOOL-VAL =		object.GetLogData
//			BOOL-VAL =		object.GetFirstLogEntry
//			BOOL-VAL =		object.GetNextLogEntry
//			BOOL-VAL =		object.GetFirstDBLogEntry(IDFrom [I4], IDTo [I4], DateFrom [BSTR], DateTo [BSTR]);
//			BOOL-VAL =		object.GetNextDBLogEntry
//							object.SetTime
//			DATE-VAL =		object.GetTime
//							object.Speak(TextToSpeak [BSTR])
//							object.SendToNetwork(cmd [BSTR])
//							object.SetDac(id [I2], value [I2])
//							object.SetADC(id [I2], transparent [BOOL], value [I2])
//							object.SetOutput(id [I2], value [BOOL])
//							object.SetInput(id [I2], transparent [BOOL], value [BOOL])
//							object.SetNetbit(id [I2], value [BOOL])
//							object.SetVariable(id [I2], value [2])
//							object.SetX10OnOrOff(HouseCodeAndModule [I2], OnState [BOOL])
//							object.SetX10DimOrBright(HouseCodeAndModule [I2], DimBrightSteps [i2])
//							object.SetX10AllOff(HouseCode [I2])
//							object.SetX10AllOn(HouseCode [I2])
//			I2-VAL =		object.GetADC(id [I2])
//			I2-VAL =		object.GetDAC(id [I2])
//			BOOL-VAL =		object.GetOutput(id [I2])
//			BOOL-VAL =		object.GetInput(id [I2])
//			BOOL-VAL =		object.GetNetbit(id [I2])
//			I2-VAL =		object.GetVariable(id [I2])
//			BOOL-VAL =		object.GetX10(HouseCodeAndModule [I2])
//							object.SetADCProperties(id [I2], used [BOOL], label [BSTR])
//							object.SetDACProperties(id [I2], used [BOOL], label [BSTR])
//							object.SetOutputProperties(id [I2], used [BOOL], label [BSTR])
//							object.SetInputProperties(id [I2], used [BOOL], label [BSTR])
//							object.SetNetbitProperties(id [I2], used [BOOL], label [BSTR])
//							object.SetVariableProperties(id [I2], used [BOOL], label [BSTR])
//							object.SetX10Properties(id [I2], used [BOOL], label [BSTR])
//							object.SetLogIDProperties(id [I2], used [BOOL], label [BSTR])
//							object.SetTimerProperties(id [I2], used [BOOL], label [BSTR])
//			BOOL-VAL =		object.IsADCInUse(id [I2])
//			BOOL-VAL =		object.IsDACInUse(id [I2])
//			BOOL-VAL =		object.IsOutputInUse(id [I2])
//			BOOL-VAL =		object.IsInputInUse(id [I2])
//			BOOL-VAL =		object.IsNetBitInUse(id [I2])
//			BOOL-VAL =		object.IsVariableInUse(id [I2])
//			BOOL-VAL =		object.IsX10InUse(id [I2])
//			BOOL-VAL =		object.IsLogIdInUse(id [I2])
//			BOOL-VAL =		object.IsTimerInUse(id [I2])
//			BSTR-VAL =		object.GetADCLabel(id [I2])
//			BSTR-VAL =		object.GetDACLabel(id [I2])
//			BSTR-VAL =		object.GetOutputLabel(id [I2])
//			BSTR-VAL =		object.GetInputLabel(id [I2])
//			BSTR-VAL =		object.GetNetbitLabel(id [I2])
//			BSTR-VAL =		object.GetVariableLabel(id [I2])
//			BSTR-VAL =		object.GetX10Label(id [I2])
//			BSTR-VAL =		object.GetLogIDLabel(id [I2])
//			BSTR-VAL =		object.GetTimerLabel(id [I2])
//							object.AddWindow()
//
//
// HCS View Object Automation support:
//
//		Properties:
//			object.Visible			[Get/Set	; BOOL]
//			object.NetbitView		[Get/Set	; I2]
//			object.X10View			[Get/Set	; I2]
//
//		Methods:
//			BOOL-VAL =		object.Minimize
//			BOOL-VAL =		object.Maximize
//			BOOL-VAL =		object.Restore
//							object.Update
//							object.ClearConsole
//							object.AddVariable(id [I2])
//							object.RemoveVariable(id [I2])
//							object.RemoveAllVariables
//

#include "stdafx.h"
#include "WinHcs.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "WinHcsDoc.h"
#include "WinHcsView.h"
#include <dos.h>
#include <direct.h>

#include "WinHcsStatusDoc.h"
#include "WinHcsStatusView.h"

#include "DlgIo.h"
#include "OptionSheet.h"
#include "LogSheet.h"
#include "HcsRecordset.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global Spin button accelerators

UDACCEL	GLB_Acc[] = { { 2, 1 }, { 4, 10 }, { 8, 100 }, { 12, 1000 } };


/////////////////////////////////////////////////////////////////////////////
// CWinHcsApp

BEGIN_MESSAGE_MAP(CWinHcsApp, CWinApp)
	ON_COMMAND(CG_IDS_TIPOFTHEDAY, ShowTipOfTheDay)
	//{{AFX_MSG_MAP(CWinHcsApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_VIEW_CONFIGURATION, OnViewConfiguration)
	ON_COMMAND(ID_VIEW_HCSSTATUS, OnViewHcsstatus)
	ON_COMMAND(ID_COMMANDS_CONNECT, OnCommandsConnect)
	ON_COMMAND(ID_COMMANDS_NETWORK, OnCommandsNetwork)
	ON_COMMAND(ID_COMMANDS_RESET, OnCommandsReset)
	ON_COMMAND(ID_COMMANDS_SETADC, OnCommandsSetadc)
	ON_COMMAND(ID_COMMANDS_SETDAC, OnCommandsSetdac)
	ON_COMMAND(ID_COMMANDS_SETINPUT, OnCommandsSetinput)
	ON_COMMAND(ID_COMMANDS_SETNETBIT, OnCommandsSetnetbit)
	ON_COMMAND(ID_COMMANDS_SETOUTPUT, OnCommandsSetoutput)
	ON_COMMAND(ID_COMMANDS_SETTIME, OnCommandsSettime)
	ON_COMMAND(ID_COMMANDS_SETX10, OnCommandsSetx10)
	ON_COMMAND(ID_COMMANDS_VARIABLE, OnCommandsVariable)
	ON_COMMAND(ID_COMMANDS_VOICE, OnCommandsVoice)
	ON_COMMAND(ID_COMMANDS_GETVARIABLE, OnCommandsGetvariable)
	ON_COMMAND(ID_COMMANDS_REFRESHALL, OnCommandsRefreshall)
	ON_COMMAND(ID_COMMANDS_LOGDATA_CLEAR, OnCommandsLogdataClear)
	ON_COMMAND(ID_COMMANDS_LOGDATA_LOGDATA, OnCommandsLogdataLogdata)
	ON_COMMAND(ID_COMMANDS_LOGDATA_SAVE, OnCommandsLogdataSave)
	ON_COMMAND(ID_COMMANDS_LOGDATA_SIZE, OnCommandsLogdataSize)
	ON_COMMAND(ID_COMMANDS_LOGDATA_STORE, OnCommandsLogdataStorelogbuffer)
	ON_COMMAND(ID_VIEW_OUTPUT, OnViewOutput)
	ON_COMMAND(ID_BUILD_CLEARERRORS, OnClearOutput)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_CONNECT, OnUpdateCommandsConnect)
	ON_UPDATE_COMMAND_UI(ID_VIEW_OUTPUT, OnUpdateViewOutput)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_GETVARIABLE, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_LOGDATA_STORE, OnUpdateCommandsLogStore)
	ON_COMMAND(ID_COMMANDS_LOGDATA_GET, OnCommandsLogdataGet)
	ON_COMMAND(ID_VIEW_LOG, OnViewLog)
	ON_COMMAND(ID_TOOLS_XPRESSBINTOSOURCE, OnToolsXpressbintosource)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_LOGDATA_CLEAR, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_LOGDATA_LOGDATA, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_LOGDATA_SAVE, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_LOGDATA_SIZE, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_NETWORK, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_REFRESHALL, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_RESET, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_SETADC, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_SETDAC, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_SETINPUT, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_SETNETBIT, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_SETOUTPUT, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_SETTIME, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_SETX10, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_VARIABLE, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_VOICE, OnUpdateCommandsMenu)
	ON_UPDATE_COMMAND_UI(ID_COMMANDS_LOGDATA_GET, OnUpdateCommandsMenu)
	ON_COMMAND(ID_TOOLS_NEWMACROMODULE, OnToolsNewmacromodule)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWinHcsApp construction

CWinHcsApp::CWinHcsApp()
{
	m_sndEnabled			= FALSE;
	m_bTCPConnectionChanged	= TRUE;
	m_TCPConnectionCounter	= 0;

	EnableAutomation();
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CWinHcsApp object

CWinHcsApp theApp;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.

// {8F8328C7-4DA9-11D3-B89C-0000861E056C}
static const CLSID clsidDoc =
{ 0x8f8328c7, 0x4da9, 0x11d3, { 0xb8, 0x9c, 0x0, 0x0, 0x86, 0x1e, 0x5, 0x6c } };
static const CLSID clsidMacro =
{ 0xbf7696e6, 0x4dac, 0x11d3, { 0xb8, 0x9c, 0x0, 0x0, 0x86, 0x1e, 0x5, 0x6c } };
static const CLSID clsidHcsStatus =
{ 0xbf76971b, 0x4dac, 0x11d3, { 0xb8, 0x9c, 0x0, 0x0, 0x86, 0x1e, 0x5, 0x6c } };

/////////////////////////////////////////////////////////////////////////////
// CWinHcsApp initialization

BOOL CWinHcsApp::InitInstance()
{
	long		i;
	char		*sP;

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Record initial directory
	sP = _getcwd(NULL, 128);
	m_startupDir = sP;
	free(sP);

	// Change the registry key under which our settings are stored.
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("HCS"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	m_xpressCompilerPath	= GetProfileCString(IDS_REG_XPRESS, IDS_REG_COMPILER, "compile.exe"	);
	m_xpressBin2SourcePath	= GetProfileCString(IDS_REG_XPRESS, IDS_REG_UNCOMPILER, NULL	);
	i						= GetProfileLong(   IDS_REG_XPRESS, IDS_REG_ADD_CFG, FALSE);
	if (i == 0)
		m_xpressAddHcsCfg	= FALSE;
	else
		m_xpressAddHcsCfg	= TRUE;


	m_MacroHcsMacroPath		= GetProfileCString(IDS_REG_MACRO, IDS_REG_HCS_MODULE, NULL);
	m_MacroTimeout			= GetProfileLong(	IDS_REG_MACRO, IDS_REG_TIMEOUT, 10000);


	i						= GetProfileLong(	IDS_REG_SOUNDS, IDS_REG_ENABLED, FALSE);
	if (i == 0)
		m_sndEnabled		= FALSE;
	else
		m_sndEnabled		= TRUE;
	m_sndSuccess			= GetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND1, NULL);
	m_sndFailure			= GetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND2, NULL);
	m_sndHcsConnect			= GetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND3, NULL);
	m_sndHcsError			= GetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND4, NULL);


	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.
	m_pDocTemplate = new CMultiDocTemplate(
		IDR_WINHCSTYPE,
		RUNTIME_CLASS(CWinHcsDoc),
		RUNTIME_CLASS(CMDIChildWnd), // custom MDI child frame
		RUNTIME_CLASS(CWinHcsView));
	m_pDocTemplate->SetContainerInfo(IDR_WINHCSTYPE_CNTR_IP);
	AddDocTemplate(m_pDocTemplate);

	m_pMacroTemplate = new CMultiDocTemplate(
		IDR_WINHCSMACTYPE,
		RUNTIME_CLASS(CWinHcsDoc),
		RUNTIME_CLASS(CMDIChildWnd), // custom MDI child frame
		RUNTIME_CLASS(CWinHcsView));
	m_pMacroTemplate->SetContainerInfo(IDR_WINHCSMACTYPE_CNTR_IP);
	AddDocTemplate(m_pMacroTemplate);

	m_pStatusTemplate = new CMultiDocTemplate(
		IDR_WINHCSSTATUSTYPE,
		RUNTIME_CLASS(CWinHcsStatusDoc),
		RUNTIME_CLASS(CMDIChildWnd), // custom MDI child frame
		RUNTIME_CLASS(CWinHcsStatusView));
	AddDocTemplate(m_pStatusTemplate);


	// Connect the COleTemplateServer to the document template.
	//  The COleTemplateServer creates new documents on behalf
	//  of requesting OLE containers by using information
	//  specified in the document template.
	m_serverDoc.ConnectTemplate(		clsidDoc,		m_pDocTemplate,		FALSE);
	m_serverMacroDoc.ConnectTemplate(	clsidMacro,		m_pMacroTemplate,	FALSE);
	m_serverHcsStatus.ConnectTemplate(	clsidHcsStatus, m_pStatusTemplate,	FALSE);


	// Register all OLE server factories as running.  This enables the
	//  OLE libraries to create objects from other applications.
	COleTemplateServer::RegisterAll();
		// Note: MDI applications register all server objects without regard
		//  to the /Embedding or /Automation on the command line.


	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;


	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();


	// Create the HCS status document
	m_pHcsStatusDoc = new CWinHcsStatusDoc();
	ASSERT( m_pHcsStatusDoc != NULL);
	m_pHcsStatusDoc->SetTitle(_T("HCS Status"));

	pMainFrame->SetHcsConnectionStatus( HcsStatusDisconnected );

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Check to see if launched as OLE server
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		// Application was run with /Embedding or /Automation.  Don't show the
		//  main window in this case.
		return TRUE;
	}

	// When a server application is launched stand-alone, it is a good idea
	//  to update the system registry in case it has been damaged.
	m_serverDoc.UpdateRegistry(OAT_DISPATCH_OBJECT);
	m_serverMacroDoc.UpdateRegistry(OAT_DISPATCH_OBJECT);
	m_serverHcsStatus.UpdateRegistry(OAT_DISPATCH_OBJECT);

	COleObjectFactory::UpdateRegistryAll();


	// Dispatch commands specified on the command line
	if (cmdInfo.m_nShellCommand != CCommandLineInfo::FileNew) {

		if (!ProcessShellCommand(cmdInfo))
			return FALSE;

	}	else  {

		long		n;
		CString		grp;
		CString		key;
		CString		str;
		BOOL		bVal1, bVal2;
		BOOL		bVal = FALSE;
		CWinHcsDoc	*pDoc;
		CWnd		*pWnd;

		n = 1;
		grp.LoadString(IDS_REG_XPRESS);

		do {

			key.Format("Xpress_%d", n);

			str = this->GetProfileString(grp, key, _T(""));
			bVal1 = str.IsEmpty();

			if (bVal1 == FALSE) {

				// Delete the key
				this->WriteProfileString(grp, key, NULL);

				if ((pDoc = (CWinHcsDoc *) m_pDocTemplate->OpenDocumentFile(str, TRUE)) != NULL) {

					pDoc->m_docType = TYPE_XPRESS;

					key.Format("XpressPos_%d", n);
					pWnd  = (pDoc->GetView())->GetParent();
					RestoreWindowPosition(pWnd, grp, key);

					// Delete the key
					this->WriteProfileString(grp, key, NULL);

					n++;
					bVal = TRUE;
				}
			}

		} while (bVal1 == FALSE);
		
		
		n = 1;
		grp.LoadString(IDS_REG_MACRO);

		do {

			key.Format("Macro_%d", n);

			str = this->GetProfileString(grp, key, _T(""));
			bVal2 = str.IsEmpty();

			if (bVal2 == FALSE) {

				// Delete the key
				this->WriteProfileString(grp, key, NULL);

				if ((pDoc = (CWinHcsDoc *) m_pMacroTemplate->OpenDocumentFile(str, TRUE)) != NULL) {

					pDoc->m_docType = TYPE_VBSCRIPT;

					key.Format("MacroPos_%d", n);
					pWnd  = (pDoc->GetView())->GetParent();
					RestoreWindowPosition(pWnd, grp, key);

					// Delete the key
					this->WriteProfileString(grp, key, NULL);

					n++;
					bVal = TRUE;
				}
			}

		} while (bVal2 == FALSE);

		if (bVal == FALSE)
			OnFileNew();
	}

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();


	// And auto connect to HCS and display window
	if (m_pHcsStatusDoc->m_AutoConnectAtStartup != FALSE)
		m_pHcsStatusDoc->OpenConnectionToHcs();

	if (m_pHcsStatusDoc->m_ShowViewAtStartup != FALSE)
		OnViewHcsstatus();

	// CG: This line inserted by 'Tip of the Day' component.
	ShowTipAtStartup();

	return TRUE;
}

int CWinHcsApp::ExitInstance() 
{
	SetProfileCString(	IDS_REG_XPRESS, IDS_REG_COMPILER,		m_xpressCompilerPath);
	SetProfileCString(	IDS_REG_XPRESS, IDS_REG_UNCOMPILER,		m_xpressBin2SourcePath);
	SetProfileLong(		IDS_REG_XPRESS, IDS_REG_ADD_CFG,		m_xpressAddHcsCfg);

	SetProfileCString(	IDS_REG_MACRO, IDS_REG_HCS_MODULE,		m_MacroHcsMacroPath);
	SetProfileLong(		IDS_REG_MACRO, IDS_REG_TIMEOUT,			m_MacroTimeout);

	SetProfileLong(		IDS_REG_SOUNDS, IDS_REG_ENABLED,		m_sndEnabled	);
	SetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND1,			m_sndSuccess	);
	SetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND2,			m_sndFailure	);
	SetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND3,			m_sndHcsConnect	);
	SetProfileCString(	IDS_REG_SOUNDS, IDS_REG_SOUND4,			m_sndHcsError	);


	(void) m_pHcsStatusDoc->CloseConnectionToHcs();
	delete m_pHcsStatusDoc;

	return CWinApp::ExitInstance();
}

long CWinHcsApp::GetProfileLong(unsigned int group, unsigned int entry, long def)
{
	CString	grp, key;
	long	ret;

	grp.LoadString(group);
	key.LoadString(entry);

	ret = GetProfileInt( grp, key, def);

	return ret;
}
BOOL CWinHcsApp::SetProfileLong(unsigned int group, unsigned int entry, long value)
{
	CString	grp, key;

	grp.LoadString(group);
	key.LoadString(entry);

	return WriteProfileInt( grp, key, value);
}


CString	CWinHcsApp::GetProfileCString(unsigned int group, unsigned int entry, LPCTSTR def)
{
	CString	grp, key, ret;

	grp.LoadString(group);
	key.LoadString(entry);

	ret = GetProfileString( grp, key, def);

	return ret;
}
BOOL CWinHcsApp::SetProfileCString(unsigned int group, unsigned int entry, CString value)
{
	CString	grp, key;

	grp.LoadString(group);
	key.LoadString(entry);

	return WriteProfileString( grp, key, value);
}





////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

// Very useful API that parses a LONG out of a string, updating
// the string pointer before it returns.
// 
static LONG WINAPI ParseOffNumber( LPSTR FAR *lplp, LPINT lpConv )
{
    LPSTR lp = *lplp;
    LONG  lValue=0;
    int   sign=1;

    while( isspace(*lp) )
        lp++;
    if( *lp=='-' )
    {               
        sign = -1;
        lp++;
    }
    if (*lp=='\0')
    {
        *lpConv = FALSE;
        return 0L;
    }

    // Is it a decimal number
    if( strnicmp( lp, (LPSTR)"0x",2) )
    {
        
        while( isdigit(*lp) )
        {
            lValue *= 10;
            lValue += (*lp - '0');
            lp++;
        }
    }    
    else
    {
        lp+=2;

        while( isxdigit(*lp) )
        {
            lValue *= 16;
            if( isdigit(*lp) )
                lValue += (*lp - '0');
            else
                lValue += (toupper(*lp) - 'A' + 10);
            lp++;
        }
    }
    while( isspace(*lp) )
        lp++;

    lValue *= (long)sign;

    if (*lp==',')
    {
        lp++;
        while( isspace(*lp) )
            lp++;
        *lplp = lp;
        if (lpConv)
            *lpConv = (int)TRUE;
    }
    else
    {
        *lplp = lp;
        if (lpConv)
            *lpConv = (int)(*lp=='\0');
    }
    return lValue;

} //*** ParseOffNumber


BOOL CWinHcsApp::SaveWindowPosition(CWnd* pWnd, unsigned int Section, unsigned int Key)
{
	CString			szSection;
	CString			szKey;

	szSection.LoadString(Section);
	szKey.LoadString(Key);

	return SaveWindowPosition(pWnd, szSection, szKey);
}

BOOL CWinHcsApp::SaveWindowPosition(CWnd* pWnd, CString szSection, CString szKey)
{   
    CString			szValue;
	WINDOWPLACEMENT wp;


    wp.length = sizeof( WINDOWPLACEMENT );
    pWnd->GetWindowPlacement( &wp );        
                                             
    LPSTR p = szValue.GetBuffer( 255 ) ;              
    wsprintf( p, "%d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d",
        wp.flags, wp.showCmd, wp.ptMinPosition.x, wp.ptMinPosition.y,
        wp.ptMaxPosition.x, wp.ptMaxPosition.y,
        wp.rcNormalPosition.left, wp.rcNormalPosition.top,
        wp.rcNormalPosition.right, wp.rcNormalPosition.bottom );
        
    szValue.ReleaseBuffer() ;
    AfxGetApp()->WriteProfileString(szSection, szKey, szValue);

    return TRUE ;
}


BOOL CWinHcsApp::RestoreWindowPosition(CWnd* pWnd, unsigned int Section, unsigned int Key)
{   
	CString			szSection;
	CString			szKey;
    CString			sz;    
	
	szSection.LoadString(Section);
	szKey.LoadString(Key);

	return RestoreWindowPosition(pWnd, szSection, szKey);
}


BOOL CWinHcsApp::RestoreWindowPosition(CWnd* pWnd, CString szSection, CString szKey)
{   
    CString			sz;    
    WINDOWPLACEMENT wp;
    int				nConv;
	
    wp.length = sizeof( WINDOWPLACEMENT );
    sz = AfxGetApp()->GetProfileString(szSection, szKey, "" );
    
    if (sz.IsEmpty())
        return FALSE;

    LPSTR   lp = (LPSTR)sz.GetBuffer( 255 );

    wp.flags = (WORD)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;
    
    wp.showCmd = (WORD)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
//    if (!pWnd->IsWindowVisible())
//        wp.showCmd = SW_HIDE ;
        
    if (!nConv)
        return FALSE;

    wp.ptMinPosition.x = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    wp.ptMinPosition.y = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    wp.ptMaxPosition.x = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    wp.ptMaxPosition.y = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    wp.rcNormalPosition.left = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    wp.rcNormalPosition.top = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    wp.rcNormalPosition.right = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    wp.rcNormalPosition.bottom = (int)ParseOffNumber( (LPSTR FAR *)&lp, &nConv );
    if (!nConv)
        return FALSE;

    pWnd->SetWindowPlacement( &wp ) ;

    return TRUE ;
}


///////////////////////////////////////////////////////


CWinHcsStatusDoc * CWinHcsApp::GetHcsStatusDoc(void)
{
	return m_pHcsStatusDoc;
}


BOOL CWinHcsApp::OnIdle(LONG lCount)
{
	// CG: The following code inserted by 'Idle Time Processing' component.

	// Note: Do not perform lengthy tasks during OnIdle because your
	// application cannot process user input until OnIdle returns.

	// call the base class
	BOOL bBaseIdle = CWinApp::OnIdle(lCount);
	BOOL bMoreIdle = TRUE;


	if (lCount == 0)
	{
		// TODO: add code to perform important idle time processing
	}
	else if (lCount == 100)
	{
		CMainFrame* pFrame		= (CMainFrame*) AfxGetMainWnd();
		CStatusBar* pStatusBar	= (CStatusBar*) pFrame->GetDescendantWindow(AFX_IDW_STATUS_BAR);

		if(pStatusBar)	{

			CMDIChildWnd	*pChild = (CMDIChildWnd *) pFrame->GetActiveFrame();
			CWinHcsView		*pView  = (CWinHcsView *) pChild->GetActiveView();
			CString			str;

			if (pView && pView->IsKindOf(RUNTIME_CLASS(CWinHcsView)) != 0) {

				CRichEditCtrl	&pCtrl = pView->GetRichEditCtrl();
				UINT			i = pCtrl.LineFromChar(-1) + 1;
				long			s, c;

				pCtrl.GetSel(s, c);
				c	= s - pCtrl.LineIndex(-1) + 1;

				str.Format(_T("Ln %u, Col %u"), i, c);

			} else {

				str.Format(_T(""));
			}

			pStatusBar->SetPaneText(4, str);

			if (m_bTCPConnectionChanged == TRUE) {

				m_bTCPConnectionChanged = FALSE;

				str.Format(_T("TCP: %d"), m_TCPConnectionCounter);
				pStatusBar->SetPaneText(1, str);
			}
		}
	}
	else if (lCount == 1000)
	{
		// Process HCS Commands queued up
		if (m_pHcsStatusDoc->m_HcsCommands.IsEmpty() == FALSE) {

			CWinHcsView		*pView;
			CString			exec;
			long			sz;

			// Get Macro to execute
			exec  = m_pHcsStatusDoc->m_HcsCommands.RemoveHead();
			pView = GetHcsInvokableMacrosView();

			// And run macro if document is available
			if (pView != NULL) {

				sz = exec.GetLength();
				pView->RunMacro( exec.GetBuffer(sz) );

			} else {

				CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();
				CString		msg;

				msg.Format(IDS_ERR_SCRIPT_HCS, exec);

				pFrame->DlgBarAddMessage(msg.GetBuffer(80));
				pFrame->DlgBarShow();
			}
		}

		bMoreIdle = bBaseIdle;
	}

	// return FALSE when there is no more idle processing to do
	return bMoreIdle;
}



CWinHcsView * CWinHcsApp::GetHcsInvokableMacrosView(void)
{
	CWinHcsDoc		*pDoc = NULL;
	CWinHcsView		*pView = NULL;
	POSITION		pos;
	CString			pathname;
	BOOL			bFound = FALSE;

	// Search for the selected macro document
	pos = m_pMacroTemplate->GetFirstDocPosition();

	while (pos != NULL && bFound == FALSE) {

		pDoc = (CWinHcsDoc *) m_pMacroTemplate->GetNextDoc(pos);
		pathname   = pDoc->GetPathName();

		if (pathname == m_MacroHcsMacroPath)
			bFound = TRUE;
	}

	// If not yet loaded, create it
	if (bFound == FALSE) {
		if ((pDoc = (CWinHcsDoc *) m_pMacroTemplate->OpenDocumentFile(m_MacroHcsMacroPath, TRUE)) != NULL)
			pDoc->m_docType = TYPE_VBSCRIPT;
	}

	// And run macro if document is available
	if (pDoc != NULL)
		pView = (CWinHcsView *) pDoc->GetView();


	return pView;
}



/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL
// Implementation
protected:
	virtual BOOL OnInitDialog();
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CAboutDlg::OnInitDialog()
{
	char	*pLicense1 = _T("/* ====================================================================\r\n\
 *\r\n\
 * WinHcs\r\n\
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.\r\n\
 *\r\n\
 *	The WinHcs software is OSI Certified Open Source Software.\r\n\
 *	OSI Certified is a certification mark of the Open Source Initiative.\r\n\
 *\r\n\
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.\r\n\
 *\r\n\
 *\r\n\
 *\r\n\
 * Redistribution and use in source and binary forms, with or without\r\n\
 * modification, are permitted provided that the following conditions\r\n\
 * are met:\r\n\
 *\r\n\
 * 1. Redistributions of source code must retain the above copyright\r\n\
 *    notice, this list of conditions and the following disclaimer. \r\n\
 *\r\n\
 * 2. Redistributions in binary form must reproduce the above copyright\r\n\
 *    notice, this list of conditions and the following disclaimer in\r\n\
 *    the documentation and/or other materials provided with the\r\n\
 *    distribution.\r\n\
 *\r\n\
 * 3. All advertising materials mentioning features or use of this\r\n\
 *    software must display the following acknowledgment:\r\n\
 *    \"This product includes software developed by Philippe Printz\r\n\
 *    for use in the HCS project.\"\r\n");

	char	*pLicense2 = _T(" *\r\n\
 * 4. The names \"WinHcs\" and \"HCS\" must not be used to\r\n\
 *    endorse or promote products derived from this software without\r\n\
 *    prior written permission.\r\n\
 *\r\n\
 * 5. Products derived from this software may not be called \"WinHcs\"\r\n\
 *    nor may \"WinHcs\" appear in their names without prior written\r\n\
 *    permission of the WinHcs.\r\n\
 *\r\n\
 * 6. Redistributions of any form whatsoever must retain the following\r\n\
 *    acknowledgment:\r\n\
 *    \"This product includes software developed by Philippe Printz\r\n\
 *    for use in the HCS project.\"\r\n\
 *\r\n\
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY\r\n\
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\r\n\
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\r\n\
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR\r\n\
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\r\n\
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\r\n\
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\r\n\
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\r\n\
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,\r\n\
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\r\n\
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED\r\n\
 * OF THE POSSIBILITY OF SUCH DAMAGE.\r\n\
 * ====================================================================\r\n\
 *\r\n\
 * This software consists of voluntary contributions made by many\r\n\
 * individuals and was originally based on software written by\r\n\
 * Philippe C. Printz.\r\n\
 *\r\n */");

	CDialog::OnInitDialog();	// CG:  This was added by System Info Component.


	// Replace the editing edit buffer with the newly loaded data
#ifndef _UNICODE
	DWORD	dwVersion = ::GetVersion();
	short	nWinVer = (LOBYTE(dwVersion) << 8) + HIBYTE(dwVersion);
	BOOL	bWin95 = (dwVersion & 0x80000000) != 0;

	if (bWin95)
	{
		CString strTmp(pLicense1);

		strTmp += pLicense2;

		SetDlgItemText(IDC_LICENSE, strTmp);
	} else
#endif

	{
		long	nLen = strlen(pLicense1) + strlen(pLicense2) + 1;
		CEdit	*pEdit = (CEdit *) GetDlgItem(IDC_LICENSE);
		LPVOID	hText = LocalAlloc(LMEM_MOVEABLE, (nLen + 1) * sizeof(TCHAR));

		if (hText == NULL)
			AfxThrowMemoryException();

		LPTSTR lpszText = (LPTSTR)LocalLock(hText);
		ASSERT(lpszText != NULL);

		sprintf(lpszText, "%s%s", pLicense1, pLicense2);
		lpszText[nLen] = '\0';

		LocalUnlock(hText);
		HLOCAL hOldText = pEdit->GetHandle();
		ASSERT(hOldText != NULL);
		LocalFree(hOldText);

		pEdit->SetHandle((HLOCAL)(UINT)(DWORD)hText);
		pEdit->Invalidate();
	}

	// CG: Following block was added by System Info Component.
	{
		CString strFreeDiskSpace;
		CString strFreeMemory;
		CString strFmt;

		// Fill available memory
		MEMORYSTATUS MemStat;
		MemStat.dwLength = sizeof(MEMORYSTATUS);
		GlobalMemoryStatus(&MemStat);
		strFmt.LoadString(CG_IDS_PHYSICAL_MEM);
		strFreeMemory.Format(strFmt, MemStat.dwTotalPhys / 1024L);

		SetDlgItemText(IDC_PHYSICAL_MEM, strFreeMemory);

		// Fill disk free information
		struct _diskfree_t diskfree;
		int nDrive = _getdrive(); // use current default drive
		if (_getdiskfree(nDrive, &diskfree) == 0)
		{
			strFmt.LoadString(CG_IDS_DISK_SPACE);
			strFreeDiskSpace.Format(strFmt,
				(DWORD)diskfree.avail_clusters *
				(DWORD)diskfree.sectors_per_cluster *
				(DWORD)diskfree.bytes_per_sector / (DWORD)1024L,
				nDrive-1 + _T('A'));
		}
		else
			strFreeDiskSpace.LoadString(CG_IDS_DISK_SPACE_UNAVAIL);

		SetDlgItemText(IDC_DISK_SPACE, strFreeDiskSpace);
	}

	return TRUE;	// CG:  This was added by System Info Component.

}



/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////////////
// CWinHcsApp message handlers

void CWinHcsApp::OnFileNew() 
{
	CWinHcsDoc *pDoc = (CWinHcsDoc *) m_pDocTemplate->OpenDocumentFile(NULL);
	pDoc->m_docType = TYPE_XPRESS;
}


void CWinHcsApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}



void CWinHcsApp::ShowTipAtStartup(void)
{
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	if (cmdInfo.m_bShowSplash)
	{
		CTipDlg dlg;
		if (dlg.m_bStartup)
			dlg.DoModal();
	}

}

void CWinHcsApp::ShowTipOfTheDay(void)
{
	CTipDlg dlg;
	dlg.DoModal();
}


////////////////////////////////////////
//	View menu
//
void CWinHcsApp::OnViewOutput() 
{
	CMainFrame*		pFrame		= (CMainFrame*) AfxGetMainWnd();

	if (pFrame->DlgBarIsVisible() == TRUE)
		pFrame->DlgBarHide();
	else
		pFrame->DlgBarShow();
}

void CWinHcsApp::OnClearOutput() 
{
	CMainFrame*		pFrame		= (CMainFrame*) AfxGetMainWnd();

	pFrame->DlgBarClear();
}


void CWinHcsApp::OnUpdateViewOutput(CCmdUI* pCmdUI) 
{
	CMainFrame*		pFrame	= (CMainFrame*) AfxGetMainWnd();
	int				n = 0;

	if (pFrame->DlgBarIsVisible() == TRUE)
		n = 1;

	pCmdUI->SetCheck(n);
}





void CWinHcsApp::OnViewConfiguration() 
{
	CMainFrame			*pFrame = (CMainFrame*) AfxGetMainWnd();
	COptionSheet		optionDlg(IDS_OPTIONS, pFrame, 0);
	CMiscCfgPage		miscCfgPage;
	CHcsCfgPage			hcsCfgPage;
	CLogCfgPage			logCfgPage;
	CXpressCfgPage		xpressCfgPage;

	optionDlg.AddPage( &miscCfgPage );
	optionDlg.AddPage( &hcsCfgPage );
	optionDlg.AddPage( &logCfgPage );
	optionDlg.AddPage( &xpressCfgPage );

	if (optionDlg.DoModal() == IDOK) {

	}
}


void CWinHcsApp::OnViewHcsstatus() 
{
	POSITION			pos;
	CFrameWnd	 		*pFrame = NULL;
	
	// Does a view already exist ?
	if ((pos = m_pHcsStatusDoc->GetFirstViewPosition()) != NULL)
		return;

	// If not create it
	pFrame = m_pStatusTemplate->CreateNewFrame(m_pHcsStatusDoc, NULL);

	if (pFrame != NULL)  {

//		pFrame->ShowWindow(TRUE);
		m_pStatusTemplate->InitialUpdateFrame(pFrame, m_pHcsStatusDoc);
	}
}



void CWinHcsApp::OnViewLog() 
{
	CMainFrame		*pFrame = (CMainFrame*) AfxGetMainWnd();

	CLogSheet		logDlg(IDS_LOG, pFrame, 0);
	CLogTablePage	TablePage;
	CLogChartPage	ChartPage;

	logDlg.AddPage( &TablePage );
	logDlg.AddPage( &ChartPage );

	if (logDlg.DoModal() == IDOK) {

	}	
}


////////////////////////////////////////
//	Commands menu
//
void CWinHcsApp::OnCommandsConnect() 
{
	CMainFrame		*pFrame = (CMainFrame*) AfxGetMainWnd();
	CWaitCursor		waiter;
	BOOL			fRet;

	if (m_pHcsStatusDoc->IsConnectedToHcs()) {

		fRet = m_pHcsStatusDoc->CloseConnectionToHcs();
		waiter.Restore();

		if (fRet == FALSE)
			AfxMessageBox(IDS_ERR_HCS_DISCONNECT, MB_OK, 0);

	} else {

		fRet = m_pHcsStatusDoc->OpenConnectionToHcs();
		waiter.Restore();

		if (fRet == FALSE)
			AfxMessageBox(IDS_ERR_HCS_DISCONNECT, MB_OK, 0);
	}
}



void CWinHcsApp::OnCommandsReset() 
{
	if (IDYES == AfxMessageBox(IDS_MSG_RESET_HCS, MB_YESNO, 0))
	{
		m_pHcsStatusDoc->SendMessageToHcs("!\x00", 2);
		m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	}
}


void CWinHcsApp::OnCommandsRefreshall() 
{
	m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	m_pHcsStatusDoc->SendMessageToHcs("!\x08", 2);
}


void CWinHcsApp::OnCommandsSettime() 
{
	m_pHcsStatusDoc->SetHcsTime();
}




void CWinHcsApp::OnCommandsSetadc() 
{
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsADCs();
	CDlgIoAnalog	dlg;
	unsigned short	v;
	char			cmd[8];

	dlg.m_pIo = pIO;
	dlg.m_IoPrompt = _T("HCS ADC:");
	dlg.m_disableTransparent = FALSE;
	dlg.m_min = 0;
	dlg.m_max = 4095;

	strcpy(dlg.m_Title, "Set HCS ADC");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0) {

		pIO->SetBeingChanged(dlg.m_IoSelectedId);

		if (dlg.m_IoValueTransparent == TRUE)
			v = 4096;
		else
			v = (unsigned short) dlg.m_IoValue;

		cmd[0] = '!';
		cmd[1] = 0x1b;
		cmd[2] = (char) dlg.m_IoSelectedId;
		*((unsigned short *) &cmd[3]) = v;

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 5);
		m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	}	
}


void CWinHcsApp::OnCommandsSetdac() 
{
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsDACs();
	CDlgIoAnalog	dlg;
	char			cmd[8];

	dlg.m_pIo = pIO;
	dlg.m_IoPrompt = _T("HCS DAC:");
	dlg.m_disableTransparent = TRUE;
	dlg.m_min = 0;
	dlg.m_max = 4095;

	strcpy(dlg.m_Title, "Set HCS DAC");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0) {

		pIO->SetBeingChanged(dlg.m_IoSelectedId);

		cmd[0] = '!';
		cmd[1] = 0x1e;
		cmd[2] = (char) dlg.m_IoSelectedId;
		*((unsigned short *) &cmd[3]) = (unsigned short) dlg.m_IoValue;

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 5);
		m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	}	
}


void CWinHcsApp::OnCommandsSetoutput() 
{
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsOutputs();
	CDlgIoDigital	dlg;
	char			cmd[8];

	dlg.m_pIo = pIO;
	dlg.m_disableTransparent = TRUE;

	strcpy(dlg.m_Title, "Set HCS Outputs");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0) {

		pIO->SetBeingChanged(dlg.m_IoSelectedId);

		cmd[0] = '!';
		cmd[1] = 0x18;
		cmd[2] = (char) dlg.m_IoSelectedId;
		cmd[3] = (char) dlg.m_IoValue;

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 4);
		m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	}
}

void CWinHcsApp::OnCommandsSetinput() 
{
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsInputs();
	CDlgIoDigital	dlg;
	char			cmd[8];

	dlg.m_pIo = pIO;
	dlg.m_disableTransparent = FALSE;

	strcpy(dlg.m_Title, "Set HCS Inputs");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0) {

		pIO->SetBeingChanged(dlg.m_IoSelectedId);

		cmd[0] = '!';
		cmd[1] = 0x15;
		cmd[2] = (char) dlg.m_IoSelectedId;
		cmd[3] = (char) dlg.m_IoValue;

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 4);
		m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	}
}

void CWinHcsApp::OnCommandsSetnetbit() 
{
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsNetbits();
	CDlgIoDigital	dlg;
	unsigned short	v;
	char			cmd[8];

	dlg.m_pIo = pIO;
	dlg.m_disableTransparent = TRUE;

	strcpy(dlg.m_Title, "Set HCS Netbits");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0) {

		pIO->SetBeingChanged(dlg.m_IoSelectedId);

		v = (unsigned short) dlg.m_IoSelectedId;
		cmd[0] = '!';
		cmd[1] = 0x23;
		*((unsigned short *) &cmd[2]) = v;
		cmd[4] = (char) dlg.m_IoValue;

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 5);
		m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	}
}



void CWinHcsApp::OnCommandsSetx10() 
{
	CDlgIoX10		dlg;
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsX10();
	char			cmd[8];

	dlg.m_pIo		= pIO;

	if (dlg.DoModal() == IDOK) {

		pIO->SetBeingChanged(dlg.m_IoSelectedId);

		cmd[0] = '!';
		cmd[1] = 0x12;
		cmd[2] = (char) dlg.m_IoSelectedId;
		cmd[3] = (char) dlg.m_Operation;

		if (dlg.m_Operation == 4 && dlg.m_Brightness > 0)
			cmd[3] = 5;

		cmd[4] = (char) abs(dlg.m_Brightness);

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 5);
		m_pHcsStatusDoc->SendMessageToHcs("!\x02", 2);
	}	
}




void CWinHcsApp::OnCommandsVariable() 
{
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsVariables();
	CDlgIoAnalog	dlg;
	char			cmd[8];

	dlg.m_pIo = pIO;
	dlg.m_IoPrompt = _T("HCS Variable:");
	dlg.m_disableTransparent = TRUE;
	dlg.m_min = UD_MINVAL;
	dlg.m_max = UD_MAXVAL;

	strcpy(dlg.m_Title, "Set Variable");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0) {

		pIO->SetBeingChanged(dlg.m_IoSelectedId);

		cmd[0] = '!';
		cmd[1] = 0x25;
		cmd[2] = (char) dlg.m_IoSelectedId;
		*((short *) &cmd[3]) = (short) dlg.m_IoValue;

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 5);

		cmd[0] = '!';
		cmd[1] = 0x24;
		cmd[2] = (char) dlg.m_IoSelectedId;

		m_pHcsStatusDoc->SendMessageToHcs(cmd, 3);
	}
}


void CWinHcsApp::OnCommandsGetvariable() 
{
	CHcsIo				*pIO = m_pHcsStatusDoc->GetHcsVariables();
	CWinHcsStatusView	*pView;
	POSITION			pos;
	CDlgGetVariable		dlg;

	dlg.m_pIo = pIO;
	dlg.m_IoPrompt = _T("HCS Variable:");

	strcpy(dlg.m_Title, "Variable to Display");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0) {

		pos = m_pHcsStatusDoc->GetFirstViewPosition();

		while (pos != NULL) {

			pView = (CWinHcsStatusView *) m_pHcsStatusDoc->GetNextView(pos);
			pView->AddVariableDisplay((short) dlg.m_IoSelectedId);
		}   
	}
}



/////////////////////////
//
void CWinHcsApp::OnCommandsVoice() 
{
	CDlgIoVoice		dlg;

	dlg.DoModal();
}



void CWinHcsApp::OnCommandsNetwork() 
{
	CDlgIoNetwork	dlg;

	dlg.DoModal();
}



/////////////////////////
//	Log Data

void CWinHcsApp::OnCommandsLogdataClear() 
{
	if (IDYES == AfxMessageBox(
			_T("Do you really want to reset\nthe logdata?"),
			MB_YESNO,
			0))
	{
		m_pHcsStatusDoc->ClearLogEntries();
	}
}


void CWinHcsApp::OnCommandsLogdataSize() 
{
	m_pHcsStatusDoc->QueryLogSize();
}


void CWinHcsApp::OnCommandsLogdataLogdata() 
{
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsLogIDs();
	CDlgIoAnalog	dlg;

	dlg.m_pIo					= pIO;
	dlg.m_IoPrompt				= _T("HCS Log IDs:");
	dlg.m_disableTransparent	= TRUE;
	dlg.m_min					= UD_MINVAL;
	dlg.m_max					= UD_MAXVAL;

	strcpy(dlg.m_Title, "Add Log ID");

	if (dlg.DoModal() == IDOK && dlg.m_IoSelectedId >= 0)
		m_pHcsStatusDoc->AddLogEntry((short) dlg.m_IoSelectedId, (short) dlg.m_IoValue);
}

void CWinHcsApp::OnCommandsLogdataGet() 
{
	m_saveLogData  = FALSE;
	m_storeLogData = FALSE;
	m_pHcsStatusDoc->UploadLogData();
}

void CWinHcsApp::OnCommandsLogdataSave() 
{
	m_saveLogData  = TRUE;
	m_storeLogData = FALSE;
	m_pHcsStatusDoc->UploadLogData();
}


void CWinHcsApp::OnCommandsLogdataStorelogbuffer() 
{
	if (m_pHcsStatusDoc->m_OdbcEnable) {

		m_saveLogData  = FALSE;
		m_storeLogData = TRUE;
		m_pHcsStatusDoc->UploadLogData();
	}
}


void CWinHcsApp::ReceivedLogData(long size)
{
	long			freq;
	BOOL			autoDel = FALSE;
	BOOL			autoUpload = FALSE;
	CDatabase		db;
	CHcsRecordset	dbRec;
	CHcsIo			*pIO = m_pHcsStatusDoc->GetHcsLogIDs();
	BOOL			bVal;
	CTime			tm;
	long			id,	value;
	CString			key;
	CString			pPath, ext;
	CFile			logFile;
	char			*logDataP;
	long			logSz;

	// Save log data into binary file
	if (m_saveLogData == TRUE) {

		CFileDialog	dlg(FALSE,
				_T(".bin"),
				_T("LogData"), 
				OFN_HIDEREADONLY | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST | OFN_SHAREAWARE,
				_T("LogData Files (*.bin)|*.bin|LogData Export Files (*.txt)|*.txt|All Files|*.*||"),
				NULL);

		if (dlg.DoModal() == IDOK) {

			BeginWaitCursor();
			
			pPath = dlg.GetPathName();
			ext = pPath.Right(4);

			logFile.Open(pPath, CFile::modeCreate | CFile::modeWrite);

			// Either export as bin or comma separated file
			if (lstrcmpi(ext, _T(".bin")) == 0) {

				logSz = m_pHcsStatusDoc->GetUploadedLogData(&logDataP);
				logFile.Write(logDataP, size);

			} else {

				bVal = m_pHcsStatusDoc->GetFirstLogEntry(tm, &id, &value);

				while (bVal == TRUE) {

					key.Format("%u/%u/%u,%u:%u:%u,%d,%s,%d\n",
								tm.GetMonth(), tm.GetDay(), tm.GetYear(),
								tm.GetHour(), tm.GetMinute(), tm.GetSecond(),
								id, pIO->GetIoLabel(id), value);

					logSz = key.GetLength();
					logFile.Write(key.GetBuffer(logSz), logSz);

					// Get next record
					bVal = m_pHcsStatusDoc->GetNextLogEntry(tm, &id, &value);
				}
			}

			logFile.Close();

			EndWaitCursor();
		}

	}


	// Store log data into database
	if (m_storeLogData == TRUE && m_pHcsStatusDoc->m_OdbcEnable) {


		BeginWaitCursor();

		try {
			if (db.IsOpen() == FALSE)
				db.Open(m_pHcsStatusDoc->m_OdbcDSN.GetBuffer(80), FALSE, FALSE, _T("ODBC;"), TRUE);
		}
		catch(CDBException *pEx)
		{
			CString str( _T("Could not open database") );
			str += pEx->m_strError;

			EndWaitCursor();

			AfxMessageBox(str);
			pEx->Delete();

			return;
		}

		try {
			if (dbRec.IsOpen() == FALSE)
				dbRec.Open(AFX_DB_USE_DEFAULT_TYPE, m_pHcsStatusDoc->m_OdbcTable.GetBuffer(80), 0);
		}
		catch(CDBException *pEx)
		{
			CString str( _T("Could not open database table") );
			str += pEx->m_strError;

			db.Close();

			EndWaitCursor();

			AfxMessageBox(str);
			pEx->Delete();

			return;
		}

		// Scan through all log records
		bVal = m_pHcsStatusDoc->GetFirstLogEntry(tm, &id, &value);

		while (bVal == TRUE) {

			key.Format("%u%u%u.%u%u%u.%d.%d",
						tm.GetMonth(), tm.GetDay(), tm.GetYear(),
						tm.GetHour(), tm.GetMinute(), tm.GetSecond(),
						id, value);

			// Not using CTime for the database record due to a bug
			// that appeared in the data excahnge routine.
			try
			{
				dbRec.AddNew();
				dbRec.m_KeyField				= key;
				dbRec.m_EventDateTime.year		= tm.GetYear();
				dbRec.m_EventDateTime.month		= tm.GetMonth();
				dbRec.m_EventDateTime.day		= tm.GetDay();
				dbRec.m_EventDateTime.hour		= tm.GetHour();
				dbRec.m_EventDateTime.minute	= tm.GetMinute();
				dbRec.m_EventDateTime.second	= tm.GetSecond();
				dbRec.m_EventDateTime.fraction	= 0;
				dbRec.m_EventID					= id;
				dbRec.m_EventName				= pIO->GetIoLabel(id);
				dbRec.m_EventValue				= value;
				dbRec.Update();
			}
			catch(CDBException *pEx)
			{
				pEx->Delete();
			}

			// Get next record
			bVal = m_pHcsStatusDoc->GetNextLogEntry(tm, &id, &value);
		}

		dbRec.Close();
		db.Close();

		EndWaitCursor();
	}


	// Check if we need to auto delete the log data on the HCS
	m_pHcsStatusDoc->GetLogUpdateSettings(&freq, &autoUpload, &autoDel);

	if (autoDel == TRUE) {

		m_pHcsStatusDoc->SendMessageToHcs("!\x07", 2);
		m_pHcsStatusDoc->SendMessageToHcs("!\x08", 2);
	}
}


void CWinHcsApp::OnToolsXpressbintosource() 
{
	CWinHcsApp				*pApp = (CWinHcsApp *) AfxGetApp();
	char					*cmdP = pApp->m_xpressBin2SourcePath.GetBuffer(256);
	STARTUPINFO				startupInfo;
	PROCESS_INFORMATION		processInformation;

	if (cmdP == NULL || *cmdP == 0) {

		AfxMessageBox(IDS_ERR_UNCOMPILER, MB_ICONHAND | MB_OK);
		return;
	}

	// and setup the process to run
	memset(&startupInfo,        0, sizeof(startupInfo));
	memset(&processInformation, 0, sizeof(processInformation));

	startupInfo.dwFlags		= STARTF_USESHOWWINDOW;
	startupInfo.wShowWindow	= SW_SHOW;

	(void) CreateProcess( 
			cmdP,				// pointer to name of executable module 
			NULL,				// pointer to command line string 
			NULL,				// pointer to process security attributes 
			NULL,				// pointer to thread security attributes 
			TRUE,				// handle inheritance flag 
			0,					// creation flags 
			NULL,				// pointer to new environment block 
			NULL,				// pointer to current directory name 
			&startupInfo,		// pointer to STARTUPINFO 
			&processInformation	// pointer to PROCESS_INFORMATION 
		); 

	if(!processInformation.hProcess) {

		AfxMessageBox(IDS_ERR_UNCOMPILER_LAUNCH, MB_ICONHAND | MB_OK);
		return;
	}
}

void CWinHcsApp::OnToolsNewmacromodule() 
{
	CWinHcsDoc *pDoc = (CWinHcsDoc *) m_pMacroTemplate->OpenDocumentFile(NULL);
	pDoc->m_docType = TYPE_VBSCRIPT;
}


/////////////////////////////
void CWinHcsApp::OnUpdateCommandsMenu(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_pHcsStatusDoc->IsConnectedToHcs() );
}

void CWinHcsApp::OnUpdateCommandsConnect(CCmdUI* pCmdUI) 
{
	CMainFrame*		pFrame	= (CMainFrame*) AfxGetMainWnd();
	int				n = 0;

	if (m_pHcsStatusDoc != NULL && m_pHcsStatusDoc->IsConnectedToHcs())
		n = 1;

	pCmdUI->SetCheck(n);
}

void CWinHcsApp::OnUpdateCommandsLogStore(CCmdUI* pCmdUI) 
{
	CMainFrame*		pFrame	= (CMainFrame*) AfxGetMainWnd();
	BOOL			bVal = FALSE;

	if (m_pHcsStatusDoc != NULL && m_pHcsStatusDoc->IsConnectedToHcs() && m_pHcsStatusDoc->m_OdbcEnable)
		bVal = TRUE;

	pCmdUI->Enable( bVal );
}





/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
//
//	Automation support
//
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////


BEGIN_DISPATCH_MAP(CWinHcsApp, CWinApp)
	//{{AFX_DISPATCH_MAP(CWinHcsDoc)
	DISP_PROPERTY_EX(CWinHcsApp, "HcsDocument", AutomationGetHcsDoc, SetNotSupported, VT_VARIANT)
	DISP_PROPERTY_EX(CWinHcsApp, "Visible", AutomationGetVisible, AutomationSetVisible, VT_BOOL)
	DISP_PROPERTY_EX(CWinHcsApp,"OutputVisible", AutomationGetOutputVisible, AutomationSetOutputVisible, VT_BOOL)
	DISP_FUNCTION(CWinHcsApp, "Maximize", AutomationMaximize, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "Minimize", AutomationMinimize, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "Restore", AutomationRestore, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "Quit", AutomationQuit, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "SaveAll", AutomationSaveAll, VT_BOOL, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "CloseAll", AutomationCloseAll, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "Open", AutomationOpenDocument, VT_VARIANT, VTS_BSTR)
	DISP_FUNCTION(CWinHcsApp, "WriteToOutput", AutomationWriteToOutput, VT_EMPTY, VTS_BSTR)
	DISP_FUNCTION(CWinHcsApp, "ClearOutput", AutomationClearOutput, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "XPressDocuments", AutomationGetXPressDocs, VT_VARIANT, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsApp, "MacroDocuments", AutomationGetMacroDocs, VT_VARIANT, VTS_VARIANT)
	DISP_FUNCTION(CWinHcsApp, "ArrangeIcons", AutomationArrange, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "Cascade", AutomationCascade, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "TileHorizontally", AutomationTileHorz, VT_EMPTY, VTS_NONE)
	DISP_FUNCTION(CWinHcsApp, "TileVertically", AutomationTileVert, VT_EMPTY, VTS_NONE)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

BOOL CWinHcsApp::AutomationMaximize() 
{
	ASSERT(m_pMainWnd != NULL);
	return m_pMainWnd->ShowWindow(SW_SHOWMAXIMIZED);
}
BOOL CWinHcsApp::AutomationMinimize() 
{
	ASSERT(m_pMainWnd != NULL);
	return m_pMainWnd->ShowWindow(SW_MINIMIZE);
}
BOOL CWinHcsApp::AutomationRestore() 
{
	ASSERT(m_pMainWnd != NULL);
	return m_pMainWnd->ShowWindow(SW_RESTORE);
}



BOOL CWinHcsApp::AutomationQuit() 
{
	ASSERT(m_pMainWnd != NULL);
	m_pMainWnd->SendMessage(WM_CLOSE);
	return TRUE;
}

BOOL CWinHcsApp::AutomationGetVisible() 
{
	ASSERT(m_pMainWnd != NULL);
	return m_pMainWnd->IsWindowVisible();
}

void CWinHcsApp::AutomationSetVisible(BOOL bNewValue) 
{
	ASSERT(m_pMainWnd != NULL);

	if (bNewValue == TRUE) {

		m_pMainWnd->ShowWindow(SW_SHOW);
		m_pMainWnd->UpdateWindow();

	} else {

		m_pMainWnd->ShowWindow(SW_HIDE);
	}
}


BOOL CWinHcsApp::AutomationSaveAll() 
{
	return SaveAllModified();
}

void CWinHcsApp::AutomationCloseAll() 
{
	m_pDocTemplate->CloseAllDocuments(FALSE);
	m_pMacroTemplate->CloseAllDocuments(FALSE);
}


void CWinHcsApp::AutomationArrange() 
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();
	pFrame->WindowArrangements(ID_WINDOW_ARRANGE);
}
void CWinHcsApp::AutomationCascade() 
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();
	pFrame->WindowArrangements(ID_WINDOW_CASCADE);
}
void CWinHcsApp::AutomationTileHorz() 
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();
	pFrame->WindowArrangements(ID_WINDOW_TILE_HORZ);
}
void CWinHcsApp::AutomationTileVert() 
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();
	pFrame->WindowArrangements(ID_WINDOW_TILE_VERT);
}



VARIANT CWinHcsApp::AutomationOpenDocument(LPCTSTR filename) 
{
	CMultiDocTemplate	*pTemplate;
	DocType				type = TYPE_UNDEFINED;
	BOOL				bFound = FALSE;
	CWinHcsDoc			*pDoc;
	POSITION			pos;
	CString				s1, s2;
	VARIANT				vaResult;
	CString				ext = CString(filename).Right(4);

	VariantInit(&vaResult);
	vaResult.vt		 = VT_DISPATCH;
	vaResult.punkVal = NULL;

	// Type selection
	if (lstrcmpi(ext, _T(".hcx")) == 0) {

		pTemplate	= m_pDocTemplate;
		type		= TYPE_XPRESS;

	} else {

		pTemplate	= m_pMacroTemplate;
		type		= TYPE_VBSCRIPT;
	}


	// Check if existing, otherwise create
	s1  = filename;
	pos = pTemplate->GetFirstDocPosition();

	while (pos != NULL && bFound == FALSE) {

		pDoc = (CWinHcsDoc *) pTemplate->GetNextDoc(pos);
		s2   = pDoc->GetPathName();

		if (s1 == s2)
			bFound = TRUE;
	}

	if (bFound == FALSE) {

		if ((pDoc = (CWinHcsDoc *) pTemplate->OpenDocumentFile(filename, TRUE)) == NULL)
			return vaResult;

		pDoc->m_docType = type;
	}

	// And now get dispatch
	vaResult.punkVal = pDoc->GetIDispatch(TRUE);
	return vaResult;
}


VARIANT CWinHcsApp::AutomationGetHcsDoc() 
{
	CWinHcsStatusDoc	*pHcs = GetHcsStatusDoc();
	VARIANT				vaResult;

	VariantInit(&vaResult);
	vaResult.vt		 = VT_DISPATCH;
	vaResult.punkVal = pHcs->GetIDispatch(TRUE);

	return vaResult;
}


VARIANT CWinHcsApp::AutomationGetXPressDocs(const VARIANT FAR& item) 
{
    VARIANT		va ;
	CWinHcsDocs	*pItems;

    VariantInit( &va ) ;
    va.vt = VT_DISPATCH ;

    pItems  = (CWinHcsDocs*) new CWinHcsDocs();
    ASSERT(pItems) ;

    if (pItems == NULL || !pItems->IsKindOf(RUNTIME_CLASS(CWinHcsDocs)))
    {
        va.pdispVal = NULL ;
    }
    else if (item.vt == VT_ERROR || item.vt == VT_EMPTY)
    {
		pItems->m_docType = TYPE_XPRESS;
        va.pdispVal  = pItems->GetIDispatch(FALSE) ;    
    }
    else
    {
		pItems->m_docType = TYPE_XPRESS;
        va.pdispVal  = pItems->AutomationGetItem( item ) ;

        delete pItems ;
    }
    return va;
}

VARIANT CWinHcsApp::AutomationGetMacroDocs(const VARIANT FAR& item) 
{
    VARIANT		va ;
	CWinHcsDocs	*pItems;

    VariantInit( &va ) ;
    va.vt	= VT_DISPATCH ;

    pItems  = (CWinHcsDocs*) new CWinHcsDocs();
    ASSERT(pItems) ;

    if (pItems == NULL || !pItems->IsKindOf(RUNTIME_CLASS(CWinHcsDocs)))
    {
        va.punkVal = NULL ;
    }
    else if (item.vt == VT_ERROR || item.vt == VT_EMPTY)
    {
		pItems->m_docType = TYPE_VBSCRIPT;
        va.punkVal  = pItems->GetIDispatch(FALSE) ;    
    }
    else
    {
		pItems->m_docType = TYPE_VBSCRIPT;
        va.pdispVal  = pItems->AutomationGetItem( item ) ;

        delete pItems ;
    }
    return va ;
}



void CWinHcsApp::AutomationWriteToOutput(LPCTSTR string)
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();

	pFrame->DlgBarAddMessage((char *) string);
}

void CWinHcsApp::AutomationClearOutput()
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();

	pFrame->DlgBarClear();
}

BOOL CWinHcsApp::AutomationGetOutputVisible() 
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();
	ASSERT(pFrame != NULL);

	return pFrame->DlgBarIsVisible();
}

void CWinHcsApp::AutomationSetOutputVisible(BOOL bNewValue) 
{
	CMainFrame	*pFrame	= (CMainFrame*) AfxGetMainWnd();
	ASSERT(pFrame != NULL);

	if (bNewValue == TRUE)
		pFrame->DlgBarShow();
	else
		pFrame->DlgBarHide();
}
