/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// RequestSocket.cpp : implementation file
//

#include "stdafx.h"
#include "winhcs.h"
#include "RequestSocket.h"
#include "HcsRecordset.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


long TCPConnectionCounter = 0;

/////////////////////////////////////////////////////////////////////////////
// CRequestSocket

CRequestSocket::CRequestSocket()
{
	m_inputBuf.SetSize( 1024 );
	m_outputBuf.SetSize( 1024 );
	m_ouputIdx	= 0;

	((CWinHcsApp *) AfxGetApp())->m_TCPConnectionCounter++;
	((CWinHcsApp *) AfxGetApp())->m_bTCPConnectionChanged = TRUE;
}

CRequestSocket::~CRequestSocket()
{
	((CWinHcsApp *) AfxGetApp())->m_TCPConnectionCounter--;
	((CWinHcsApp *) AfxGetApp())->m_bTCPConnectionChanged = TRUE;
}


// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CRequestSocket, CAsyncSocket)
	//{{AFX_MSG_MAP(CRequestSocket)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CRequestSocket member functions

BOOL CRequestSocket::ExtractCommandLine( const CByteArray& bytes, long nBytes, long & ndx )
{
	BOOL bLine = FALSE;

	while ( bLine == FALSE && ndx < nBytes ) {

		char ch = (char)(bytes.GetAt( ndx ));

		switch( ch ) {
		case '\r': 
//			break;
		case '\n': // end-of-line
			m_commandLine.TrimLeft();
			m_commandLine.TrimRight();
			bLine = TRUE;
			break;
		default:   // other....
			m_commandLine += ch;
			break;
		}
		++ndx;
	}
	return bLine;
}



BOOL CRequestSocket::SendData(CString& str)
{
	long	i, n;
	BYTE	*pData;

	n = str.GetLength() * sizeof(TCHAR);

	if (m_ouputIdx + n > m_outputBuf.GetSize() ) {

		i = (n / 1024 + 1 ) * 1024;
		i += m_ouputIdx;

		m_outputBuf.SetSize(i);
	}

	if ((pData = m_outputBuf.GetData()) == NULL)
		return FALSE;

	MoveMemory(pData + m_ouputIdx, (LPCSTR) str, n);
	m_ouputIdx += n;

	AsyncSelect(FD_READ | FD_WRITE | FD_CLOSE);

	return TRUE;
}




void CRequestSocket::OnReceive(int nErrorCode) 
{
	long nBytes = Receive( m_inputBuf.GetData(), m_inputBuf.GetSize() );
	long ndx	= 0;
	char *sP;

	if (nBytes == SOCKET_ERROR) {

		nBytes = GetLastError();

		ShutDown(both);
		return;
	}

	while( ExtractCommandLine( m_inputBuf, nBytes, ndx ) == TRUE ) {

		if ( !m_commandLine.IsEmpty() ) {

			CWinHcsStatusDoc	*pDoc = ((CWinHcsApp *) AfxGetApp())->GetHcsStatusDoc();
			CHcsIo				*pIO = NULL;
			CString				str;
			char				*ioP;
			long				sz;
			char				seps[]		= " ,\t\n\r";
			char				sepsSpaces[]= ",\t\n\r";


			sz = m_commandLine.GetLength();
			ioP = m_commandLine.GetBuffer(sz);
			ioP = strtok( ioP, seps );

			// Ensure we at least got the command keyword
			if (ioP != NULL ) {

				if (_stricmp(ioP, _T("LOGOUT")) == 0) {

					ShutDown(both);

				} else if (_stricmp(ioP, _T("CONSOLE")) == 0) {

					char			*sP;
					unsigned long	idx;

					while ( (sP = pDoc->GetLastConsoleMsg()) != NULL) {

						// replace CR anf LF with spaces
						for (idx = 0 ; idx < strlen(sP) ; idx++) {

							if (sP[idx] == 0x0A || sP[idx] == 0x0D)
								sP[idx] = ' ';
						}

						str.Format("CONSOLE,%s\n\r", sP);
						SendData(str);
					}

				} else if (_stricmp(ioP, _T("LOGSZ")) == 0) {

					long			value;
					char			*pData;

					// One line with number of entries
					value = pDoc->GetUploadedLogData(&pData);
					str.Format("LOGSZ,%d\n\r", value);
					SendData(str);

				} else if (_stricmp(ioP, _T("LOGDATA")) == 0) {

					BOOL			bVal;
					CTime			tm;
					long			id,	value;
					char			*pData;

					// One line with number of entries
					value = pDoc->GetUploadedLogData(&pData);
					str.Format("LOGSZ,%d\n\r", value);
					SendData(str);

					pIO = pDoc->GetHcsLogIDs();
					bVal = pDoc->GetFirstLogEntry(tm, &id, &value);

					// And all entries
					while (bVal == TRUE) {

						if ((sP = pIO->GetIoLabel(id)) == NULL)
							sP = "";

						str.Format("LOGDATA,%u/%u/%u,%u:%u:%u,%d,%s,%d\n\r",
									tm.GetMonth(), tm.GetDay(), tm.GetYear(),
									tm.GetHour(), tm.GetMinute(), tm.GetSecond(),
									id, sP, value);

						SendData(str);

						// Get next record
						bVal = pDoc->GetNextLogEntry(tm, &id, &value);
					}

				} else if (_stricmp(ioP, _T("LOGDATADB")) == 0) {


					long			selIDFrom	= -1;
					long			selIDTo		= -1;
					char			*pDateFrom	= NULL;
					char			*pDateTo	= NULL;
					char			*sP;
					CDatabase		db;
					CHcsRecordset	dbRec;
					CString			str1, str2;
					long			n = 0;


					if ((sP = strtok(NULL, seps)) != NULL && isdigit(*sP))
						selIDFrom = atol(sP);

					if ((sP = strtok(NULL, seps)) != NULL && isdigit(*sP))
						selIDTo = atol(sP);

					if ((sP = strtok(NULL, sepsSpaces)) != NULL) {
						pDateFrom = sP;
					}

					if ((sP = strtok(NULL, sepsSpaces)) != NULL) {
						pDateTo = sP;
					}

					while (pDateFrom != NULL && *pDateFrom != 0 && *pDateFrom == ' ')
						pDateFrom++;

					while (pDateTo != NULL && *pDateTo != 0 && *pDateTo  == ' ')
						pDateTo++;

					// Setup Filter mechanism
					if (selIDFrom >= 0) {

						if (selIDTo >= 0)
							str1.Format(_T("EventID >= %d AND EventID <= %d"), selIDFrom, selIDTo);
						else
							str1.Format(_T("EventID >= %d"), selIDFrom);

					} else if (selIDTo >= 0) {

						str1.Format(_T("EventID <= %d"), selIDTo);
					}


					if (pDateFrom == NULL || *pDateFrom == 0) {

						if (pDateTo != NULL && *pDateTo != 0)
							str2.Format(_T("EventDateTime <= #%s#"), pDateTo);

					} else {

						if (pDateTo == NULL || *pDateTo == 0)
							str2.Format(_T("EventDateTime >= #%s#"), pDateFrom);
						else
							str2.Format(_T("EventDateTime >= #%s# AND EventDateTime <= #%s#"), pDateFrom, pDateTo);
					}

					if (str1.IsEmpty() == TRUE) {

						if (str2.IsEmpty() == FALSE)
							dbRec.m_strFilter = str2;

					} else {

						if (str2.IsEmpty() == TRUE)
							dbRec.m_strFilter = str1;
						else
							dbRec.m_strFilter.Format(_T("%s AND %s"), str1, str2);
					}


					// Try opening the database
					try {
						if (db.IsOpen() == FALSE)
							db.Open(pDoc->m_OdbcDSN.GetBuffer(80), FALSE, FALSE, _T("ODBC;"), TRUE);
					}
					catch(CDBException *pEx)
					{
						CString str( _T("?LOGDATADB : Could not open database. ") );
						str += pEx->m_strError;

						SendData(str);
						pEx->Delete();

						m_commandLine.Empty();
						return;
					}

					// Open the recordset and fetch the items
					try {
						if (dbRec.IsOpen() == FALSE)
							dbRec.Open(AFX_DB_USE_DEFAULT_TYPE, pDoc->m_OdbcTable.GetBuffer(80), 0);
					}
					catch(CDBException *pEx)
					{
						CString str( _T("?LOGDATADB : Could not open database table. ") );
						str += pEx->m_strError;

						db.Close();

						SendData(str);
						pEx->Delete();

						m_commandLine.Empty();
						return;
					}

					// Bad way but API did not return count!
					n = 0;
					while ( !dbRec.IsEOF() ) {
						n++;
						dbRec.MoveNext();
					}
					str.Format("LOGDBSZ,%d\n\r", n);
					SendData(str);

					dbRec.MoveFirst();

					while ( !dbRec.IsEOF() ) {

						str.Format("LOGDATADB,%u/%u/%u,%u:%u:%u,%d,%s,%d\n\r",
							dbRec.m_EventDateTime.month,
							dbRec.m_EventDateTime.day,
							dbRec.m_EventDateTime.year,
							dbRec.m_EventDateTime.hour,
							dbRec.m_EventDateTime.minute,
							dbRec.m_EventDateTime.second,
							dbRec.m_EventID,
							dbRec.m_EventName,
							dbRec.m_EventValue);

						SendData(str);

						// Get next record
						dbRec.MoveNext();
					}
					db.Close();

				} else if (_stricmp(ioP, _T("TIME")) == 0) {

					str.Format("TIME,%s\n\r", pDoc->GetHcsTime());
					SendData(str);


				} else {	// Must be an I/O
				
					long		idx = 0, val;
					char		*nP;

					if ((nP = strtok(NULL, seps)) != NULL)
						idx = atol(nP);

					// Determine request and prepare for response
					if (_stricmp(ioP, _T("INPUT")) == 0)
						pIO = pDoc->GetHcsInputs();
					else if (_stricmp(ioP, _T("OUTPUT")) == 0)
						pIO = pDoc->GetHcsOutputs();
					else if (_stricmp(ioP, _T("NETBIT")) == 0)
						pIO = pDoc->GetHcsNetbits();
					else if (_stricmp(ioP, _T("ADC")) == 0)
						pIO = pDoc->GetHcsADCs();
					else if (_stricmp(ioP, _T("DAC")) == 0)
						pIO = pDoc->GetHcsDACs();
					else if (_stricmp(ioP, _T("VARIABLE")) == 0)
						pIO = pDoc->GetHcsVariables();
					else if (_stricmp(ioP, _T("X10")) == 0) {
						pIO = pDoc->GetHcsX10();

						// Determine i/o index as used in X10 notation
						idx = (unsigned short) ((toupper(nP[0]) - 'A') << 4);
						idx = idx | (unsigned short) ((atol(&nP[1]) - 1) & 0x0F);

					} else if (_stricmp(ioP, _T("PL-LINK")) == 0)
						pIO = pDoc->GetHcsPLs();
					else if (_stricmp(ioP, _T("MCIR-LINK")) == 0)
						pIO = pDoc->GetHcsMCIRs();
					else if (_stricmp(ioP, _T("LCD-LINK")) == 0)
						pIO = pDoc->GetHcsLCDs();
					else if (_stricmp(ioP, _T("DIO-LINK")) == 0)
						pIO = pDoc->GetHcsDIOs();
					else if (_stricmp(ioP, _T("ANSWERMAN-LINK")) == 0)
						pIO = pDoc->GetHcsANSWERMANs();

					// Format and send response for i/o
					if (pIO != NULL && idx >= 0) {

						if ((nP = pIO->GetIoLabel(idx)) == NULL)
							nP = _T("");

						val = pIO->GetIdValue(idx);
						str.Format(_T("%s,%d,%s,%d\n\r"), ioP, idx, nP, val);

					} else

						str.Format(_T("?%s\n\r"), m_commandLine.GetBuffer(80));

					SendData(str);
				}
			}

			m_commandLine.Empty();
		}
	}	
}


void CRequestSocket::OnSend(int nErrorCode) 
{
	long	nBytes = Send( m_outputBuf.GetData(), m_ouputIdx );

	if ( nBytes == SOCKET_ERROR ) {

		if ( GetLastError() != WSAEWOULDBLOCK ) {

			ShutDown( both );

		}	else	{

			AsyncSelect(FD_READ | FD_WRITE | FD_CLOSE );
		}

	} else if ( nBytes < m_ouputIdx ) {

		// still got some left....
		m_outputBuf.RemoveAt( 0, nBytes );
		m_ouputIdx -= nBytes;

		// set up for next write....
		AsyncSelect(FD_READ | FD_WRITE | FD_CLOSE );

	}	else	{

		m_ouputIdx = 0;
		AsyncSelect( FD_READ | FD_CLOSE );
	}
}


void CRequestSocket::OnClose(int nErrorCode) 
{
	delete this;
}
