/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// OptionSheet.cpp : implementation file
//

#include "stdafx.h"
#include "WinHcs.h"
#include "OptionSheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionSheet

IMPLEMENT_DYNAMIC(COptionSheet, CPropertySheet)

COptionSheet::COptionSheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
}

COptionSheet::COptionSheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
}

COptionSheet::~COptionSheet()
{
}


BEGIN_MESSAGE_MAP(COptionSheet, CPropertySheet)
	//{{AFX_MSG_MAP(COptionSheet)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionSheet message handlers
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CHcsCfgPage message handlers
/////////////////////////////////////////////////////////////////////////////
// CHcsCfgPage property page

IMPLEMENT_DYNCREATE(CHcsCfgPage, CPropertyPage)

#define	WIDTH_IDS_DESC		200
#define	WIDTH_IDS_NB		70

CHcsCfgPage::CHcsCfgPage() : CPropertyPage(CHcsCfgPage::IDD)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();

	//{{AFX_DATA_INIT(CHcsCfgPage)
	m_nbMCIR = 0;
	m_nbLCD = 0;
	m_nbDIO = 0;
	m_nbAMAN = 0;
	m_nbBUFIO = 0;
	//}}AFX_DATA_INIT

	m_pInputsCtrl	= NULL;
	m_pOutputsCtrl	= NULL;
	m_pNetbitsCtrl	= NULL;
	m_pADCsCtrl		= NULL;
	m_pDACsCtrl		= NULL;
	m_pVarsCtrl		= NULL;
	m_pTimersCtrl	= NULL;
	m_pLogIdsCtrl	= NULL;

	m_nbBUFIO= pDoc->GetNbBUFIO();
	m_nbMCIR = pDoc->GetHcsMCIRs()->GetMaxInGroup();
	m_nbLCD  = pDoc->GetHcsLCDs()->GetMaxInGroup();
	m_nbDIO  = pDoc->GetHcsDIOs()->GetMaxInGroup();
	m_nbAMAN = pDoc->GetHcsANSWERMANs()->GetMaxInGroup();
}

CHcsCfgPage::~CHcsCfgPage()
{
	if (m_pInputsCtrl)
		delete	m_pInputsCtrl;

	if (m_pOutputsCtrl)
		delete	m_pOutputsCtrl;

	if (m_pNetbitsCtrl)
		delete	m_pNetbitsCtrl;

	if (m_pADCsCtrl)
		delete	m_pADCsCtrl;

	if (m_pDACsCtrl)
		delete	m_pDACsCtrl;

	if (m_pVarsCtrl)
		delete	m_pVarsCtrl;

	if (m_pTimersCtrl)
		delete	m_pTimersCtrl;

	if (m_pLogIdsCtrl)
		delete	m_pLogIdsCtrl;
}

void CHcsCfgPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHcsCfgPage)
	DDX_Text(pDX, IDC_NB_MCIR, m_nbMCIR);
	DDX_Text(pDX, IDC_NB_LCD, m_nbLCD);
	DDX_Text(pDX, IDC_NB_DIO, m_nbDIO);
	DDX_Text(pDX, IDC_NB_AMAN, m_nbAMAN);
	DDX_Text(pDX, IDC_NB_BUFIO, m_nbBUFIO);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHcsCfgPage, CPropertyPage)
	//{{AFX_MSG_MAP(CHcsCfgPage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_IO_SELECT, OnSelchangeIoSelect)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_X10, OnEndlabeledit)
	//}}AFX_MSG_MAP
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_INPUTS,  OnEndlabeledit)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_OUTPUTS, OnEndlabeledit)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_NETBITS, OnEndlabeledit)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_ADCS,	 OnEndlabeledit)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_DACS,	 OnEndlabeledit)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_VARIABLES,OnEndlabeledit)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_TIMERS,  OnEndlabeledit)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDS_LOGIDS,  OnEndlabeledit)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHcsCfgPage message handlers

BOOL CHcsCfgPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	CListCtrl			*pList	= (CListCtrl *) GetDlgItem(IDS_X10);
	CTabCtrl			*pCtrl	= (CTabCtrl*) GetDlgItem(IDC_IO_SELECT);
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CSpinButtonCtrl		*pSpin;

	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_NB_BUFIO);
	pSpin->SetRange(0,1);
	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_NB_MCIR);
	pSpin->SetRange(0,MAX_MODULES_MCIR);
	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_NB_LCD);
	pSpin->SetRange(0,MAX_MODULES_LCD);
	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_NB_DIO);
	pSpin->SetRange(0,MAX_MODULES_DIO);
	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_NB_AMAN);
	pSpin->SetRange(0,MAX_MODULES_MAN);

	// Select X10 for now
	AddTab(IDS_X10,			pCtrl);
	AddTab(IDS_INPUTS,		pCtrl);
	AddTab(IDS_OUTPUTS,		pCtrl);
	AddTab(IDS_NETBITS,		pCtrl);
	AddTab(IDS_ADCS,		pCtrl);
	AddTab(IDS_DACS,		pCtrl);
	AddTab(IDS_VARIABLES,	pCtrl);
	AddTab(IDS_TIMERS,		pCtrl);
	AddTab(IDS_LOGIDS,		pCtrl);

	m_nActiveTab = IDS_X10;
	pCtrl->SetCurSel(0);


	// Setup the two columns of interest
	CString str1;
	if (str1.LoadString(IDS_DESC) == 0)
		TRACE1("Error: Failed to load string: %d\n", IDS_DESC);
	else
		pList->InsertColumn(0, str1,	LVCFMT_LEFT, WIDTH_IDS_DESC,  0);

	CString str2;
	if (str2.LoadString(IDS_NB) == 0)
		TRACE1("Error: Failed to load string: %d\n", IDS_NB);
	else
		pList->InsertColumn(1, str2,	LVCFMT_LEFT, WIDTH_IDS_NB,   1);

	
	m_pX10Ctrl		= pList;
	m_pInputsCtrl	= CopyList(pList, IDS_INPUTS);
 	m_pOutputsCtrl	= CopyList(pList, IDS_OUTPUTS);
	m_pNetbitsCtrl	= CopyList(pList, IDS_NETBITS);
	m_pADCsCtrl		= CopyList(pList, IDS_ADCS);
	m_pDACsCtrl		= CopyList(pList, IDS_DACS);
	m_pVarsCtrl		= CopyList(pList, IDS_VARIABLES);
	m_pTimersCtrl	= CopyList(pList, IDS_TIMERS);
	m_pLogIdsCtrl	= CopyList(pList, IDS_LOGIDS);


	UpdateConfigList(m_pX10Ctrl,	IDS_X10);
	UpdateConfigList(m_pInputsCtrl, IDS_INPUTS);
	UpdateConfigList(m_pOutputsCtrl,IDS_OUTPUTS);
	UpdateConfigList(m_pNetbitsCtrl,IDS_NETBITS);
	UpdateConfigList(m_pADCsCtrl,	IDS_ADCS);
	UpdateConfigList(m_pDACsCtrl,	IDS_DACS);
	UpdateConfigList(m_pVarsCtrl,	IDS_VARIABLES);
	UpdateConfigList(m_pTimersCtrl, IDS_TIMERS);
	UpdateConfigList(m_pLogIdsCtrl, IDS_LOGIDS);



	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHcsCfgPage::AddTab(int nID, CTabCtrl* pCtrl)
{
	// load a string from a resource and use it to
	// set the text on a tab control

	CString str;
	if (str.LoadString(nID) == 0)
	{
		TRACE1("Error: Failed to load string: %d\n", nID);
		return;
	}

	TC_ITEM tabItem;
	tabItem.mask = TCIF_TEXT | TCIF_PARAM;
	tabItem.pszText = (LPTSTR) (LPCTSTR) str;
	tabItem.lParam = nID;

	pCtrl->InsertItem(nID, &tabItem);
}



CListCtrl* CHcsCfgPage::CopyList(CListCtrl* pOldCtrl, int nNewID)
{
	// create a brand new list control that's exactly
	// like the one we're told about

	if (pOldCtrl == NULL)
		return NULL;

	// allocate the control
	CListCtrl* pNewCtrl = new CListCtrl;

	// we want the new control to have the same style
	// but not be visible
	DWORD dwStyle = pOldCtrl->GetStyle() & ~WS_VISIBLE;

	// get the rect of the existing one
	CRect rect;
	pOldCtrl->GetWindowRect(rect);
	ScreenToClient(rect);
 
	// and go create it
	if (NULL == pNewCtrl->Create(dwStyle, rect, this, nNewID))
	{
		TRACE1("Error: Failed to create control %d\n", nNewID);
		delete pNewCtrl;
		pNewCtrl = NULL;
	}
	else
	{
		CString str1;
		if (str1.LoadString(IDS_DESC) == 0)
			TRACE1("Error: Failed to load string: %d\n", IDS_DESC);
		else
			pNewCtrl->InsertColumn(0, str1,	LVCFMT_LEFT, WIDTH_IDS_DESC,  0);

		CString str2;
		if (str2.LoadString(IDS_NB) == 0)
			TRACE1("Error: Failed to load string: %d\n", IDS_NB);
		else
			pNewCtrl->InsertColumn(1, str2,	LVCFMT_LEFT, WIDTH_IDS_NB,   1);
	}

	return pNewCtrl;
}


void CHcsCfgPage::UpdateConfigList(CListCtrl* pList, int nID) 
{
	CWinHcsApp			*pApp	= (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc	= pApp->GetHcsStatusDoc();
	CHcsIo				*pIO;
	long				i, n;
	char				*pStr;
	char				index[16];

	switch( nID ) {
	default:
	case IDS_X10:			// X10
		pIO = pDoc->GetHcsX10();
		n	= MAX_X10;
		break;
	case IDS_INPUTS:		// Inputs
		pIO = pDoc->GetHcsInputs();
		n	= MAX_HCS_INPUTS;
		break;
	case IDS_OUTPUTS:		// Outputs
		pIO = pDoc->GetHcsOutputs();
		n	= MAX_HCS_OUTPUTS;
		break;
	case IDS_NETBITS:		// Netbits
		pIO = pDoc->GetHcsNetbits();
		n	= MAX_NETBITS;
		break;
	case IDS_ADCS:			// ADCs
		pIO = pDoc->GetHcsADCs();
		n	= MAX_ADCS;
		break;
	case IDS_DACS:			// DACs
		pIO = pDoc->GetHcsDACs();
		n	= MAX_DACS;
		break;
	case IDS_VARIABLES:		// Variables
		pIO = pDoc->GetHcsVariables();
		n	= MAX_VARS;
		break;
	case IDS_TIMERS:		// Timers
		pIO = pDoc->GetHcsTimers();
		n	= MAX_TIMERS;
		break;
	case IDS_LOGIDS:		// Log IDs
		pIO = pDoc->GetHcsLogIDs();
		n	= MAX_LOGID;
		break;
	}

	pList->DeleteAllItems();

	for (i = 0 ; i < n ; i++) {

		if ((pStr = pIO->GetIoLabel(i)) == NULL)
			pStr = _T("");

		sprintf(index, "%d", i);

		pList->InsertItem(i, pStr);
		pList->SetItem(i, 1, LVIF_TEXT, index, 0, 0, 0, 0);
	}
}


void CHcsCfgPage::UpdateConfigFromList(CListCtrl* pList, int nID) 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CHcsIo				*pIO;
	long				i, n, min_in_use, min_range, max_range;
	char				str[80];

	switch( nID ) {
	default:
	case IDS_X10:			// X10
		pIO			= pDoc->GetHcsX10();
		n			= MAX_X10;
		min_in_use	= -1;
		min_range	= -1;
		max_range	= -1;
		break;
	case IDS_INPUTS:		// Inputs
		pIO			= pDoc->GetHcsInputs();
		n			= MAX_HCS_INPUTS;
		min_in_use	= 16 + m_nbBUFIO * 24;
		min_range	= -1;
		max_range	= -1;
		break;
	case IDS_OUTPUTS:		// Outputs
		pIO			= pDoc->GetHcsOutputs();
		n			= MAX_HCS_OUTPUTS;
		min_in_use	= 12;
		min_range	= 16;
		max_range	= 16 + m_nbBUFIO * 24;
		break;
	case IDS_NETBITS:		// Netbits
		pIO			= pDoc->GetHcsNetbits();
		n			= MAX_NETBITS;
		min_in_use  = 8 * m_nbDIO;
		min_range	= 96;
		max_range	= 96 + 16 * m_nbAMAN;
		break;
	case IDS_ADCS:			// ADCs
		pIO			= pDoc->GetHcsADCs();
		n			= MAX_ADCS;
		min_in_use  = 8;
		min_range	= 16;
		max_range	= 16 + 8 * m_nbAMAN;
		break;
	case IDS_DACS:			// DACs
		pIO			= pDoc->GetHcsDACs();
		n			= MAX_DACS;
		min_in_use	= 4 * m_nbAMAN;
		min_range	= -1;
		max_range	= -1;
		break;
	case IDS_VARIABLES:		// Variables
		pIO			= pDoc->GetHcsVariables();
		n			= MAX_VARS;
		min_in_use	= -1;
		min_range	= -1;
		max_range	= -1;
		break;
	case IDS_TIMERS:		// Timers
		pIO			= pDoc->GetHcsTimers();
		n			= MAX_TIMERS;
		min_in_use	= -1;
		min_range	= -1;
		max_range	= -1;
		break;
	case IDS_LOGIDS:		// Log IDs
		pIO = pDoc->GetHcsLogIDs();
		n	= MAX_LOGID;
		min_in_use	= -1;
		min_range	= -1;
		max_range	= -1;
		break;
	}

	for (i = 0 ; i < n ; i++) {

		if (pList->GetItemText(i, 0, str, 80) > 0)
			pIO->SetInUse(i, str);
		else if (min_in_use > 0 && i < min_in_use) 
			pIO->SetInUse(i, _T(""));
		else if (min_range != max_range && i >= min_range && i < max_range) 
			pIO->SetInUse(i, _T(""));
		else
			pIO->SetNotInUse(i);
	}
}



void CHcsCfgPage::OnEndlabeledit(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO		*pDispInfo	= (LV_DISPINFO*)pNMHDR;
	CListCtrl		*pList		= (CListCtrl *) GetDlgItem(m_nActiveTab);
	char			*pStr		= pDispInfo->item.pszText;
	long			index		= pDispInfo->item.iItem;

	pList->SetItem(index, 0, LVIF_TEXT, pStr, 0, 0, 0, 0);
	*pResult = 0;
}


void CHcsCfgPage::OnSelchangeIoSelect(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// the user has clicked a different tab
	CTabCtrl			*pCtrl	= (CTabCtrl*) GetDlgItem(IDC_IO_SELECT);

	// figure out what tab item is selected
	// and get the lParam from it
	int nItem = pCtrl->GetCurSel();

	TC_ITEM tci;
	tci.mask = TCIF_PARAM;
	pCtrl->GetItem(nItem, &tci);

	// hide the list control which was previously
	// active and show the newly activated control
	CWnd* pOldOne = GetDlgItem(m_nActiveTab);
	CWnd* pNewOne = GetDlgItem(tci.lParam);

	pOldOne->ShowWindow(SW_HIDE);
	pNewOne->ShowWindow(SW_SHOW);

	m_nActiveTab = tci.lParam;

	*pResult = 0;
}



void CHcsCfgPage::OnOK() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CHcsIo				*pIO;
	long				i, n;
	unsigned char		mask;
	char				cmd[16];

	pDoc->SetNbBUFIO(m_nbBUFIO);

	for (i = 0, pIO = pDoc->GetHcsMCIRs() ; i < MAX_MODULES_MCIR ; i++) {
		if (i < m_nbMCIR)	pIO->SetInUse(i, _T(""));
		else				pIO->SetNotInUse(i);
	}

	for (i = 0, pIO = pDoc->GetHcsLCDs() ; i < MAX_MODULES_LCD ; i++) {
		if (i < m_nbLCD)	pIO->SetInUse(i, _T(""));
		else				pIO->SetNotInUse(i);
	}

	for (i = 0, pIO = pDoc->GetHcsDIOs() ; i < MAX_MODULES_DIO ; i++) {
		if (i < m_nbDIO)	pIO->SetInUse(i, _T(""));
		else				pIO->SetNotInUse(i);
	}

	for (i = 0, pIO = pDoc->GetHcsANSWERMANs() ; i < MAX_MODULES_MAN ; i++) {
		if (i < m_nbAMAN)	pIO->SetInUse(i, _T(""));
		else				pIO->SetNotInUse(i);
	}
	
	UpdateConfigFromList(m_pX10Ctrl,	IDS_X10);
	UpdateConfigFromList(m_pInputsCtrl, IDS_INPUTS);
	UpdateConfigFromList(m_pOutputsCtrl,IDS_OUTPUTS);
	UpdateConfigFromList(m_pNetbitsCtrl,IDS_NETBITS);
	UpdateConfigFromList(m_pADCsCtrl,	IDS_ADCS);
	UpdateConfigFromList(m_pDACsCtrl,	IDS_DACS);
	UpdateConfigFromList(m_pVarsCtrl,	IDS_VARIABLES);
	UpdateConfigFromList(m_pTimersCtrl, IDS_TIMERS);	
	UpdateConfigFromList(m_pLogIdsCtrl, IDS_LOGIDS);


	// Set ADC and DAC values to send depending on Nb of AMAN
	if (pDoc->IsConnectedToHcs() == TRUE) {

		cmd[0] = '!';					// DAC bitmap
		cmd[1] = 0x19;
		mask = 0xff;
		if (m_nbAMAN < 7) {
			n = 8 - 2 - m_nbAMAN;
			mask >>= n;
		}
		cmd[2] = (char) mask;
		n = 8 - m_nbAMAN;
		mask = 0x03 >> n;
		cmd[3] = (char) mask;
		cmd[4] = (char) 0;
		pDoc->SendMessageToHcs(cmd, 5);

		cmd[0] = '!';					// ADC bitmap
		cmd[1] = 0x1C;
		n = (8 - m_nbAMAN) / 2;
		mask = 0x0f >> n;
		cmd[2] = (char) mask;
		pDoc->SendMessageToHcs(cmd, 3);

		pDoc->SendMessageToHcs("!\x08", 2);
	}

	pDoc->UpdateAllViews(NULL);

	CPropertyPage::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
// CMiscCfgPage property page

IMPLEMENT_DYNCREATE(CMiscCfgPage, CPropertyPage)

CMiscCfgPage::CMiscCfgPage() : CPropertyPage(CMiscCfgPage::IDD)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();

	//{{AFX_DATA_INIT(CMiscCfgPage)
	m_port = _T("");
	m_usingModem = FALSE;
	m_modemInit = _T("");
	m_soundConnected = pApp->m_sndHcsConnect;
	m_soundFailure = pApp->m_sndFailure;
	m_soundIoError = pApp->m_sndHcsError;
	m_soundSuccess = pApp->m_sndSuccess;
	m_soundsEnabled =  pApp->m_sndEnabled;
	m_tcpPort = pDoc->m_listenPort;
	m_autoConnect = pDoc->m_AutoConnectAtStartup;
	m_autoViewStatus = pDoc->m_ShowViewAtStartup;
	//}}AFX_DATA_INIT

	// Retrieve initial settings
	pDoc->GetRS232Settings(m_port, &m_usingModem, m_modemInit);
	m_timeUpdatePeriod = pDoc->GetTimeUpdateRate();
}

CMiscCfgPage::~CMiscCfgPage()
{
}

void CMiscCfgPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMiscCfgPage)
	DDX_CBString(pDX, IDC_PORT, m_port);
	DDX_Check(pDX, IDC_MODEM_CONNECTION, m_usingModem);
	DDX_Text(pDX, IDC_MODEM_INIT, m_modemInit);
	DDX_Text(pDX, IDC_SOUND_CONNECT, m_soundConnected);
	DDX_Text(pDX, IDC_SOUND_FAILURE, m_soundFailure);
	DDX_Text(pDX, IDC_SOUND_IO_ERROR, m_soundIoError);
	DDX_Text(pDX, IDC_SOUND_SUCCESS, m_soundSuccess);
	DDX_Check(pDX, IDC_CHECK_ENABLE_SOUNDS, m_soundsEnabled);
	DDX_Text(pDX, IDC_TCPPORT, m_tcpPort);
	DDV_MinMaxUInt(pDX, m_tcpPort, 0, 32000);
	DDX_Check(pDX, IDC_CHECK_AUTO_CONNECT, m_autoConnect);
	DDX_Check(pDX, IDC_CHECK_AUTO_VIEW, m_autoViewStatus);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMiscCfgPage, CPropertyPage)
	//{{AFX_MSG_MAP(CMiscCfgPage)
	ON_BN_CLICKED(IDC_TIME_NEVER, OnTimeNever)
	ON_BN_CLICKED(IDC_TIME_SLOW, OnTimeSlow)
	ON_BN_CLICKED(IDC_TIME_FAST, OnTimeFast)
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, OnButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_FAILURE, OnButtonFailure)
	ON_BN_CLICKED(IDC_BUTTON_IO_ERROR, OnButtonIoError)
	ON_BN_CLICKED(IDC_BUTTON_SUCCESS, OnButtonSuccess)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMiscCfgPage message handlers

void CMiscCfgPage::OnTimeNever() 
{
	m_timeUpdatePeriod = TIME_UPDATE_NONE;	
}

void CMiscCfgPage::OnTimeSlow() 
{
	m_timeUpdatePeriod = TIME_UPDATE_SLOW;	
}

void CMiscCfgPage::OnTimeFast() 
{
	m_timeUpdatePeriod = TIME_UPDATE_FAST;
}


void CMiscCfgPage::OnButtonConnect() 
{
	 SelectSoundFile(m_soundConnected);
}

void CMiscCfgPage::OnButtonFailure() 
{
	 SelectSoundFile(m_soundFailure);
}

void CMiscCfgPage::OnButtonIoError() 
{
	 SelectSoundFile(m_soundIoError);
}

void CMiscCfgPage::OnButtonSuccess() 
{
	 SelectSoundFile(m_soundSuccess);
}

void CMiscCfgPage::SelectSoundFile(CString &str)
{
	CFileDialog	dlg(TRUE,
			_T(".wav"),
			_T(""), 
			OFN_HIDEREADONLY | OFN_NOREADONLYRETURN | OFN_PATHMUSTEXIST | OFN_SHAREAWARE,
			_T("Wave Sound (*.wav)|*.wav|All Files|*.*||"),
			NULL);

	if (dlg.DoModal() == IDOK) {

		str = dlg.GetPathName();
		UpdateData(FALSE);
	}
}


BOOL CMiscCfgPage::OnInitDialog() 
{
	CWinHcsApp			*pApp	= (CWinHcsApp *) AfxGetApp();
	CButton				*pBtnNever, *pBtnSlow, *pBtnFast;
	CSpinButtonCtrl		*pSpin;

	CPropertyPage::OnInitDialog();

	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_TCPPORT);
	pSpin->SetRange(0,32000);

	// Retrieve initial settings
	pBtnNever = (CButton *) GetDlgItem(IDC_TIME_NEVER);
	pBtnSlow  = (CButton *) GetDlgItem(IDC_TIME_SLOW);
	pBtnFast  = (CButton *) GetDlgItem(IDC_TIME_FAST);

	switch(	m_timeUpdatePeriod ) {	
	case TIME_UPDATE_NONE:
		pBtnNever->SetCheck(1);
		pBtnSlow->SetCheck(0);
		pBtnFast->SetCheck(0);
		break;
	case TIME_UPDATE_SLOW:
		pBtnNever->SetCheck(0);
		pBtnSlow->SetCheck(1);
		pBtnFast->SetCheck(0);
		break;
	default:
	case TIME_UPDATE_FAST:
		pBtnNever->SetCheck(0);
		pBtnSlow->SetCheck(0);
		pBtnFast->SetCheck(1);
		break;
	}

	// Sounds
	m_soundsEnabled	= pApp->m_sndEnabled;
	m_soundSuccess	= pApp->m_sndSuccess;
	m_soundFailure	= pApp->m_sndFailure;
	m_soundConnected= pApp->m_sndHcsConnect;
	m_soundIoError	= pApp->m_sndHcsError;

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMiscCfgPage::OnOK() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();

	pDoc->SetRS232Settings(m_port, m_usingModem, m_modemInit);
	pDoc->SetTimeUpdateRate(m_timeUpdatePeriod);
	pDoc->m_listenPort = m_tcpPort;

	pDoc->m_AutoConnectAtStartup = m_autoConnect;
	pDoc->m_ShowViewAtStartup = m_autoViewStatus;

	// Sounds
	pApp->m_sndEnabled	= m_soundsEnabled;
	pApp->m_sndSuccess	= m_soundSuccess;
	pApp->m_sndFailure	= m_soundFailure;
	pApp->m_sndHcsConnect = m_soundConnected;
	pApp->m_sndHcsError	= m_soundIoError;

	CPropertyPage::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
// CXpressCfgPage property page

IMPLEMENT_DYNCREATE(CXpressCfgPage, CPropertyPage)

CXpressCfgPage::CXpressCfgPage() : CPropertyPage(CXpressCfgPage::IDD)
{
	CWinHcsApp			*pApp	= (CWinHcsApp *) AfxGetApp();

	//{{AFX_DATA_INIT(CXpressCfgPage)
	m_bin2xpress_path		= pApp->m_xpressBin2SourcePath;
	m_xpressCompiler_path	= pApp->m_xpressCompilerPath;
	m_addHcsConfig			= pApp->m_xpressAddHcsCfg;
	m_HcsMacroPath			= pApp->m_MacroHcsMacroPath;
	m_macroTimeout			= pApp->m_MacroTimeout;
	//}}AFX_DATA_INIT
}

CXpressCfgPage::~CXpressCfgPage()
{
}

void CXpressCfgPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXpressCfgPage)
	DDX_Text(pDX, IDC_BIN2XPRESS_PATH, m_bin2xpress_path);
	DDX_Text(pDX, IDC_XPRESS_COMPILER_PATH, m_xpressCompiler_path);
	DDX_Check(pDX, IDC_ADD_IO_DEF, m_addHcsConfig);
	DDX_Text(pDX, IDC_HCS_MACRO_PATH, m_HcsMacroPath);
	DDX_Text(pDX, IDC_EDIT_TIMEOUT, m_macroTimeout);
	DDV_MinMaxLong(pDX, m_macroTimeout, -1, 30000);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXpressCfgPage, CPropertyPage)
	//{{AFX_MSG_MAP(CXpressCfgPage)
	ON_BN_CLICKED(IDC_BUTTON_BIN, OnButtonBin)
	ON_BN_CLICKED(IDC_BUTTON_XPRESS, OnButtonXpress)
	ON_BN_CLICKED(IDC_BUTTON_MACRO, OnButtonMacro)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXpressCfgPage message handlers

void CXpressCfgPage::OnButtonBin() 
{
	CFileDialog	dlg(TRUE,
			_T(".exe"),
			_T("Bin2Hcs"), 
			OFN_HIDEREADONLY | OFN_NOREADONLYRETURN | OFN_PATHMUSTEXIST | OFN_SHAREAWARE,
			_T("Executable Files (*.exe)|*.exe|All Files|*.*||"),
			NULL);

	if (dlg.DoModal() == IDOK) {

		m_bin2xpress_path = dlg.GetPathName();
		UpdateData(FALSE);
	}
}

void CXpressCfgPage::OnButtonXpress() 
{
	CFileDialog	dlg(TRUE,
			_T(".exe"),
			_T("compile"), 
			OFN_HIDEREADONLY | OFN_NOREADONLYRETURN | OFN_PATHMUSTEXIST | OFN_SHAREAWARE,
			_T("Executable Files (*.exe)|*.exe|All Files|*.*||"),
			NULL);

	if (dlg.DoModal() == IDOK) {

		m_xpressCompiler_path = dlg.GetPathName();
		UpdateData(FALSE);
	}
}


void CXpressCfgPage::OnButtonMacro() 
{
	CFileDialog	dlg(TRUE,
			_T(".hcm"),
			_T(""), 
			OFN_HIDEREADONLY | OFN_NOREADONLYRETURN | OFN_PATHMUSTEXIST | OFN_SHAREAWARE,
			_T("WinHcs Macro Files (*.hcm)|*.hcm|All Files|*.*||"),
			NULL);

	if (dlg.DoModal() == IDOK) {

		m_HcsMacroPath = dlg.GetPathName();
		UpdateData(FALSE);
	}
}

void CXpressCfgPage::OnOK() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	pApp->m_xpressBin2SourcePath = m_bin2xpress_path;
	pApp->m_xpressCompilerPath   = m_xpressCompiler_path;
	pApp->m_xpressAddHcsCfg		 = m_addHcsConfig;
	pApp->m_MacroHcsMacroPath	 = m_HcsMacroPath;
	pApp->m_MacroTimeout		 = m_macroTimeout;
	
	CPropertyPage::OnOK();
}


BOOL CXpressCfgPage::OnInitDialog() 
{
	CSpinButtonCtrl		*pSpin;

	CPropertyPage::OnInitDialog();
	
	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_TIMEOUT);
	pSpin->SetRange(-1, 30000);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
/////////////////////////////////////////////////////////////////////////////
// CLogCfgPage property page

IMPLEMENT_DYNCREATE(CLogCfgPage, CPropertyPage)

CLogCfgPage::CLogCfgPage() : CPropertyPage(CLogCfgPage::IDD)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();

	//{{AFX_DATA_INIT(CLogCfgPage)
	m_logUpdatePeriod = 0;
	m_logAutoClear = FALSE;
	m_OdbcEnable = pDoc->m_OdbcEnable;
	m_OdbcDSN = pDoc->m_OdbcDSN;
	m_OdbcTable = pDoc->m_OdbcTable;
	m_OdbcUpdAtConnect = pDoc->m_OdbcUpdAtConnect;
	m_OdbcUpdateFreq = pDoc->m_OdbcUpdateFreq;
	m_autoUpload = FALSE;
	//}}AFX_DATA_INIT
	// Retrieve initial settings

	pDoc->GetLogUpdateSettings(&m_logUpdatePeriod, &m_autoUpload, &m_logAutoClear);
}

CLogCfgPage::~CLogCfgPage()
{
}

void CLogCfgPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLogCfgPage)
	DDX_Text(pDX, IDC_LOG_UPDATE, m_logUpdatePeriod);
	DDV_MinMaxLong(pDX, m_logUpdatePeriod, 1, 60);
	DDX_Check(pDX, IDC_LOG_CLEAR, m_logAutoClear);
	DDX_Check(pDX, IDC_CHECK_DB, m_OdbcEnable);
	DDX_Text(pDX, IDC_EDIT_ODBC_DSN, m_OdbcDSN);
	DDX_Text(pDX, IDC_EDIT_ODBC_TABLE, m_OdbcTable);
	DDX_Check(pDX, IDC_CHECK_DB_CONNECT_UPD, m_OdbcUpdAtConnect);
	DDX_Text(pDX, IDC_LOG_DB_UPDATE, m_OdbcUpdateFreq);
	DDV_MinMaxUInt(pDX, m_OdbcUpdateFreq, 1, 120);
	DDX_Check(pDX, IDC_LOG_AUTO_UPLOAD, m_autoUpload);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLogCfgPage, CPropertyPage)
	//{{AFX_MSG_MAP(CLogCfgPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLogCfgPage message handlers

BOOL CLogCfgPage::OnInitDialog() 
{
	CSpinButtonCtrl		*pSpin;

	CPropertyPage::OnInitDialog();
	
	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_LOG_UPDATE);
	pSpin->SetRange(1, 60);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);

	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_LOG_DB_UPDATE);
	pSpin->SetRange(1, 120);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLogCfgPage::OnOK() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();

	pDoc->SetLogUpdateSettings(m_logUpdatePeriod, m_autoUpload, m_logAutoClear);

	pDoc->m_OdbcEnable		= m_OdbcEnable;
	pDoc->m_OdbcDSN			= m_OdbcDSN;
	pDoc->m_OdbcTable		= m_OdbcTable;
	pDoc->m_OdbcUpdateFreq	= m_OdbcUpdateFreq;
	pDoc->m_OdbcUpdAtConnect= m_OdbcUpdAtConnect;
	
	CPropertyPage::OnOK();
}
