/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "WinHcs.h"

#include "WinHcsDoc.h"
#include "WinHcsView.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

const UINT msgUpdateHcsView  = ::RegisterWindowMessage(_T("UpdateHcsView"));
const UINT msgUpdateProgress = ::RegisterWindowMessage(_T("UpdateProgress"));


IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	ON_WM_INITMENU()
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_COMMAND(ID_WINDOW_NEW, OnWindowNew)
	ON_UPDATE_COMMAND_UI(ID_WINDOW_NEW, OnUpdateWindowNew)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP

	// Global help commands
	ON_COMMAND(ID_HELP_FINDER, CMDIFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpFinder)

	ON_REGISTERED_MESSAGE(msgUpdateHcsView,  OnUpdateHcsView)
	ON_REGISTERED_MESSAGE(msgUpdateProgress, OnUpdateProgress)

	ON_LBN_DBLCLK(IDC_MSGLIST, OnDlgBarDblclkList)

END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	0,						// 1. Number of TCP connections
	0,						// 2. Log number of entries
	0,						// 3. Connected Status & HCS Time
	0,						// 4. Cursor position
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	m_scriptInitialized = FALSE;	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	CWinHcsApp		*pApp = (CWinHcsApp *) AfxGetApp();
	UINT			uID;
	UINT			uStyle;
	int 			nWidth;
	CDC				*pDC;
	CRect			rectArea;


	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}
	m_wndToolBar.SetWindowText(_T("Standard"));


	if (!m_wndStatusBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_BOTTOM , AFX_IDW_STATUS_BAR) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}


	// Setup custom status bar fields
	pDC = m_wndStatusBar.GetDC();
	pDC->SelectObject(m_wndStatusBar.GetFont());

	m_wndStatusBar.GetPaneInfo(1, uID, uStyle, nWidth);
	pDC->DrawText(_T("TCP: 99"), -1, rectArea, DT_SINGLELINE | DT_CALCRECT);
	m_wndStatusBar.SetPaneInfo(1, uID, uStyle, rectArea.Width());

	m_wndStatusBar.GetPaneInfo(2, uID, uStyle, nWidth);
	pDC->DrawText(_T("Log: 4096 entries"), -1, rectArea, DT_SINGLELINE | DT_CALCRECT);
	m_wndStatusBar.SetPaneInfo(2, uID, uStyle, rectArea.Width());

	m_wndStatusBar.GetPaneInfo(3, uID, uStyle, nWidth);
	pDC->DrawText(_T("Wed, Nov 27, 1997 22:27:55 "), -1, rectArea, DT_SINGLELINE | DT_CALCRECT);
	m_wndStatusBar.SetPaneInfo(3, uID, uStyle, rectArea.Width());

	m_wndStatusBar.GetPaneInfo(4, uID, uStyle, nWidth);
	pDC->DrawText(_T("Ln 9999, Col 999"), -1, rectArea, DT_SINGLELINE | DT_CALCRECT);
	m_wndStatusBar.SetPaneInfo(4, uID, uStyle, rectArea.Width());

	m_wndStatusBar.ReleaseDC(pDC);


	// Dialog Bar to display errors
	if (!m_wndDlgBar.Create(this, IDD_DIALOGBAR,
		CBRS_BOTTOM|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_FIXED, IDD_DIALOGBAR))
	{
		TRACE0("Failed to create DlgBar\n");
		return -1;      // fail to create
	}
	m_wndDlgBar.SetWindowText(_T("Error Messages"));
	DlgBarHide();


	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	// Restore settings
	pApp->RestoreWindowPosition(this, IDS_REG_SETTINGS, IDS_REG_WINHCS_POS);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CMDIFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return TRUE;
}



void CMainFrame::OnDestroy() 
{	
	CWinHcsApp		*pApp = (CWinHcsApp *) AfxGetApp();

	pApp->SaveWindowPosition(this, IDS_REG_SETTINGS, IDS_REG_WINHCS_POS);

	CMDIFrameWnd::OnDestroy();
}



void CMainFrame::OnClose() 
{
	CWinHcsApp		*pApp = (CWinHcsApp *) AfxGetApp();
	long			n;
	POSITION		pos;
	CWinHcsDoc		*pDoc;
	CString			grp;
	CString			key;
	CString			str;
	BOOL			bVal;
	CWnd			*pWnd;

	n = 1;
	grp.LoadString(IDS_REG_XPRESS);

    pos = (pApp->m_pDocTemplate)->GetFirstDocPosition() ;
	while (pos != NULL) {

		pDoc = (CWinHcsDoc *) (pApp->m_pDocTemplate)->GetNextDoc(pos);

		key.Format("Xpress_%d", n);
		str = pDoc->GetPathName();

		if (str.IsEmpty() == FALSE) {

			bVal = pApp->WriteProfileString(grp, key, str);

			key.Format("XpressPos_%d", n);
			pWnd  = (pDoc->GetView())->GetParent();
			pApp->SaveWindowPosition(pWnd, grp, key);

	        n++;
		}
	}
	
	n = 1;
	grp.LoadString(IDS_REG_MACRO);

    pos = (pApp->m_pMacroTemplate)->GetFirstDocPosition() ;
	while (pos != NULL) {

		pDoc = (CWinHcsDoc *) (pApp->m_pMacroTemplate)->GetNextDoc(pos);

		key.Format("Macro_%d", n);
		str = pDoc->GetPathName();

		if (str.IsEmpty() == FALSE) {
			bVal = pApp->WriteProfileString(grp, key, str);

			key.Format("MacroPos_%d", n);
			pWnd  = (pDoc->GetView())->GetParent();
			pApp->SaveWindowPosition(pWnd, grp, key);

			n++;
		}
	}

	CMDIFrameWnd::OnClose();
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers


void CMainFrame::OnInitMenu(CMenu* pMenu)
{
   CMDIFrameWnd::OnInitMenu(pMenu);
  
	// CG: This block added by 'Tip of the Day' component.
	{
		// TODO: This code adds the "Tip of the Day" menu item
		// on the fly.  It may be removed after adding the menu
		// item to all applicable menu items using the resource
		// editor.

		// Add Tip of the Day menu item on the fly!
		static CMenu* pSubMenu = NULL;

		CString strHelp; strHelp.LoadString(CG_IDS_TIPOFTHEDAYHELP);
		CString strMenu;
		int nMenuCount = pMenu->GetMenuItemCount();
		BOOL bFound = FALSE;
		for (int i=0; i < nMenuCount; i++) 
		{
			pMenu->GetMenuString(i, strMenu, MF_BYPOSITION);
			if (strMenu == strHelp)
			{ 
				pSubMenu = pMenu->GetSubMenu(i);
				bFound = TRUE;
				ASSERT(pSubMenu != NULL);
			}
		}

		CString strTipMenu;
		strTipMenu.LoadString(CG_IDS_TIPOFTHEDAYMENU);
		if (!bFound)
		{
			// Help menu is not available. Please add it!
			if (pSubMenu == NULL) 
			{
				// The same pop-up menu is shared between mainfrm and frame 
				// with the doc.
				static CMenu popUpMenu;
				pSubMenu = &popUpMenu;
				pSubMenu->CreatePopupMenu();
				pSubMenu->InsertMenu(0, MF_STRING|MF_BYPOSITION, 
					CG_IDS_TIPOFTHEDAY, strTipMenu);
			} 
			pMenu->AppendMenu(MF_STRING|MF_BYPOSITION|MF_ENABLED|MF_POPUP, 
				(UINT)pSubMenu->m_hMenu, strHelp);
			DrawMenuBar();
		} 
		else
		{      
			// Check to see if the Tip of the Day menu has already been added.
			pSubMenu->GetMenuString(0, strMenu, MF_BYPOSITION);

			if (strMenu != strTipMenu) 
			{
				// Tip of the Day submenu has not been added to the 
				// first position, so add it.
				pSubMenu->InsertMenu(0, MF_BYPOSITION);  // Separator
				pSubMenu->InsertMenu(0, MF_STRING|MF_BYPOSITION, 
					CG_IDS_TIPOFTHEDAY, strTipMenu);
			}
		}
	}

}


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


BOOL CMainFrame::DlgBarIsVisible()
{
	return m_wndDlgBar.IsWindowVisible();
}

void CMainFrame::DlgBarHide()
{
	CListBox	*pList = (CListBox*)m_wndDlgBar.GetDlgItem(IDC_MSGLIST);

	ShowControlBar(&m_wndDlgBar, FALSE, FALSE);
	RecalcLayout();
}

void CMainFrame::DlgBarShow()
{
	CListBox	*pList = (CListBox*)m_wndDlgBar.GetDlgItem(IDC_MSGLIST);
	CRect		rect;

	ShowControlBar(&m_wndDlgBar, TRUE, FALSE);
	RecalcLayout();

	if (m_wndDlgBar.IsFloating() == FALSE) {

		m_wndDlgBar.GetClientRect(&rect);

		rect.left = 6;
		rect.right = rect.right - 6;
		rect.top = 7;
		rect.bottom = rect.bottom - 7;

		pList->MoveWindow(&rect, TRUE);
	}
}

void CMainFrame::DlgBarClear()
{
	CListBox	*pList = (CListBox*)m_wndDlgBar.GetDlgItem(IDC_MSGLIST);

	pList->ResetContent();
}

void CMainFrame::DlgBarAddMessage(char *pLine)
{
	CListBox	*pList = (CListBox*)m_wndDlgBar.GetDlgItem(IDC_MSGLIST);
	int			i;
	
	i = pList->AddString(pLine);
	pList->SetTopIndex(i);
}

void CMainFrame::OnDlgBarDblclkList() 
{
	CMDIChildWnd	*pChild = (CMDIChildWnd *) GetActiveFrame();
	CWinHcsView		*pView = (CWinHcsView *) pChild->GetActiveView();
	CListBox		*pList = (CListBox*)m_wndDlgBar.GetDlgItem(IDC_MSGLIST);
	long			sel, i;
	char			*sP;
	char			*pKey = "line";
	char			szBuffer[256];

	if (pView == NULL || pView->IsKindOf(RUNTIME_CLASS(CWinHcsView)) == 0)
		return;

	szBuffer[0] = 0;
	sel = pList->GetCurSel();
	pList->GetText(sel, szBuffer);

	sP = strstr(szBuffer, pKey);
	if (sP == NULL)
		return;

	sP = sP + strlen(pKey);
	i = 0;
	i = atoi(sP);

	pView->SelectLine(i);
}



/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::WindowArrangements(UINT nID)
{
	this->OnMDIWindowCmd(nID);
}

void CMainFrame::SetHcsConnectionStatus(fHcsStatus fVal)
{
	CString str;

	if (fVal == HcsStatusConnected)		str.LoadString(IDS_CONNECTED);
	else if (fVal == HcsStatusDialing)	str.LoadString(IDS_DIALING);
	else								str.LoadString(IDS_DISCONNECTED);

	m_wndStatusBar.SetPaneText(3, str);
}


void CMainFrame::UpdateHcsView(void)
{
	::PostMessage(m_hWnd, msgUpdateHcsView, 0, (LPARAM) 0);
}


void CMainFrame::UpdateProgress(fHcsProgressType type, long progress)
{
	::PostMessage(m_hWnd, msgUpdateProgress, (WPARAM) type, (LPARAM) progress);
}


LRESULT CMainFrame::OnUpdateHcsView(WPARAM wParam, LPARAM lParam)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CString				str	  = pDoc->GetHcsTime();

	m_wndStatusBar.SetPaneText(3, str);
	pDoc->UpdateAllViews(NULL);
	
	return 0;
}

void CMainFrame::ClearLogEntries(void)
{
	m_wndStatusBar.SetPaneText(2, _T("Log: -"));
}

LRESULT CMainFrame::OnUpdateProgress(WPARAM wParam, LPARAM lParam)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CHcsIo				*pIO;
	long				i, j;
	CString				str;
	char				*sP;

	switch ((fHcsProgressType) wParam) {
	default:
		_SOUND(m_sndFailure);
		str.Format(IDS_ERR_ARG_HCS, wParam);
		AfxMessageBox(str, MB_OK | MB_ICONSTOP, 0);
		break;
	case HcsGotVar:
		pIO = pDoc->GetHcsVariables();

		// Get ID and value
		i = (long) HIWORD(lParam);
		j = lParam & 0xffff;

		// Try to get Variable name
		if ((sP = pIO->GetIoLabel(i)) == NULL)
			sP = _T("");
		
		str.Format(_T("Variable #%d '%s' = %d"), i, sP, j);
		AfxMessageBox(str, MB_OK | MB_ICONINFORMATION, 0);
		break;
	case HcsGotLogSize:
		str.Format(_T("Log: %d entries"), lParam);
		m_wndStatusBar.SetPaneText(2, str);
		break;
	case HcsGotLogData:
		pApp->ReceivedLogData(lParam);		
		_SOUND(m_sndSuccess);
		break;
	case HcsLogSizeProgress:
		str.Format(IDS_FMT_LOG_SZ, lParam);
		m_wndStatusBar.SetPaneText(3, str);
		break;
	case HcsInfo:
		str.Format(IDS_FMT_HCS_INFO, lParam);
		AfxMessageBox(str, MB_OK, 0);
		break;
	case HcsLdPrgProgress:
		str.Format(IDS_FMT_UPLOAD_SZ, lParam);
		m_wndStatusBar.SetPaneText(3, str);
		break;
	case HcsLdPrgOK:
		_SOUND(m_sndSuccess);
		AfxMessageBox(IDS_FMT_LOAD_PRG, MB_OK | MB_ICONINFORMATION, 0);
		break;
	case HcsLdPrgVer:
		_SOUND(m_sndFailure);
		AfxMessageBox(IDS_FMT_LOAD_PRG_ERR1,MB_OK | MB_ICONSTOP, 0);
		break;
	case HcsLdPrgSize:
		_SOUND(m_sndFailure);
		AfxMessageBox(IDS_FMT_LOAD_PRG_ERR2, MB_OK | MB_ICONSTOP, 0);
		break;
	}

	return 0;
}


CScriptControl * CMainFrame::GetScriptControl(BOOL bReset)
{
	CWinHcsApp			*pApp    = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pHcsDoc = pApp->GetHcsStatusDoc();
	LPDISPATCH			pDispatch;

	// Create the script control
	CScriptControl *scriptP = (CScriptControl *) m_wndDlgBar.GetDlgItem(IDC_SCRIPTCONTROL);
	CScriptError	err		= scriptP->GetError();

	err.Clear();

	if ((m_scriptInitialized == FALSE || bReset == TRUE) && scriptP != NULL) {

		// Setup script control
		scriptP->Reset();

		scriptP->SetAllowUI(TRUE);
		scriptP->SetLanguage("VBScript");
		scriptP->SetState(TRUE);
		scriptP->SetUseSafeSubset(FALSE);
		scriptP->SetTimeout(pApp->m_MacroTimeout);


		// Add objects
		pDispatch = pApp->GetIDispatch(TRUE);
		scriptP->AddObject(_T("Application"), pDispatch, TRUE);

		pDispatch = pHcsDoc->GetIDispatch(TRUE);
		scriptP->AddObject(_T("hcs"), pDispatch, TRUE);
			
		m_scriptInitialized = TRUE;
	}

	return scriptP;
}


BEGIN_EVENTSINK_MAP(CMainFrame, CMDIFrameWnd)
    //{{AFX_EVENTSINK_MAP(CMainFrame)
	ON_EVENT(CMainFrame, IDC_SCRIPTCONTROL, 3000 /* Error */, OnErrorScript, VTS_NONE)
	ON_EVENT(CMainFrame, IDC_SCRIPTCONTROL, 3001 /* Timeout */, OnTimeoutScript, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CMainFrame::OnErrorScript() 
{
	CScriptControl *scriptP = GetScriptControl(FALSE);
	CScriptError	err = scriptP->GetError();

	long	nb = err.GetNumber();
	long	co = err.GetColumn();
	long	ln = err.GetLine();
	CString ds = err.GetDescription();
	CString Sr = err.GetSource();
	CString tx = err.GetText();

	CString m;
	m.Format(IDS_ERR_SCRIPT, Sr, nb, ln, co, ds, tx);

	_SOUND(m_sndFailure);
	AfxMessageBox(m);
}

void CMainFrame::OnTimeoutScript() 
{
	_SOUND(m_sndFailure);
	AfxMessageBox(IDS_ERR_SCRIPT_TIMEOUT);
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{
	CListBox	*pList = (CListBox*)m_wndDlgBar.GetDlgItem(IDC_MSGLIST);
	CRect		rect;

	if (m_wndDlgBar.IsWindowVisible() == TRUE && m_wndDlgBar.IsFloating() == FALSE) {

		RecalcLayout();

		m_wndDlgBar.GetClientRect(&rect);

		rect.left = 6;
		rect.right = rect.right - 6;
		rect.top = 7;
		rect.bottom = rect.bottom - 7;

		pList->MoveWindow(&rect, TRUE);
	}

	CMDIFrameWnd::OnSize(nType, cx, cy);
}



void CMainFrame::OnWindowNew() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CMDIChildWnd		*pActiveChild = MDIGetActive();
	CDocument			*pDocument;

	if (pActiveChild == NULL || (pDocument = pActiveChild->GetActiveDocument()) == NULL)
	{
		TRACE0("Warning: No active document for Window New command.\n");
		AfxMessageBox(AFX_IDP_COMMAND_FAILURE);
		return;     // command failed
	}

	if (pDocument == pApp->GetHcsStatusDoc())
		return;

	CMDIFrameWnd::OnWindowNew();
}

void CMainFrame::OnUpdateWindowNew(CCmdUI* pCmdUI) 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CMDIChildWnd		*pActiveChild = MDIGetActive();
	CDocument			*pDocument;
	BOOL				bVal = TRUE;

	if (pActiveChild != NULL
			&& (pDocument = pActiveChild->GetActiveDocument()) != NULL
			&& pDocument == pApp->GetHcsStatusDoc())
		bVal = FALSE;

	pCmdUI->Enable( bVal );
}

