/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// HcsIo.h: interface for the CHcsIo class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HCSIO_H__E2597EE1_4D4F_11D1_A792_0000860F6884__INCLUDED_)
#define AFX_HCSIO_H__E2597EE1_4D4F_11D1_A792_0000860F6884__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000



#define	IO_PL			0
#define	IO_LCD			1
#define IO_MCIR			2
#define IO_MAN			3
#define IO_DIO			4
#define IO_INPUTS		5
#define IO_OUTPUTS		6
#define IO_NETBITS		7
#define IO_X10			8
#define IO_ADCS			9
#define IO_NET_ADCS		10
#define IO_NET_DACS		11
#define	IO_CONSOLE		12
#define	IO_VARS			13

#define	IO_MAX			14

#define	MAX_IO_NAME_SZ	32



typedef enum {
		None = 0, Lamp, Appliance, Wall, Signal, IR, Remote, Chime
} IoConfig;



typedef enum {
	IoChar, IoBool, IoShort, IoX10
} IoType;



typedef struct {

	BOOL		inUse;
	union {
		char	cValue;
		BOOL	bValue;
		short	sValue;
	} value;

	BOOL		bBeingChanged;

	IoConfig	config;
	char		name[ MAX_IO_NAME_SZ ];

} IoStatus, *pIoStatus;




class CHcsIo  
{
public:
	long	m_userData1, m_userData2;	// Used to keep track of last operation arguments

	CHcsIo();
	CHcsIo(IoType type, long size, const char *section);
	virtual ~CHcsIo();

	void Setup(IoType type, long size, const char *section);
	void SaveSetup(void);

	void SetInUse(long index);
	void SetInUse(long index, char *nameP);
	void SetNotInUse(long index);
	BOOL IsInUse(long index);

	void SetBeingChanged(long index);
	BOOL IsBeingChanged(long index);

	void SetGroup(long index, char *pData);
	void GetGroup(CString& strLine, long index, long lastIndex);
	long GetMaxInGroup(void);

	COLORREF GetColorIdState(long index);

	void SetIdValue(long index, long val);
	long GetIdValue(long index);

	void SetCurrentSelection(char *pszLabel);
	void SetCurrentSelection(long index);
	long GetCurrentSelection();

	BOOL GetFirstIo(long *pIndex, char *pName, void *pVal, IoConfig *pCfg);
	BOOL GetNextIo(	long *pIndex, char *pName, void *pVal, IoConfig *pCfg);

	BOOL GetFirstIoLabel(CString *pBuf, long *pIndex);
	BOOL GetNextIoLabel( CString *pBuf, long *pIndex);

	char * GetIoLabel(long index);

private:
#define	SECTION_STR_SZ	40
	char		m_szProfileSection[SECTION_STR_SZ];
	IoType		m_IoType;
	long		m_szIoStatus;
	pIoStatus	m_pIoStatus;

	long		m_pos;
	long		m_pos_high;
	long		m_pos_sel;
};

#endif // !defined(AFX_HCSIO_H__E2597EE1_4D4F_11D1_A792_0000860F6884__INCLUDED_)
