/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// HcsIo.cpp: implementation of the CHcsIo class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HcsIo.h"
#include "WinHcs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHcsIo::CHcsIo()
{
	m_userData1		= 0;
	m_userData2		= 0;

	m_pos			= -1;
	m_pos_high		= -1;
	m_pos_sel		= 0;
	m_IoType		= IoChar;
	m_pIoStatus		= NULL;

	m_szProfileSection[0] = 0;
}

CHcsIo::CHcsIo(IoType type, long size, const char *section)
{
	m_userData1		= 0;
	m_userData2		= 0;

	Setup(type, size, section);
}

CHcsIo::~CHcsIo()
{
	if (m_pIoStatus != NULL && m_szIoStatus > 0)
		free(m_pIoStatus);

	m_pos			= -1;
	m_pos_high		= -1;
	m_szIoStatus	= 0;
	m_pos_sel		= 0;
	m_IoType		= IoChar;
	m_pIoStatus		= NULL;
}

void CHcsIo::Setup(IoType type, long size, const char *section)
{
	CWinHcsApp	*pApp = (CWinHcsApp *) AfxGetApp();
	long		sz = size * sizeof(IoStatus);
	long		i;
	char		entry[SECTION_STR_SZ], *sP;
	CString		strValue;

	if (m_pIoStatus != NULL && m_szIoStatus > 0)
		free(m_pIoStatus);

	m_pos			= -1;
	m_pos_high		= -1;
	m_pos_sel		= 0;
	m_IoType		= type;
	m_szIoStatus	= size;
	m_pIoStatus		= (pIoStatus) malloc(sz);

	memset(m_pIoStatus, 0, sz);

	if (section != NULL) {

		strncpy(m_szProfileSection, section, SECTION_STR_SZ);
		m_szProfileSection[SECTION_STR_SZ - 1] = 0;

		for (i = 0 ; i < m_szIoStatus ; i++) {

			sprintf(entry, "IO %d", i);

			strValue = pApp->GetProfileString(m_szProfileSection, entry);
			sP = strValue.GetBuffer(MAX_IO_NAME_SZ);

			if (sP != NULL && strlen(sP) > 0)
				SetInUse(i, sP);
		}

	}	else {

		m_szProfileSection[0] = 0;
	}
}


void CHcsIo::SaveSetup(void)
{
	CWinHcsApp	*pApp = (CWinHcsApp *) AfxGetApp();
	pIoStatus	pIO	= m_pIoStatus;
	long		i;
	char		entry[SECTION_STR_SZ];
	CString		strValue;


	if (m_szProfileSection[0] != 0) {

		for (i = 0 ; i < m_szIoStatus ; i++) {

			if (pIO[i].inUse == TRUE) {

				sprintf(entry, "IO %d", i);
				pApp->WriteProfileString(m_szProfileSection, entry, pIO[i].name);
			}
		}

	}
}

//////////////////////////////////////////////////////////////////////
//
void CHcsIo::SetInUse(long index)
{
	pIoStatus pIO	= m_pIoStatus;

	if (index < m_szIoStatus) {
		pIO[index].inUse = TRUE;
		pIO[index].bBeingChanged = FALSE;
	}

	if (index > m_pos_high && index < m_szIoStatus)
		m_pos_high = index;
}

void CHcsIo::SetInUse(long index, char *pName)
{
	pIoStatus pIO	= m_pIoStatus;

	if (index < m_szIoStatus) {

		pIO[index].inUse = TRUE;
		strncpy(pIO[index].name, pName, MAX_IO_NAME_SZ);
		pIO[index].name[MAX_IO_NAME_SZ - 1] = 0;
		pIO[index].bBeingChanged = FALSE;
	}

	if (index > m_pos_high && index < m_szIoStatus)
		m_pos_high = index;
}

void CHcsIo::SetNotInUse(long index)
{
	pIoStatus	pIO	= m_pIoStatus;

	if (index < m_szIoStatus) {
		pIO[index].inUse = FALSE;
		pIO[index].bBeingChanged = FALSE;
	}

	m_pos_high = m_szIoStatus - 1;
	while (m_pos_high >= 0 && pIO[m_pos_high].inUse == FALSE)
		m_pos_high--;
}

BOOL CHcsIo::IsInUse(long index)
{
	if (index < m_szIoStatus) 
		return m_pIoStatus[index].inUse;

	return FALSE;
}

void CHcsIo::SetBeingChanged(long index)
{
	pIoStatus pIO	= m_pIoStatus;

	if (index < m_szIoStatus)
		pIO[index].bBeingChanged = TRUE;

	((CMainFrame*) AfxGetMainWnd())->UpdateHcsView();
}

BOOL CHcsIo::IsBeingChanged(long index)
{
	pIoStatus pIO	= m_pIoStatus;

	if (index < m_szIoStatus)
		return pIO[index].bBeingChanged;

	return FALSE;
}


void  CHcsIo::SetGroup(long index, char *pData)
{
	pIoStatus pIO	= m_pIoStatus;
	long			i, j, m;
	short			*pShort;
    unsigned short	mask, *pUshort;

	switch(m_IoType) {
	case IoChar:
		if (index < m_szIoStatus) {
			pIO[index].value.cValue = *pData;
			pIO[index].inUse = TRUE;
			pIO[index].bBeingChanged = FALSE;
		}
		m = index;
		break;

	case IoBool:
		i = index * 8;
		j = i + 8;
		m = j - 1;
		mask = 1;

		while (i < j && i < m_szIoStatus) {

			if (*pData & mask)	pIO[i].value.bValue = TRUE;
    		else				pIO[i].value.bValue = FALSE;

			pIO[i].inUse = TRUE;
			pIO[i].bBeingChanged = FALSE;

    		mask = mask << 1;
			i++;
		}
		break;

	case IoX10:
		pUshort = (unsigned short *) pData;

		i = (toupper(index) - 'A') * 16;
		j = i + 16;
		m = j - 1;
		mask = 1;

		while (i < j && i < m_szIoStatus) {

			if (*pUshort & mask)	pIO[i].value.bValue = TRUE;
    		else					pIO[i].value.bValue = FALSE;

			pIO[i].inUse = TRUE;
			pIO[i].bBeingChanged = FALSE;

    		mask = mask << 1;
			i++;
		}
		break;

	case IoShort:
		pShort = (short *) pData;
		j = index * 8 + 8;
		m = j - 1;
		for (i = index * 8; i < j && i < m_szIoStatus; i++, pShort++) {
			pIO[i].value.sValue = *pShort;
			pIO[i].inUse = TRUE;
			pIO[i].bBeingChanged = FALSE;
		}
		break;
	}
	if (m > m_pos_high && m < m_szIoStatus)
		m_pos_high = m;

}

long CHcsIo::GetMaxInGroup(void)
{
	return m_pos_high + 1;
}


void  CHcsIo::GetGroup(CString& strLine, long index, long lastIndex)
{
	pIoStatus pIO	= m_pIoStatus;
	CString			str;
	long			i, j;

	j = lastIndex + 1;
	if (j > m_szIoStatus)
		j = m_szIoStatus;

	for (i = index ; i < j ; i++) {

		switch(m_IoType) {
		case IoChar:
			if (pIO[i].inUse == FALSE) {
				strLine += _T(" ");
			} else {
				str.Format(_T("%d "), (long) pIO[i].value.cValue);
				strLine += str;
			}
			break;

		case IoX10:
		case IoBool:
			if (pIO[i].inUse == FALSE) {
				strLine += _T(" ");
			} else {
				if (pIO[i].value.bValue == TRUE)	strLine += _T("1");
				else								strLine += _T("0");
			}
			break;

		case IoShort:
			if (pIO[i].inUse == FALSE) {
				strLine += _T(" ");
			} else {
				str.Format(_T("%d "), (long) pIO[i].value.sValue);
				strLine += str;
			}
			break;
		}
	}
}

COLORREF  CHcsIo::GetColorIdState(long index)
{
#define	COLOR_OFF	0x00FFFFFF
#define COLOR_ON	0x0000FF00
#define COLOR_WARN	0x0030FFFF
#define	COLOR_ERROR	0x000000FF
#define COLOR_NA	::GetSysColor(CTLCOLOR_DLG)

	COLORREF	col = COLOR_ERROR;
	pIoStatus	pIO	= &m_pIoStatus[index];

	if (index < m_szIoStatus) {

		if (pIO->bBeingChanged == TRUE)

			col = COLOR_WARN;

		else {

			switch(m_IoType) {
			default:
				break;
			case IoChar:
				if (pIO->inUse == FALSE)
					col = COLOR_NA;
				else {
					switch (pIO->value.cValue) {
					case 0:
						col = COLOR_OFF;
						break;
					case 1:
						col = COLOR_ON;
						break;
					case 2:
					default:
						col = COLOR_WARN;
						break;
					}
				}
				break;

			case IoX10:
			case IoBool:
				if (pIO->inUse == FALSE)
					col = COLOR_NA;
				else {
					if (pIO->value.bValue == TRUE)	col = COLOR_ON;
					else							col = COLOR_OFF;
				}
				break;

			case IoShort:
				if (pIO->inUse == FALSE)
					col = COLOR_NA;
				else
					col = COLOR_ON;
				break;
			}
		}
	}
	return col;
}

void  CHcsIo::SetIdValue(long index, long val)
{
	pIoStatus	pIO	= &m_pIoStatus[index];

	if (index < m_szIoStatus) {

		pIO->bBeingChanged = FALSE;

		switch(m_IoType) {
		default:
			break;
		case IoChar:
			pIO->value.cValue = (char) val;
			break;

		case IoX10:
		case IoBool:
			pIO->value.bValue = (BOOL) val;
			break;

		case IoShort:
			pIO->value.sValue = (short) val;
			break;
		}
	}
}



long  CHcsIo::GetIdValue(long index)
{
	long		val = -1;
	pIoStatus	pIO	= &m_pIoStatus[index];

	if (index < m_szIoStatus) {

		switch(m_IoType) {
		default:
			break;
		case IoChar:
			val = (long) pIO->value.cValue;
			break;

		case IoX10:
		case IoBool:
			val = (long) pIO->value.bValue;
			break;

		case IoShort:
			val = (long) pIO->value.sValue;
			break;
		}
	}
	return val ;
}

BOOL CHcsIo::GetFirstIo(long *pIndex, char *pName, void *pVal, IoConfig *pCfg)
{
	m_pos = -1;
	return GetNextIo(pIndex, pName, pVal, pCfg);
}

BOOL CHcsIo::GetNextIo(long *pIndex, char *pName, void *pVal, IoConfig *pCfg)
{
	pIoStatus pIO	= m_pIoStatus;

	do {
		m_pos++;
	} while (m_pos < m_szIoStatus && pIO[m_pos].inUse == FALSE);

	if (m_pos < 0 || m_pos >= m_szIoStatus)
		return FALSE;


	*pIndex = m_pos;
	strcpy(pName, pIO[m_pos].name);
	*pCfg = pIO[m_pos].config;

	switch(m_IoType) {
	case IoChar:
		*((char *) pVal) = pIO[m_pos].value.cValue;
		break;
	case IoBool:
	case IoX10:
		*((BOOL *) pVal) = pIO[m_pos].value.bValue;
		break;
	case IoShort:
		*((short *) pVal) = pIO[m_pos].value.sValue;
		break;
	}

	return TRUE;
}



BOOL CHcsIo::GetFirstIoLabel(CString *pBuf, long *pIndex)
{
	m_pos = -1;
	return GetNextIoLabel(pBuf, pIndex);
}

BOOL CHcsIo::GetNextIoLabel(CString *pBuf, long *pIndex)
{
	pIoStatus pIO	= m_pIoStatus;
	long sz			= m_szIoStatus;
	IoType typ		= m_IoType;

	do {
		m_pos++;
	} while (m_pos < sz && pIO[m_pos].inUse == FALSE);

	if (m_pos < 0 || m_pos >= sz)
		return FALSE;

	if (m_IoType == IoX10) {

		pBuf->Format(_T("%c%d: %s"),
			((m_pos / 16) + 'A'),
			(((m_pos % 16) & 0x0F) + 1),
			pIO[m_pos].name);

	} else {

		pBuf->Format(_T("%d: %s"),  m_pos, pIO[m_pos].name);
	}

	*pIndex = m_pos;

	return TRUE;
}


char * CHcsIo::GetIoLabel(long index)
{
	pIoStatus pIO	= m_pIoStatus;

	if (index < m_szIoStatus && pIO[index].inUse == TRUE)
		return pIO[index].name;

	return NULL;
}



void CHcsIo::SetCurrentSelection(char *pszLabel)
{
	pIoStatus	pIO		= m_pIoStatus;
	long		index	= 0;

	while (index < m_szIoStatus && pIO[index].inUse == FALSE &&	stricmp(pIO[index].name, pszLabel) != 0)
		index++;

	SetCurrentSelection(index);
}

void CHcsIo::SetCurrentSelection(long index)
{
	if (index >= m_szIoStatus)
		index = 0;

	m_pos_sel = index;
}

long CHcsIo::GetCurrentSelection()
{
	if (m_pos_sel >= m_szIoStatus)
		m_pos_sel = 0;

	return m_pos_sel;
}
