/* ====================================================================
 *
 * WinHcs
 * Copyright (c) 1997-1999. Philippe Printz.		All rights reserved.
 *
 *	The WinHcs software is OSI Certified Open Source Software.
 *	OSI Certified is a certification mark of the Open Source Initiative.
 *
 *	WinHcs maybe distributed under the terms of the	GNU General Public License.
 *
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * 4. The names "WinHcs" and "HCS" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission.
 *
 * 5. Products derived from this software may not be called "WinHcs"
 *    nor may "WinHcs" appear in their names without prior written
 *    permission of the WinHcs.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Philippe Printz
 *    for use in the HCS project."
 *
 * THIS SOFTWARE IS PROVIDED BY PHILIPPE PRINTZ ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL PHILIPPE PRINTZ OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals and was originally based on software written by
 * Philippe C. Printz.
 *
 */

// DlgIo.cpp : implementation file
//

#include "stdafx.h"
#include "WinHcs.h"
#include "DlgIo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgIoDigital dialog


CDlgIoDigital::CDlgIoDigital(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgIoDigital::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgIoDigital)
	m_IoPrompt = _T("HCS IO:");
	m_IoSelected = _T("");
	//}}AFX_DATA_INIT

	m_pIo					= NULL;
	m_IoSelectedId			= 0;
	m_IoValue				= 0;
	m_disableTransparent	= FALSE;

	strcpy(m_Title, _T("?Dialog?"));
}


void CDlgIoDigital::DoDataExchange(CDataExchange* pDX)
{
	long	sz;

	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CDlgIoDigital)
	DDX_Text(pDX, IDC_IO_NAME_PROMPT, m_IoPrompt);
	DDX_CBString(pDX, IDC_IO_NAME_VALUE, m_IoSelected);
	DDV_MaxChars(pDX, m_IoSelected, 40);
	//}}AFX_DATA_MAP


	// Extract the HCS IO id
	if ((sz = m_IoSelected.GetLength()) > 0) 
		m_IoSelectedId = (unsigned short) atol(m_IoSelected.GetBuffer(sz));
	else
		m_IoSelectedId = -1;


	// Save the current selection for next time
	if (m_pIo != NULL && pDX->m_bSaveAndValidate == TRUE) {

		m_pIo->SetCurrentSelection(m_IoSelectedId);
		m_pIo->m_userData2 = m_IoValue;
	}
}


BEGIN_MESSAGE_MAP(CDlgIoDigital, CDialog)
	//{{AFX_MSG_MAP(CDlgIoDigital)
	ON_BN_CLICKED(IDC_RADIO_ON, OnRadioOn)
	ON_BN_CLICKED(IDC_RADIO_OFF, OnRadioOff)
	ON_BN_CLICKED(IDC_RADIO_TRANSPARENT, OnRadioTransparent)
	ON_CBN_SELCHANGE(IDC_IO_NAME_VALUE, OnSelchangeIoNameValue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgIoDigital message handlers

BOOL CDlgIoDigital::OnInitDialog() 
{
	CComboBox	*pBox;
	CButton		*pBtnOn, *pBtnOff, *pBtnTrans;
	CString		str;
	long		i = 0, pos = 0, idx = 0;


	CDialog::OnInitDialog();


	// For combobox to select HCS IO
	pBox = (CComboBox *) GetDlgItem(IDC_IO_NAME_VALUE);
	pBox->ResetContent();


	if (m_pIo != NULL && m_pIo->GetFirstIoLabel(&str, &pos) == TRUE) {

		if ((m_IoSelectedId = m_pIo->GetCurrentSelection()) < 0)
			m_IoSelectedId = 0;

		i = pBox->AddString(str);
		if (pos == m_IoSelectedId)
			idx = i;

		while (m_pIo->GetNextIoLabel(&str, &pos) == TRUE) {
			i = pBox->AddString(str);

			if (pos == m_IoSelectedId)
				idx = i;
		}
	}
	pBox->SetCurSel(idx);


	// And no for current value
	pBtnOn		= (CButton *) GetDlgItem(IDC_RADIO_ON);
	pBtnOff		= (CButton *) GetDlgItem(IDC_RADIO_OFF);
	pBtnTrans	= (CButton *) GetDlgItem(IDC_RADIO_TRANSPARENT);


	// Setup value selection
	m_IoValue = m_pIo->m_userData2;


	if (m_disableTransparent == TRUE) {

		pBtnTrans->EnableWindow(FALSE);

		if (m_IoValue == IO_VALUE_TRANSP)
			m_IoValue = IO_VALUE_OFF;
	}


	switch( m_IoValue ) {
	default:
		m_IoValue = IO_VALUE_OFF;

	case IO_VALUE_OFF:
		pBtnOn->SetCheck(0);
		pBtnOff->SetCheck(1);
		pBtnTrans->SetCheck(0);
		break;

	case IO_VALUE_ON:
		pBtnOn->SetCheck(1);
		pBtnOff->SetCheck(0);
		pBtnTrans->SetCheck(0);
		break;

	case IO_VALUE_TRANSP:
		pBtnOn->SetCheck(0);
		pBtnOff->SetCheck(0);
		pBtnTrans->SetCheck(1);
		break;
	}


	// Set Window Title
	SetWindowText(m_Title);
	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



void CDlgIoDigital::OnRadioOn() 
{
	m_IoValue = IO_VALUE_ON;
}

void CDlgIoDigital::OnRadioOff() 
{
	m_IoValue = IO_VALUE_OFF;
}

void CDlgIoDigital::OnRadioTransparent() 
{
	m_IoValue = IO_VALUE_TRANSP;
}

void CDlgIoDigital::OnSelchangeIoNameValue() 
{
}


/////////////////////////////////////////////////////////////////////////////
// CDlgIoAnalog dialog


CDlgIoAnalog::CDlgIoAnalog(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgIoAnalog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgIoAnalog)
	m_IoPrompt = _T("HCS Analog IO:");
	m_IoSelected = _T("");
	m_IoValue = 0;
	m_IoValueTransparent = FALSE;
	m_IoSliderValue = 0;
	//}}AFX_DATA_INIT

	m_pIo					= NULL;
	m_IoSelectedId			= 0;
	m_disableTransparent	= FALSE;
	m_min					= 0;
	m_max					= 255;
	m_bNoUpdate				= FALSE;

	strcpy(m_Title, _T("?Dialog?"));
}


void CDlgIoAnalog::DoDataExchange(CDataExchange* pDX)
{
	long	sz;

	CDialog::DoDataExchange(pDX);

	if (m_pIo != NULL && pDX->m_bSaveAndValidate == FALSE) {
		m_IoValue = m_pIo->m_userData2;
		m_IoSliderValue = m_IoValue;
	}


	//{{AFX_DATA_MAP(CDlgIoAnalog)
	DDX_Text(pDX, IDC_IO_NAME_PROMPT, m_IoPrompt);
	DDX_CBString(pDX, IDC_IO_NAME_VALUE, m_IoSelected);
	DDV_MaxChars(pDX, m_IoSelected, 40);
	DDX_Text(pDX, IDC_IO_VALUE, m_IoValue);
	DDV_MinMaxLong(pDX, m_IoValue, m_min, m_max);
	DDX_Check(pDX, IDC_IO_VALUE_TRANSPARENT, m_IoValueTransparent);
	DDX_Slider(pDX, IDC_SLIDER_VALUE, m_IoSliderValue);
	//}}AFX_DATA_MAP


	// Extract the HCS IO id
	if ((sz = m_IoSelected.GetLength()) > 0) 
		m_IoSelectedId = (unsigned short) atol(m_IoSelected.GetBuffer(sz));
	else
		m_IoSelectedId = -1;


	// Save the current selection for next time
	if (m_pIo != NULL && pDX->m_bSaveAndValidate == TRUE) {

		m_pIo->SetCurrentSelection(m_IoSelectedId);
		m_pIo->m_userData2 = m_IoValue;
	}
}


BEGIN_MESSAGE_MAP(CDlgIoAnalog, CDialog)
	//{{AFX_MSG_MAP(CDlgIoAnalog)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_VALUE, OnReleasedcaptureSliderValue)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_IO_VALUE_TRANSPARENT, OnIoValueTransparent)
	//}}AFX_MSG_MAP
	ON_EN_CHANGE(IDC_IO_VALUE, OnEditChange )
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgIoAnalog message handlers

BOOL CDlgIoAnalog::OnInitDialog() 
{
	CComboBox		*pBox;
	CButton			*pCheck;
	CSpinButtonCtrl	*pSpin;
	CSliderCtrl		*pSlider;
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_IO_VALUE);
	CString			str;
	long			i = 0, pos = 0, idx = 0;


	CDialog::OnInitDialog();


	// For combobox to select HCS IO
	pBox = (CComboBox *) GetDlgItem(IDC_IO_NAME_VALUE);
	pBox->ResetContent();


	if (m_pIo != NULL && m_pIo->GetFirstIoLabel(&str, &pos) == TRUE) {

		if ((m_IoSelectedId = m_pIo->GetCurrentSelection()) < 0)
			m_IoSelectedId = 0;

		i = pBox->AddString(str);
		if (pos == m_IoSelectedId)
			idx = i;

		while (m_pIo->GetNextIoLabel(&str, &pos) == TRUE) {
			i = pBox->AddString(str);

			if (pos == m_IoSelectedId)
				idx = i;
		}
	}
	pBox->SetCurSel(idx);


	// Setup value selection
	if (m_disableTransparent == TRUE) {

		pCheck = (CButton *) GetDlgItem(IDC_IO_VALUE_TRANSPARENT);
		pCheck->ShowWindow(SW_HIDE);

	}

	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_IO_VALUE_SPIN);
	pSpin->SetRange(m_min, m_max);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);


	pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_VALUE);
	pSlider->SetRange(m_min, m_max, TRUE);
	pSlider->SetPos(m_IoSliderValue);


	// Set Window Title
	SetWindowText(m_Title);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CDlgIoAnalog::OnReleasedcaptureSliderValue(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_VALUE);
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_IO_VALUE);
	char			msg[32];

	m_IoSliderValue = pSlider->GetPos();
	m_IoValue = m_IoSliderValue;

	sprintf(msg, "%d", m_IoSliderValue);
	pEdit->SetWindowText(msg);

	*pResult = 0;
}


void CDlgIoAnalog::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_IO_VALUE);
	char			msg[32];

	m_IoSliderValue = nPos;

	if (m_IoSliderValue != m_IoValue) {

		m_IoValue = m_IoSliderValue;

		sprintf(msg, "%d", m_IoSliderValue);

		m_bNoUpdate = TRUE;
		pEdit->SetWindowText(msg);
		m_bNoUpdate = FALSE;
	}

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}


void CDlgIoAnalog::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

afx_msg void CDlgIoAnalog::OnEditChange()
{
	if (m_bNoUpdate == FALSE) {

		CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_VALUE);
		CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_IO_VALUE);
		char			msg[32];

		if (pSlider != NULL && pEdit != NULL) {

			pEdit->GetWindowText(msg, 32);
			m_IoValue = atol(msg);

			if (m_IoSliderValue != m_IoValue) {

				m_IoSliderValue = m_IoValue;
				pSlider->SetPos(m_IoSliderValue);
			}
		}
	}
}



void CDlgIoAnalog::OnIoValueTransparent() 
{
	CButton			*pButton	= (CButton *) GetDlgItem(IDC_IO_VALUE_TRANSPARENT);
	CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_VALUE);
	CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_IO_VALUE);
	UINT			state		= pButton->GetState();
	BOOL			bVal		= FALSE;

	state &= 0x03;

	if (state == 0)
		bVal = TRUE;

	pSlider->EnableWindow(bVal);
	pEdit->EnableWindow(bVal);
}

/////////////////////////////////////////////////////////////////////////////
// CDlgGetVariable dialog


CDlgGetVariable::CDlgGetVariable(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgGetVariable::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgGetVariable)
	m_IoPrompt = _T("HCS Variable:");
	m_IoSelected = _T("");
	//}}AFX_DATA_INIT

	m_pIo					= NULL;
	m_IoSelectedId			= 0;

	strcpy(m_Title, _T("?Dialog?"));
}


void CDlgGetVariable::DoDataExchange(CDataExchange* pDX)
{
	long	sz;

	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CDlgGetVariable)
	DDX_CBString(pDX, IDC_IO_NAME_VALUE, m_IoSelected);
	DDV_MaxChars(pDX, m_IoSelected, 40);
	DDX_Text(pDX, IDC_IO_NAME_PROMPT, m_IoPrompt);
	//}}AFX_DATA_MAP

	// Extract the HCS IO id
	if ((sz = m_IoSelected.GetLength()) > 0) 
		m_IoSelectedId = (unsigned short) atol(m_IoSelected.GetBuffer(sz));
	else
		m_IoSelectedId = -1;


	// Save the current selection for next time
	if (m_pIo != NULL && pDX->m_bSaveAndValidate == TRUE)
		m_pIo->SetCurrentSelection(m_IoSelectedId);
}


BEGIN_MESSAGE_MAP(CDlgGetVariable, CDialog)
	//{{AFX_MSG_MAP(CDlgGetVariable)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgGetVariable message handlers

BOOL CDlgGetVariable::OnInitDialog() 
{
	CComboBox		*pBox;
	CString			str;
	long			i = 0, pos = 0, idx = 0;


	CDialog::OnInitDialog();


	// For combobox to select HCS IO
	pBox = (CComboBox *) GetDlgItem(IDC_IO_NAME_VALUE);
	pBox->ResetContent();


	if (m_pIo != NULL && m_pIo->GetFirstIoLabel(&str, &pos) == TRUE) {

		if ((m_IoSelectedId = m_pIo->GetCurrentSelection()) < 0)
			m_IoSelectedId = 0;

		i = pBox->AddString(str);
		if (pos == m_IoSelectedId)
			idx = i;

		while (m_pIo->GetNextIoLabel(&str, &pos) == TRUE) {
			i = pBox->AddString(str);

			if (pos == m_IoSelectedId)
				idx = i;
		}
	}
	pBox->SetCurSel(idx);

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
/////////////////////////////////////////////////////////////////////////////
// CDlgIoNetwork dialog


CDlgIoNetwork::CDlgIoNetwork(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgIoNetwork::IDD, pParent)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	//{{AFX_DATA_INIT(CDlgIoNetwork)
	m_cmd = pApp->GetProfileCString(IDS_REG_HCS, IDS_REG_NETWORK, _T(""));
	//}}AFX_DATA_INIT
}


void CDlgIoNetwork::DoDataExchange(CDataExchange* pDX)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();

	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CDlgIoNetwork)
	DDX_Text(pDX, IDC_EDIT, m_cmd);
	DDV_MaxChars(pDX, m_cmd, 80);
	//}}AFX_DATA_MAP

	if (pDX->m_bSaveAndValidate == TRUE)
		pApp->SetProfileCString(IDS_REG_HCS, IDS_REG_NETWORK, m_cmd);
}


BEGIN_MESSAGE_MAP(CDlgIoNetwork, CDialog)
	//{{AFX_MSG_MAP(CDlgIoNetwork)
	ON_BN_CLICKED(IDC_SEND, OnSend)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CDlgIoNetwork::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CEdit *pEdit = (CEdit *) GetDlgItem(IDC_EDIT);
	pEdit->SetFocus();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgIoNetwork::OnSend() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CString				str;
	long				n;
	char				cmd = 0x30;
	char				*pCmd;

	UpdateData(TRUE);

	str.Format("!%c%s", cmd, m_cmd);

	n	= str.GetLength() + 1;
	pCmd= str.GetBuffer(n);

	pDoc->SendMessageToHcs(pCmd, n);
}

/////////////////////////////////////////////////////////////////////////////
// CDlgIoVoice dialog

CDlgIoVoice::CDlgIoVoice(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgIoVoice::IDD, pParent)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();

	//{{AFX_DATA_INIT(CDlgIoVoice)
	m_TextToSpeak = pApp->GetProfileCString(IDS_REG_HCS, IDS_REG_VOICE, _T(""));
	m_Volume = pApp->GetProfileLong(IDS_REG_HCS, IDS_REG_VOLUME, 5);
	m_FormantFreq = pApp->GetProfileLong(IDS_REG_HCS, IDS_REG_FORMANT, 0x5F);
	m_Pitch = pApp->GetProfileLong(IDS_REG_HCS, IDS_REG_PITCH, 50);
	m_Speed = pApp->GetProfileLong(IDS_REG_HCS, IDS_REG_SPEED, 5);
	m_EnableIntonation = pApp->GetProfileLong(IDS_REG_HCS, IDS_REG_INTONATION, FALSE);

	m_SliderVolume = m_Volume;
	m_SliderFormantFreq = m_FormantFreq;
	m_SliderSpeed = m_Speed;
	m_SliderPitch = m_Speed;
	//}}AFX_DATA_INIT

	m_Tone = pApp->GetProfileLong(IDS_REG_HCS, IDS_REG_TONE, 1);
	m_bNoUpdate = FALSE;
}


void CDlgIoVoice::DoDataExchange(CDataExchange* pDX)
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();

	CDialog::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CDlgIoVoice)
	DDX_Check(pDX, IDC_INTONATION, m_EnableIntonation);
	DDX_Slider(pDX, IDC_SLIDER_FORMANT, m_SliderFormantFreq);
	DDX_Text(pDX, IDC_FORMANT, m_FormantFreq);
	DDV_MinMaxInt(pDX, m_FormantFreq, 16, 159);
	DDX_Text(pDX, IDC_PITCH, m_Pitch);
	DDV_MinMaxInt(pDX, m_Pitch, 0, 99);
	DDX_Slider(pDX, IDC_SLIDER_PITCH, m_SliderPitch);
	DDX_Slider(pDX, IDC_SLIDER_SPEED, m_SliderSpeed);
	DDX_Slider(pDX, IDC_SLIDER_VOLUME, m_SliderVolume);
	DDX_Text(pDX, IDC_SPEED, m_Speed);
	DDV_MinMaxInt(pDX, m_Speed, 0, 9);
	DDX_Text(pDX, IDC_VOLUME, m_Volume);
	DDV_MinMaxInt(pDX, m_Volume, 0, 9);
	DDX_Text(pDX, IDC_EDIT, m_TextToSpeak);
	DDV_MaxChars(pDX, m_TextToSpeak, 80);
	//}}AFX_DATA_MAP

	if (pDX->m_bSaveAndValidate == TRUE) {

		pApp->SetProfileCString(IDS_REG_HCS, IDS_REG_VOICE, m_TextToSpeak);

		pApp->SetProfileLong(IDS_REG_HCS, IDS_REG_VOLUME, m_Volume);
		pApp->SetProfileLong(IDS_REG_HCS, IDS_REG_FORMANT, m_FormantFreq);
		pApp->SetProfileLong(IDS_REG_HCS, IDS_REG_PITCH, m_Pitch);
		pApp->SetProfileLong(IDS_REG_HCS, IDS_REG_SPEED, m_Speed);
		pApp->SetProfileLong(IDS_REG_HCS, IDS_REG_INTONATION, m_EnableIntonation);
		pApp->SetProfileLong(IDS_REG_HCS, IDS_REG_TONE, m_Tone);
	}

}


BEGIN_MESSAGE_MAP(CDlgIoVoice, CDialog)
	//{{AFX_MSG_MAP(CDlgIoVoice)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_BN_CLICKED(IDC_SPEAK, OnSpeak)
	ON_BN_CLICKED(IDC_TONE_BASS, OnToneBass)
	ON_BN_CLICKED(IDC_TONE_NORMAL, OnToneNormal)
	ON_BN_CLICKED(IDC_TONE_TREBLE, OnToneTreble)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_VOLUME, OnReleasedcaptureSliderVolume)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_FORMANT, OnReleasedcaptureSliderFormant)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_SPEED, OnReleasedcaptureSliderSpeed)
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_PITCH, OnReleasedcaptureSliderPitch)
	//}}AFX_MSG_MAP
	ON_EN_CHANGE(IDC_VOLUME, OnVolumeChange)
	ON_EN_CHANGE(IDC_FORMANT, OnFormantChange)
	ON_EN_CHANGE(IDC_SPEED, OnSpeedChange)
	ON_EN_CHANGE(IDC_PITCH, OnPitchChange)
END_MESSAGE_MAP()


BOOL CDlgIoVoice::OnInitDialog() 
{
	CSpinButtonCtrl	*pSpin;
	CSliderCtrl		*pSlider;
	CEdit			*pEdit;
	CButton			*pBtn;

	CDialog::OnInitDialog();

	
	pEdit	= (CEdit *) GetDlgItem(IDC_EDIT);
	pEdit->SetFocus();


	pSpin	= (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_VOLUME);
	pSpin->SetRange(0, 9);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);

	pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_VOLUME);
	pSlider->SetRange(0, 9, TRUE);
	pSlider->SetPos(m_Volume);

	pSpin	= (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_FORMANT);
	pSpin->SetRange(16, 159);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);

	pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_FORMANT);
	pSlider->SetRange(16, 159, TRUE);
	pSlider->SetPos(m_FormantFreq);


	pSpin	= (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_SPEED);
	pSpin->SetRange(0, 9);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);

	pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_SPEED);
	pSlider->SetRange(0, 9, TRUE);
	pSlider->SetPos(m_Speed);


	pSpin	= (CSpinButtonCtrl *) GetDlgItem(IDC_SPIN_PITCH);
	pSpin->SetRange(0, 99);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);

	pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_PITCH);
	pSlider->SetRange(0, 99, TRUE);
	pSlider->SetPos(m_Pitch);


	switch(m_Tone) {
	default:
	case 1:
		pBtn = (CButton *) GetDlgItem(IDC_TONE_NORMAL);
		pBtn->SetCheck(1);
		break;
	case 0:
		pBtn = (CButton *) GetDlgItem(IDC_TONE_BASS);
		pBtn->SetCheck(1);
		break;
	case 2:
		pBtn = (CButton *) GetDlgItem(IDC_TONE_TREBLE);
		pBtn->SetCheck(1);
		break;
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgIoVoice::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CEdit			*pEdit = NULL;
	UINT			pos;
	long			id = pScrollBar->GetDlgCtrlID();
	char			msg[32];

	switch (id) {
	default:
		break;
	case IDC_SLIDER_VOLUME:
		pEdit	= (CEdit *)	GetDlgItem(IDC_VOLUME);
		break;
	case IDC_SLIDER_FORMANT:
		pEdit	= (CEdit *)	GetDlgItem(IDC_FORMANT);
		break;
	case IDC_SLIDER_SPEED:
		pEdit	= (CEdit *)	GetDlgItem(IDC_SPEED);
		break;
	case IDC_SLIDER_PITCH:
		pEdit	= (CEdit *)	GetDlgItem(IDC_PITCH);
		break;
	}

	if (pEdit != NULL) {

		pEdit->GetWindowText(msg, 32);
		pos = (UINT) atol(msg);

		if (nPos != pos) {

			sprintf(msg, "%d", nPos);

			m_bNoUpdate = TRUE;
			pEdit->SetWindowText(msg);
			m_bNoUpdate = FALSE;
		}
	}
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDlgIoVoice::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}


void CDlgIoVoice::OnReleasedcaptureSliderVolume(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_VOLUME);
	CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_VOLUME);
	char			msg[32];

	m_Volume = pSlider->GetPos();

	sprintf(msg, "%d", m_Volume);
	pEdit->SetWindowText(msg);
	
	*pResult = 0;
}

void CDlgIoVoice::OnReleasedcaptureSliderFormant(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_FORMANT);
	CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_FORMANT);
	char			msg[32];
	
	m_FormantFreq = pSlider->GetPos();

	sprintf(msg, "%d", m_FormantFreq);
	pEdit->SetWindowText(msg);
	
	*pResult = 0;
}

void CDlgIoVoice::OnReleasedcaptureSliderSpeed(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_SPEED);
	CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_SPEED);
	char			msg[32];
	
	m_Speed = pSlider->GetPos();

	sprintf(msg, "%d", m_Speed);
	pEdit->SetWindowText(msg);

	*pResult = 0;
}

void CDlgIoVoice::OnReleasedcaptureSliderPitch(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_PITCH);
	CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_PITCH);
	char			msg[32];

	m_Pitch = pSlider->GetPos();

	sprintf(msg, "%d", m_Pitch);
	pEdit->SetWindowText(msg);
	
	*pResult = 0;
}


afx_msg void CDlgIoVoice::OnVolumeChange()
{
	if (m_bNoUpdate == FALSE) {

		CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_VOLUME);
		CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_VOLUME);
		long			nPos, pos;
		char			msg[32];

		if (pSlider != NULL && pEdit != NULL) {

			pEdit->GetWindowText(msg, 32);
			nPos = atol(msg);

			pos = pSlider->GetPos();

			if (nPos != pos)
				pSlider->SetPos(nPos);
		}
	}
}

afx_msg void CDlgIoVoice::OnFormantChange()
{
	if (m_bNoUpdate == FALSE) {

		CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_FORMANT);
		CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_FORMANT);
		long			nPos, pos;
		char			msg[32];

		if (pSlider != NULL && pEdit != NULL) {

			pEdit->GetWindowText(msg, 32);
			nPos = atol(msg);

			pos = pSlider->GetPos();

			if (nPos != pos)
				pSlider->SetPos(nPos);
		}
	}
}

afx_msg void CDlgIoVoice::OnSpeedChange()
{
	if (m_bNoUpdate == FALSE) {

		CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_SPEED);
		CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_SPEED);
		long			nPos, pos;
		char			msg[32];

		if (pSlider != NULL && pEdit != NULL) {

			pEdit->GetWindowText(msg, 32);
			nPos = atol(msg);

			pos = pSlider->GetPos();

			if (nPos != pos)
				pSlider->SetPos(nPos);
		}
	}
}


afx_msg void CDlgIoVoice::OnPitchChange()
{
	if (m_bNoUpdate == FALSE) {

		CSliderCtrl		*pSlider	= (CSliderCtrl *) GetDlgItem(IDC_SLIDER_PITCH);
		CEdit			*pEdit		= (CEdit *) GetDlgItem(IDC_PITCH);
		long			nPos, pos;
		char			msg[32];

		if (pSlider != NULL && pEdit != NULL) {

			pEdit->GetWindowText(msg, 32);
			nPos = atol(msg);

			pos = pSlider->GetPos();

			if (nPos != pos)
				pSlider->SetPos(nPos);
		}
	}
}

void CDlgIoVoice::OnToneBass() 
{
	m_Tone = 0;
}

void CDlgIoVoice::OnToneNormal() 
{
	m_Tone = 1;
}

void CDlgIoVoice::OnToneTreble() 
{
	m_Tone = 2;
}


void CDlgIoVoice::OnSpeak() 
{
	CWinHcsApp			*pApp = (CWinHcsApp *) AfxGetApp();
	CWinHcsStatusDoc	*pDoc = pApp->GetHcsStatusDoc();
	CString				str;
	long				n;
	char				cmd = 0x31;
	char				*pIntonation = "~E";
	char				*pTone;
	char				*pCmd;

	UpdateData(TRUE);

	if (m_EnableIntonation == FALSE)
		pIntonation = "~M";

	switch(m_Tone) {
	default:
	case 0:
		pTone = "~0X";
		break;
	case 1:
		pTone = "~1X";
		break;
	case 2:
		pTone = "~2X";
		break;
	}

	str.Format("!%c~%dV ~%dF ~%dS ~%dP %s %s %s",
		cmd, m_Volume, m_FormantFreq, m_Speed, m_Pitch, pTone, pIntonation, m_TextToSpeak);

	n	= str.GetLength() + 1;
	pCmd= str.GetBuffer(n);

	pDoc->SendMessageToHcs(pCmd, n);
}




/////////////////////////////////////////////////////////////////////////////
// CDlgIoX10 dialog


CDlgIoX10::CDlgIoX10(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgIoX10::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgIoX10)
	m_IoSelected = _T("");
	m_Brightness = 0;
	m_SliderBrightness = 0;
	//}}AFX_DATA_INIT

	m_pIo			= NULL;
	m_IoSelectedId	= 0;
	m_Operation		= 0;
	m_bNoUpdate		= FALSE;
}


void CDlgIoX10::DoDataExchange(CDataExchange* pDX)
{
	long	sz;
	char	*sP;

	CDialog::DoDataExchange(pDX);

	if (m_pIo != NULL && pDX->m_bSaveAndValidate == FALSE) {

		m_Operation			= m_pIo->m_userData1;
		m_Brightness		= m_pIo->m_userData2;

		if (m_Operation < 0 || m_Operation > 4)
			m_Operation = 2;

		if (m_Brightness < 1 || m_Brightness > 31)
			m_Brightness = 0;

		m_SliderBrightness	= m_Brightness;
	}


	//{{AFX_DATA_MAP(CDlgIoX10)
	DDX_CBString(pDX, IDC_IO_NAME_VALUE, m_IoSelected);
	DDV_MaxChars(pDX, m_IoSelected, 40);
	DDX_Text(pDX, IDC_BRIGHTNESS, m_Brightness);
	DDV_MinMaxLong(pDX, m_Brightness, -31, 31);
	DDX_Slider(pDX, IDC_SLIDER_BRIDHTNESS, m_SliderBrightness);
	//}}AFX_DATA_MAP


	// Extract the HCS IO id
	if ((sz = m_IoSelected.GetLength()) > 0) {

		sP = m_IoSelected.GetBuffer(sz);
		m_IoSelectedId = (unsigned short) ((toupper(sP[0]) - 'A') << 4);
		m_IoSelectedId = m_IoSelectedId | (unsigned short) ((atol(&sP[1]) - 1) & 0x0F);

	} else
		m_IoSelectedId = 0;

	// Save the current selection for next time
	if (m_pIo != NULL && pDX->m_bSaveAndValidate == TRUE) {

		m_pIo->SetCurrentSelection(m_IoSelectedId);
		m_pIo->m_userData1 = m_Operation;
		m_pIo->m_userData2 = m_Brightness;
	}
}


BEGIN_MESSAGE_MAP(CDlgIoX10, CDialog)
	//{{AFX_MSG_MAP(CDlgIoX10)
	ON_BN_CLICKED(IDC_RADIO_ALLON, OnRadioAllon)
	ON_BN_CLICKED(IDC_RADIO_ALLOFF, OnRadioAlloff)
	ON_BN_CLICKED(IDC_RADIO_ON, OnRadioOn)
	ON_BN_CLICKED(IDC_RADIO_OFF, OnRadioOff)
	ON_BN_CLICKED(IDC_RADIO_BRIGHTNESS, OnRadioBrightness)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_BRIDHTNESS, OnReleasedcaptureSliderBridhtness)
	//}}AFX_MSG_MAP
	ON_EN_CHANGE(IDC_BRIGHTNESS, OnEditChange )
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgIoX10 message handlers

void CDlgIoX10::OnRadioAllon() 
{
	CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);

	pEdit->EnableWindow(FALSE);
	pSlider->EnableWindow(FALSE);

	m_Operation = 1;
}

void CDlgIoX10::OnRadioAlloff() 
{
	CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);

	pEdit->EnableWindow(FALSE);
	pSlider->EnableWindow(FALSE);

	m_Operation = 0;
}

void CDlgIoX10::OnRadioOn() 
{
	CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);

	pEdit->EnableWindow(FALSE);
	pSlider->EnableWindow(FALSE);

	m_Operation = 2;
}

void CDlgIoX10::OnRadioOff() 
{
	CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);

	pEdit->EnableWindow(FALSE);
	pSlider->EnableWindow(FALSE);

	m_Operation = 3;
}

void CDlgIoX10::OnRadioBrightness() 
{
	CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);

	pEdit->EnableWindow(TRUE);
	pSlider->EnableWindow(TRUE);

	m_Operation = 4; // 4 Dim, 5 Bright
}


void CDlgIoX10::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);
	char			msg[32];

	m_SliderBrightness = nPos;

	if (m_SliderBrightness != m_Brightness) {

		m_Brightness = m_SliderBrightness;

		sprintf(msg, "%d", m_SliderBrightness);

		m_bNoUpdate = TRUE;
		pEdit->SetWindowText(msg);
		m_bNoUpdate = FALSE;
	}

	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDlgIoX10::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{	
	CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CDlgIoX10::OnReleasedcaptureSliderBridhtness(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);
	char			msg[32];

	m_SliderBrightness = pSlider->GetPos();
	m_Brightness = m_SliderBrightness;

	sprintf(msg, "%d", m_SliderBrightness);
	pEdit->SetWindowText(msg);
	
	*pResult = 0;
}


afx_msg void CDlgIoX10::OnEditChange()
{
	if (m_bNoUpdate == FALSE) {

		CSliderCtrl		*pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
		CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);
		char			msg[32];

		if (pSlider != NULL && pEdit != NULL) {

			pEdit->GetWindowText(msg, 32);
			m_Brightness = atol(msg);

			if (m_SliderBrightness != m_Brightness) {

				m_SliderBrightness = m_Brightness;
				pSlider->SetPos(m_SliderBrightness);
			}
		}
	}
}


BOOL CDlgIoX10::OnInitDialog() 
{
	CComboBox		*pBox;
	CButton			*pBtn;
	CSpinButtonCtrl	*pSpin;
	CSliderCtrl		*pSlider;
	CEdit			*pEdit = (CEdit *) GetDlgItem(IDC_BRIGHTNESS);
	CString			str;
	long			i = 0, pos = 0, idx = 0;

	CDialog::OnInitDialog();
	
	// For combobox to select HCS IO
	pBox = (CComboBox *) GetDlgItem(IDC_IO_NAME_VALUE);
	pBox->ResetContent();


	if (m_pIo != NULL && m_pIo->GetFirstIoLabel(&str, &pos) == TRUE) {

		if ((m_IoSelectedId = m_pIo->GetCurrentSelection()) < 0)
			m_IoSelectedId = 0;

		i = pBox->AddString(str);
		if (pos == m_IoSelectedId)
			idx = i;

		while (m_pIo->GetNextIoLabel(&str, &pos) == TRUE) {
			i = pBox->AddString(str);

			if (pos == m_IoSelectedId)
				idx = i;
		}
	}
	pBox->SetCurSel(idx);


	// And no for current value
	switch (m_Operation) {
	default:
	case 0:
		m_Operation = 0;
		pBtn = (CButton *) GetDlgItem(IDC_RADIO_ALLOFF);
		pBtn->SetCheck(1);
		OnRadioAlloff();
		break;
	case 1:
		pBtn = (CButton *) GetDlgItem(IDC_RADIO_ALLON);
		pBtn->SetCheck(1);
		OnRadioAllon();
		break;
	case 2:
		pBtn = (CButton *) GetDlgItem(IDC_RADIO_ON);
		pBtn->SetCheck(1);
		OnRadioOn();
		break;
	case 3:
		pBtn = (CButton *) GetDlgItem(IDC_RADIO_OFF);
		pBtn->SetCheck(1);
		OnRadioOff();
		break;
	case 4:
		pBtn = (CButton *) GetDlgItem(IDC_RADIO_BRIGHTNESS);
		pBtn->SetCheck(1);
		OnRadioBrightness();
		break;
	}

	pSpin = (CSpinButtonCtrl *) GetDlgItem(IDC_BRIGHTNESS_SPIN);
	pSpin->SetRange(-31, 31);
	pSpin->SetAccel(GLB_ACC_SZ, GLB_Acc);

	pSlider = (CSliderCtrl *) GetDlgItem(IDC_SLIDER_BRIDHTNESS);
	pSlider->SetRange(-31, 31, TRUE);
	pSlider->SetPos(m_SliderBrightness);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

